/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format.cow.vector;

import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.types.RowKind;
import org.apache.hudi.table.format.cow.vector.HeapArrayVector;
import org.apache.hudi.table.format.cow.vector.HeapRowColumnVector;

public class ColumnarGroupRowData
implements RowData {
    HeapRowColumnVector vector;
    int rowId;
    int index;

    public ColumnarGroupRowData(HeapRowColumnVector vector, int rowId, int index) {
        this.vector = vector;
        this.rowId = rowId;
        this.index = index;
    }

    public int getArity() {
        return this.vector.vectors.length;
    }

    public RowKind getRowKind() {
        return RowKind.INSERT;
    }

    public void setRowKind(RowKind rowKind) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    public boolean isNullAt(int pos) {
        return this.vector.vectors[pos].isNullAt(this.rowId) || ((HeapArrayVector)this.vector.vectors[pos]).getArray(this.rowId).isNullAt(this.index);
    }

    public boolean getBoolean(int pos) {
        return ((HeapArrayVector)this.vector.vectors[pos]).getArray(this.rowId).getBoolean(this.index);
    }

    public byte getByte(int pos) {
        return ((HeapArrayVector)this.vector.vectors[pos]).getArray(this.rowId).getByte(this.index);
    }

    public short getShort(int pos) {
        return ((HeapArrayVector)this.vector.vectors[pos]).getArray(this.rowId).getShort(this.index);
    }

    public int getInt(int pos) {
        return ((HeapArrayVector)this.vector.vectors[pos]).getArray(this.rowId).getInt(this.index);
    }

    public long getLong(int pos) {
        return ((HeapArrayVector)this.vector.vectors[pos]).getArray(this.rowId).getLong(this.index);
    }

    public float getFloat(int pos) {
        return ((HeapArrayVector)this.vector.vectors[pos]).getArray(this.rowId).getFloat(this.index);
    }

    public double getDouble(int pos) {
        return ((HeapArrayVector)this.vector.vectors[pos]).getArray(this.rowId).getDouble(this.index);
    }

    public StringData getString(int pos) {
        return ((HeapArrayVector)this.vector.vectors[pos]).getArray(this.rowId).getString(this.index);
    }

    public DecimalData getDecimal(int pos, int i1, int i2) {
        return ((HeapArrayVector)this.vector.vectors[pos]).getArray(this.rowId).getDecimal(this.index, i1, i2);
    }

    public TimestampData getTimestamp(int pos, int i1) {
        return ((HeapArrayVector)this.vector.vectors[pos]).getArray(this.rowId).getTimestamp(this.index, i1);
    }

    public <T> RawValueData<T> getRawValue(int pos) {
        return ((HeapArrayVector)this.vector.vectors[pos]).getArray(this.rowId).getRawValue(this.index);
    }

    public byte[] getBinary(int pos) {
        return ((HeapArrayVector)this.vector.vectors[pos]).getArray(this.rowId).getBinary(this.index);
    }

    public ArrayData getArray(int pos) {
        return ((HeapArrayVector)this.vector.vectors[pos]).getArray(this.rowId).getArray(this.index);
    }

    public MapData getMap(int pos) {
        return ((HeapArrayVector)this.vector.vectors[pos]).getArray(this.rowId).getMap(this.index);
    }

    public RowData getRow(int pos, int numFields) {
        return ((HeapArrayVector)this.vector.vectors[pos]).getArray(this.rowId).getRow(this.index, numFields);
    }
}

