/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.source.JsonStringToHoodieRecordMapFunction;
import org.apache.hudi.testutils.HoodieFlinkClientTestHarness;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TestJsonStringToHoodieRecordMapFunction
extends HoodieFlinkClientTestHarness {
    @BeforeEach
    public void init() {
        this.initPath();
        this.initTestDataGenerator();
        this.initFileSystem();
        this.initFlinkMiniCluster();
    }

    @AfterEach
    public void clean() throws Exception {
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
        this.cleanupFlinkMiniCluster();
    }

    @Test
    @Disabled
    public void testMapFunction() throws Exception {
        String newCommitTime = "001";
        int numRecords = 10;
        List records = this.dataGen.generateInserts("001", Integer.valueOf(10));
        List recordStr = RawTripTestPayload.recordsToStrings((List)records);
        Schema schema = HoodieTestDataGenerator.AVRO_SCHEMA;
        TypedProperties props = new TypedProperties();
        props.put((Object)"hoodie.datasource.write.payload.class", (Object)OverwriteWithLatestAvroPayload.class.getName());
        props.put((Object)"hoodie.datasource.write.precombine.field", (Object)"timestamp");
        props.put((Object)"hoodie.datasource.write.recordkey.field", (Object)"_row_key");
        props.put((Object)"hoodie.datasource.write.partitionpath.field", (Object)"partitionPath");
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(2);
        HoodieFlinkClientTestHarness.SimpleTestSinkFunction.valuesList.clear();
        env.fromCollection((Collection)recordStr).map((MapFunction)new JsonStringToHoodieRecordMapFunction(props, Option.of((Object)schema.toString()))).addSink((SinkFunction)new HoodieFlinkClientTestHarness.SimpleTestSinkFunction());
        env.execute();
        Assertions.assertEquals((int)10, (int)HoodieFlinkClientTestHarness.SimpleTestSinkFunction.valuesList.size());
        Set inputKeySet = records.stream().map(r -> r.getKey().getRecordKey()).collect(Collectors.toSet());
        Assertions.assertEquals((long)10L, (long)HoodieFlinkClientTestHarness.SimpleTestSinkFunction.valuesList.stream().map(r -> inputKeySet.contains(r.getRecordKey())).filter(b -> b).count());
    }
}

