/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.operator;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.KeyedProcessOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.operator.KeyedWriteProcessFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyedWriteProcessOperator
extends KeyedProcessOperator<String, HoodieRecord, Tuple3<String, List<WriteStatus>, Integer>> {
    public static final String NAME = "WriteProcessOperator";
    private static final Logger LOG = LoggerFactory.getLogger(KeyedWriteProcessOperator.class);
    private KeyedWriteProcessFunction writeProcessFunction;

    public KeyedWriteProcessOperator(KeyedProcessFunction<String, HoodieRecord, Tuple3<String, List<WriteStatus>, Integer>> function) {
        super(function);
        this.writeProcessFunction = (KeyedWriteProcessFunction)function;
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        if (!this.writeProcessFunction.hasRecordsIn() && this.writeProcessFunction.getLatestInstant() != null) {
            String instantTime = this.writeProcessFunction.getLatestInstant();
            LOG.info("Mock empty writeStatus, subtaskId = [{}], instant = [{}]", (Object)this.getRuntimeContext().getIndexOfThisSubtask(), (Object)instantTime);
            this.output.collect((Object)new StreamRecord((Object)new Tuple3((Object)instantTime, new ArrayList(), (Object)this.getRuntimeContext().getIndexOfThisSubtask())));
        }
    }
}

