/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import com.twitter.bijection.Injection;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.MercifulJsonConverter;

public class AvroConvertor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Schema schema;
    private final String schemaStr;
    private transient MercifulJsonConverter jsonConverter;
    private transient Injection<GenericRecord, byte[]> recordInjection;

    public AvroConvertor(String schemaStr) {
        this.schemaStr = schemaStr;
    }

    public AvroConvertor(Schema schema) {
        this.schemaStr = schema.toString();
        this.schema = schema;
    }

    private void initSchema() {
        if (this.schema == null) {
            Schema.Parser parser = new Schema.Parser();
            this.schema = parser.parse(this.schemaStr);
        }
    }

    private void initJsonConvertor() {
        if (this.jsonConverter == null) {
            this.jsonConverter = new MercifulJsonConverter();
        }
    }

    public GenericRecord fromJson(String json) {
        this.initSchema();
        this.initJsonConvertor();
        return this.jsonConverter.convert(json, this.schema);
    }
}

