/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.HoodieFlinkStreamer;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodiePayloadConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.SimpleAvroKeyGenerator;
import org.apache.hudi.schema.FilebasedSchemaProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamerUtil {
    private static Logger LOG = LoggerFactory.getLogger(StreamerUtil.class);

    public static TypedProperties getProps(HoodieFlinkStreamer.Config cfg) {
        return StreamerUtil.readConfig(FSUtils.getFs((String)cfg.propsFilePath, (Configuration)StreamerUtil.getHadoopConf()), new Path(cfg.propsFilePath), cfg.configs).getConfig();
    }

    public static DFSPropertiesConfiguration readConfig(FileSystem fs, Path cfgPath, List<String> overriddenProps) {
        DFSPropertiesConfiguration conf;
        try {
            conf = new DFSPropertiesConfiguration(cfgPath.getFileSystem(fs.getConf()), cfgPath);
        }
        catch (Exception e) {
            conf = new DFSPropertiesConfiguration();
            LOG.warn("Unexpected error read props file at :" + cfgPath, (Throwable)e);
        }
        try {
            if (!overriddenProps.isEmpty()) {
                LOG.info("Adding overridden properties to file properties.");
                conf.addProperties(new BufferedReader(new StringReader(String.join((CharSequence)"\n", overriddenProps))));
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Unexpected error adding config overrides", ioe);
        }
        return conf;
    }

    public static Configuration getHadoopConf() {
        return new Configuration();
    }

    public static void checkRequiredProperties(TypedProperties props, List<String> checkPropNames) {
        checkPropNames.forEach(prop -> {
            if (!props.containsKey(prop)) {
                throw new HoodieNotSupportedException("Required property " + prop + " is missing");
            }
        });
    }

    public static KeyGenerator createKeyGenerator(TypedProperties props) throws IOException {
        String keyGeneratorClass = props.getString("hoodie.datasource.write.keygenerator.class", SimpleAvroKeyGenerator.class.getName());
        try {
            return (KeyGenerator)ReflectionUtils.loadClass((String)keyGeneratorClass, (Object[])new Object[]{props});
        }
        catch (Throwable e) {
            throw new IOException("Could not load key generator class " + keyGeneratorClass, e);
        }
    }

    public static HoodieRecordPayload createPayload(String payloadClass, GenericRecord record, Comparable orderingVal) throws IOException {
        try {
            return (HoodieRecordPayload)ReflectionUtils.loadClass((String)payloadClass, (Class[])new Class[]{GenericRecord.class, Comparable.class}, (Object[])new Object[]{record, orderingVal});
        }
        catch (Throwable e) {
            throw new IOException("Could not create payload for class: " + payloadClass, e);
        }
    }

    public static HoodieWriteConfig getHoodieClientConfig(HoodieFlinkStreamer.Config cfg) {
        FileSystem fs = FSUtils.getFs((String)cfg.targetBasePath, (Configuration)StreamerUtil.getHadoopConf());
        HoodieWriteConfig.Builder builder = HoodieWriteConfig.newBuilder().withEngineType(EngineType.FLINK).withPath(cfg.targetBasePath).combineInput(cfg.filterDupes.booleanValue(), true).withCompactionConfig(HoodieCompactionConfig.newBuilder().withPayloadClass(cfg.payloadClassName).build()).withPayloadConfig(HoodiePayloadConfig.newBuilder().withPayloadOrderingField(cfg.sourceOrderingField).build()).forTable(cfg.targetTableName).withAutoCommit(false).withProps((Map)StreamerUtil.readConfig(fs, new Path(cfg.propsFilePath), cfg.configs).getConfig());
        builder = builder.withSchema(new FilebasedSchemaProvider(StreamerUtil.getProps(cfg)).getTargetSchema().toString());
        HoodieWriteConfig config = builder.build();
        return config;
    }
}

