/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.CloneDefinition;
import com.google.cloud.bigquery.CopyJobConfiguration;
import com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.bigquery.ExtractJobConfiguration;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Table
extends TableInfo {
    private static final long serialVersionUID = 5744556727066570096L;
    private final BigQueryOptions options;
    private transient BigQuery bigquery;

    Table(BigQuery bigquery, TableInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.bigquery = (BigQuery)Preconditions.checkNotNull((Object)bigquery);
        this.options = (BigQueryOptions)bigquery.getOptions();
    }

    public boolean exists() {
        return this.bigquery.getTable(this.getTableId(), BigQuery.TableOption.fields(new BigQuery.TableField[0])) != null;
    }

    public Table reload(BigQuery.TableOption ... options) {
        return this.bigquery.getTable(this.getTableId(), options);
    }

    public Table update(BigQuery.TableOption ... options) {
        return this.bigquery.update(this, options);
    }

    public boolean delete() {
        return this.bigquery.delete(this.getTableId());
    }

    public InsertAllResponse insert(Iterable<InsertAllRequest.RowToInsert> rows) throws BigQueryException {
        return this.bigquery.insertAll(InsertAllRequest.of(this.getTableId(), rows));
    }

    public InsertAllResponse insert(Iterable<InsertAllRequest.RowToInsert> rows, boolean skipInvalidRows, boolean ignoreUnknownValues) throws BigQueryException {
        InsertAllRequest request = InsertAllRequest.newBuilder(this.getTableId(), rows).setSkipInvalidRows(skipInvalidRows).setIgnoreUnknownValues(ignoreUnknownValues).build();
        return this.bigquery.insertAll(request);
    }

    public TableResult list(BigQuery.TableDataListOption ... options) throws BigQueryException {
        return this.bigquery.listTableData(this.getTableId(), options);
    }

    public TableResult list(Schema schema, BigQuery.TableDataListOption ... options) throws BigQueryException {
        return this.bigquery.listTableData(this.getTableId(), schema, options);
    }

    public Job copy(String destinationDataset, String destinationTable, BigQuery.JobOption ... options) throws BigQueryException {
        return this.copy(TableId.of(destinationDataset, destinationTable), options);
    }

    public Job copy(TableId destinationTable, BigQuery.JobOption ... options) throws BigQueryException {
        CopyJobConfiguration configuration = CopyJobConfiguration.of(destinationTable, this.getTableId());
        return this.bigquery.create(JobInfo.of(configuration), options);
    }

    public Job extract(String format, String destinationUri, BigQuery.JobOption ... options) throws BigQueryException {
        return this.extract(format, (List<String>)ImmutableList.of((Object)destinationUri), options);
    }

    public Job extract(String format, List<String> destinationUris, BigQuery.JobOption ... options) throws BigQueryException {
        ExtractJobConfiguration extractConfiguration = ExtractJobConfiguration.of(this.getTableId(), destinationUris, format);
        return this.bigquery.create(JobInfo.of(extractConfiguration), options);
    }

    public Job load(FormatOptions format, String sourceUri, BigQuery.JobOption ... options) throws BigQueryException {
        return this.load(format, (List<String>)ImmutableList.of((Object)sourceUri), options);
    }

    public Job load(FormatOptions format, List<String> sourceUris, BigQuery.JobOption ... options) throws BigQueryException {
        LoadJobConfiguration loadConfig = LoadJobConfiguration.of(this.getTableId(), sourceUris, format);
        return this.bigquery.create(JobInfo.of(loadConfig), options);
    }

    public BigQuery getBigQuery() {
        return this.bigquery;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Table.class)) {
            return false;
        }
        Table other = (Table)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.bigquery = (BigQuery)this.options.getService();
    }

    static Table fromPb(BigQuery bigquery, com.google.api.services.bigquery.model.Table tablePb) {
        return new Table(bigquery, new TableInfo.BuilderImpl(tablePb));
    }

    public static class Builder
    extends TableInfo.Builder {
        private final BigQuery bigquery;
        private final TableInfo.BuilderImpl infoBuilder;

        Builder(BigQuery bigquery, TableId tableId, TableDefinition defintion) {
            this.bigquery = bigquery;
            this.infoBuilder = new TableInfo.BuilderImpl();
            this.infoBuilder.setTableId(tableId).setDefinition(defintion);
        }

        Builder(Table table) {
            this.bigquery = table.bigquery;
            this.infoBuilder = new TableInfo.BuilderImpl(table);
        }

        @Override
        Builder setCreationTime(Long creationTime) {
            this.infoBuilder.setCreationTime(creationTime);
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.infoBuilder.setDescription(description);
            return this;
        }

        @Override
        Builder setEtag(String etag) {
            this.infoBuilder.setEtag(etag);
            return this;
        }

        @Override
        public Builder setExpirationTime(Long expirationTime) {
            this.infoBuilder.setExpirationTime(expirationTime);
            return this;
        }

        @Override
        public Builder setFriendlyName(String friendlyName) {
            this.infoBuilder.setFriendlyName(friendlyName);
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.infoBuilder.setGeneratedId(generatedId);
            return this;
        }

        @Override
        Builder setLastModifiedTime(Long lastModifiedTime) {
            this.infoBuilder.setLastModifiedTime(lastModifiedTime);
            return this;
        }

        @Override
        Builder setNumBytes(Long numBytes) {
            this.infoBuilder.setNumBytes(numBytes);
            return this;
        }

        @Override
        Builder setNumLongTermBytes(Long numLongTermBytes) {
            this.infoBuilder.setNumLongTermBytes(numLongTermBytes);
            return this;
        }

        @Override
        Builder setNumRows(BigInteger numRows) {
            this.infoBuilder.setNumRows(numRows);
            return this;
        }

        @Override
        Builder setSelfLink(String selfLink) {
            this.infoBuilder.setSelfLink(selfLink);
            return this;
        }

        @Override
        public Builder setTableId(TableId tableId) {
            this.infoBuilder.setTableId(tableId);
            return this;
        }

        @Override
        public Builder setDefinition(TableDefinition definition) {
            this.infoBuilder.setDefinition(definition);
            return this;
        }

        @Override
        public TableInfo.Builder setEncryptionConfiguration(EncryptionConfiguration configuration) {
            this.infoBuilder.setEncryptionConfiguration(configuration);
            return this;
        }

        @Override
        public Builder setLabels(Map<String, String> labels) {
            this.infoBuilder.setLabels(labels);
            return this;
        }

        @Override
        public Builder setRequirePartitionFilter(Boolean requirePartitionFilter) {
            this.infoBuilder.setRequirePartitionFilter(requirePartitionFilter);
            return this;
        }

        @Override
        public Builder setDefaultCollation(String defaultCollation) {
            this.infoBuilder.setDefaultCollation(defaultCollation);
            return this;
        }

        @Override
        public TableInfo.Builder setCloneDefinition(CloneDefinition cloneDefinition) {
            this.infoBuilder.setCloneDefinition(cloneDefinition);
            return this;
        }

        @Override
        public Table build() {
            return new Table(this.bigquery, this.infoBuilder);
        }
    }
}

