/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.openjdk.jol.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;

public class ClassUtils {
    private static volatile ClassLoader CL = ClassUtils.class.getClassLoader();

    public static void addClasspathEntries(Collection<String> cpEntries) {
        ArrayList<URL> cp = new ArrayList<URL>();
        for (String cpEntry : cpEntries) {
            try {
                cp.add(new File(cpEntry).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        URL[] classPath = cp.toArray(new URL[0]);
        CL = new URLClassLoader(classPath, CL);
    }

    public static Class<?> loadClass(String name) throws ClassNotFoundException {
        return Class.forName(name, true, CL);
    }

    public static Class<?> loadSystemClass(String name) throws ClassNotFoundException {
        return Class.forName(name, true, ClassLoader.getSystemClassLoader());
    }

    public static String getSafeName(Class klass) {
        try {
            String n = klass.getCanonicalName();
            if (n != null) {
                return n;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return klass.getName();
    }
}

