/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.buffer.Unpooled;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.ChannelOutboundHandlerAdapter;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.ChannelPromise;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.util.concurrent.Future;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.util.concurrent.GenericFutureListener;
import org.apache.hadoop.hbase.ipc.BufferChain;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServer;
import org.apache.hadoop.hbase.ipc.RpcResponse;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class NettyRpcServerResponseEncoder
extends ChannelOutboundHandlerAdapter {
    private final MetricsHBaseServer metrics;

    NettyRpcServerResponseEncoder(MetricsHBaseServer metrics) {
        this.metrics = metrics;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof RpcResponse) {
            RpcResponse resp = (RpcResponse)msg;
            BufferChain buf = resp.getResponse();
            ctx.write(Unpooled.wrappedBuffer(buf.getBuffers()), promise).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
                resp.done();
                if (f.isSuccess()) {
                    this.metrics.sentBytes(buf.size());
                }
            }));
        } else {
            ctx.write(msg, promise);
        }
    }
}

