/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.apache.hudi.avro.model.HoodieFileStatus;

@AvroGenerated
public class HoodieBootstrapPartitionMetadata
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -4947496544470001002L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieBootstrapPartitionMetadata\",\"namespace\":\"org.apache.hudi.avro.model\",\"fields\":[{\"name\":\"version\",\"type\":[\"int\",\"null\"],\"default\":1},{\"name\":\"bootstrapPartitionPath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"partitionPath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"fileIdToBootstrapFile\",\"type\":[\"null\",{\"type\":\"map\",\"values\":{\"type\":\"record\",\"name\":\"HoodieFileStatus\",\"fields\":[{\"name\":\"version\",\"type\":[\"int\",\"null\"],\"default\":1},{\"name\":\"path\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"HoodiePath\",\"fields\":[{\"name\":\"version\",\"type\":[\"int\",\"null\"],\"default\":1},{\"name\":\"uri\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null}]}],\"default\":null},{\"name\":\"length\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"isDir\",\"type\":[\"null\",\"boolean\"],\"default\":null},{\"name\":\"blockReplication\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"blockSize\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"modificationTime\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"accessTime\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"permission\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"HoodieFSPermission\",\"fields\":[{\"name\":\"version\",\"type\":[\"int\",\"null\"],\"default\":1},{\"name\":\"userAction\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"groupAction\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"otherAction\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"stickyBit\",\"type\":[\"null\",\"boolean\"],\"default\":null}]}],\"default\":null},{\"name\":\"owner\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"group\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"symlink\",\"type\":[\"null\",\"HoodiePath\"],\"default\":null}]},\"avro.java.string\":\"String\"}],\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<HoodieBootstrapPartitionMetadata> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<HoodieBootstrapPartitionMetadata> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private Integer version;
    private String bootstrapPartitionPath;
    private String partitionPath;
    private Map<String, HoodieFileStatus> fileIdToBootstrapFile;
    private static final DatumWriter<HoodieBootstrapPartitionMetadata> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<HoodieBootstrapPartitionMetadata> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<HoodieBootstrapPartitionMetadata> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<HoodieBootstrapPartitionMetadata> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<HoodieBootstrapPartitionMetadata> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static HoodieBootstrapPartitionMetadata fromByteBuffer(ByteBuffer b) throws IOException {
        return (HoodieBootstrapPartitionMetadata)((Object)DECODER.decode(b));
    }

    public HoodieBootstrapPartitionMetadata() {
    }

    public HoodieBootstrapPartitionMetadata(Integer version, String bootstrapPartitionPath, String partitionPath, Map<String, HoodieFileStatus> fileIdToBootstrapFile) {
        this.version = version;
        this.bootstrapPartitionPath = bootstrapPartitionPath;
        this.partitionPath = partitionPath;
        this.fileIdToBootstrapFile = fileIdToBootstrapFile;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.version;
            }
            case 1: {
                return this.bootstrapPartitionPath;
            }
            case 2: {
                return this.partitionPath;
            }
            case 3: {
                return this.fileIdToBootstrapFile;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.version = (Integer)value$;
                break;
            }
            case 1: {
                this.bootstrapPartitionPath = value$ != null ? value$.toString() : null;
                break;
            }
            case 2: {
                this.partitionPath = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.fileIdToBootstrapFile = (Map)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer value) {
        this.version = value;
    }

    public String getBootstrapPartitionPath() {
        return this.bootstrapPartitionPath;
    }

    public void setBootstrapPartitionPath(String value) {
        this.bootstrapPartitionPath = value;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public void setPartitionPath(String value) {
        this.partitionPath = value;
    }

    public Map<String, HoodieFileStatus> getFileIdToBootstrapFile() {
        return this.fileIdToBootstrapFile;
    }

    public void setFileIdToBootstrapFile(Map<String, HoodieFileStatus> value) {
        this.fileIdToBootstrapFile = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(HoodieBootstrapPartitionMetadata other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        if (this.version == null) {
            out.writeIndex(1);
            out.writeNull();
        } else {
            out.writeIndex(0);
            out.writeInt(this.version.intValue());
        }
        if (this.bootstrapPartitionPath == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.bootstrapPartitionPath);
        }
        if (this.partitionPath == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.partitionPath);
        }
        if (this.fileIdToBootstrapFile == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            long size0 = this.fileIdToBootstrapFile.size();
            out.writeMapStart();
            out.setItemCount(size0);
            long actualSize0 = 0L;
            for (Map.Entry<String, HoodieFileStatus> e0 : this.fileIdToBootstrapFile.entrySet()) {
                ++actualSize0;
                out.startItem();
                out.writeString(e0.getKey());
                HoodieFileStatus v0 = e0.getValue();
                v0.customEncode(out);
            }
            out.writeMapEnd();
            if (actualSize0 != size0) {
                throw new ConcurrentModificationException("Map-size written was " + size0 + ", but element count was " + actualSize0 + ".");
            }
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            if (in.readIndex() != 0) {
                in.readNull();
                this.version = null;
            } else {
                this.version = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.bootstrapPartitionPath = null;
            } else {
                this.bootstrapPartitionPath = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.partitionPath = null;
            } else {
                this.partitionPath = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.fileIdToBootstrapFile = null;
            } else {
                long size0 = in.readMapStart();
                Map<String, HoodieFileStatus> m0 = this.fileIdToBootstrapFile;
                if (m0 == null) {
                    this.fileIdToBootstrapFile = m0 = new HashMap<String, HoodieFileStatus>((int)size0);
                } else {
                    m0.clear();
                }
                while (0L < size0) {
                    while (size0 != 0L) {
                        String k0 = null;
                        k0 = in.readString();
                        HoodieFileStatus v0 = null;
                        if (v0 == null) {
                            v0 = new HoodieFileStatus();
                        }
                        v0.customDecode(in);
                        m0.put(k0, v0);
                        --size0;
                    }
                    size0 = in.mapNext();
                }
            }
        } else {
            block8: for (int i = 0; i < 4; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        if (in.readIndex() != 0) {
                            in.readNull();
                            this.version = null;
                            continue block8;
                        }
                        this.version = in.readInt();
                        continue block8;
                    }
                    case 1: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.bootstrapPartitionPath = null;
                            continue block8;
                        }
                        this.bootstrapPartitionPath = in.readString();
                        continue block8;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.partitionPath = null;
                            continue block8;
                        }
                        this.partitionPath = in.readString();
                        continue block8;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.fileIdToBootstrapFile = null;
                            continue block8;
                        }
                        long size0 = in.readMapStart();
                        Map<String, HoodieFileStatus> m0 = this.fileIdToBootstrapFile;
                        if (m0 == null) {
                            this.fileIdToBootstrapFile = m0 = new HashMap<String, HoodieFileStatus>((int)size0);
                        } else {
                            m0.clear();
                        }
                        while (0L < size0) {
                            while (size0 != 0L) {
                                String k0 = null;
                                k0 = in.readString();
                                HoodieFileStatus v0 = null;
                                if (v0 == null) {
                                    v0 = new HoodieFileStatus();
                                }
                                v0.customDecode(in);
                                m0.put(k0, v0);
                                --size0;
                            }
                            size0 = in.mapNext();
                        }
                        continue block8;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<HoodieBootstrapPartitionMetadata>
    implements RecordBuilder<HoodieBootstrapPartitionMetadata> {
        private Integer version;
        private String bootstrapPartitionPath;
        private String partitionPath;
        private Map<String, HoodieFileStatus> fileIdToBootstrapFile;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.version)) {
                this.version = (Integer)this.data().deepCopy(this.fields()[0].schema(), (Object)other.version);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.bootstrapPartitionPath)) {
                this.bootstrapPartitionPath = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.bootstrapPartitionPath);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.partitionPath)) {
                this.partitionPath = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.partitionPath);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], other.fileIdToBootstrapFile)) {
                this.fileIdToBootstrapFile = (Map)this.data().deepCopy(this.fields()[3].schema(), other.fileIdToBootstrapFile);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
        }

        private Builder(HoodieBootstrapPartitionMetadata other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.version)) {
                this.version = (Integer)this.data().deepCopy(this.fields()[0].schema(), (Object)other.version);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.bootstrapPartitionPath)) {
                this.bootstrapPartitionPath = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.bootstrapPartitionPath);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.partitionPath)) {
                this.partitionPath = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.partitionPath);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.fileIdToBootstrapFile)) {
                this.fileIdToBootstrapFile = (Map)this.data().deepCopy(this.fields()[3].schema(), (Object)other.fileIdToBootstrapFile);
                this.fieldSetFlags()[3] = true;
            }
        }

        public Integer getVersion() {
            return this.version;
        }

        public Builder setVersion(Integer value) {
            this.validate(this.fields()[0], value);
            this.version = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasVersion() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearVersion() {
            this.version = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getBootstrapPartitionPath() {
            return this.bootstrapPartitionPath;
        }

        public Builder setBootstrapPartitionPath(String value) {
            this.validate(this.fields()[1], value);
            this.bootstrapPartitionPath = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasBootstrapPartitionPath() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearBootstrapPartitionPath() {
            this.bootstrapPartitionPath = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getPartitionPath() {
            return this.partitionPath;
        }

        public Builder setPartitionPath(String value) {
            this.validate(this.fields()[2], value);
            this.partitionPath = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasPartitionPath() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearPartitionPath() {
            this.partitionPath = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Map<String, HoodieFileStatus> getFileIdToBootstrapFile() {
            return this.fileIdToBootstrapFile;
        }

        public Builder setFileIdToBootstrapFile(Map<String, HoodieFileStatus> value) {
            this.validate(this.fields()[3], value);
            this.fileIdToBootstrapFile = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasFileIdToBootstrapFile() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearFileIdToBootstrapFile() {
            this.fileIdToBootstrapFile = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public HoodieBootstrapPartitionMetadata build() {
            try {
                HoodieBootstrapPartitionMetadata record = new HoodieBootstrapPartitionMetadata();
                record.version = this.fieldSetFlags()[0] ? this.version : (Integer)this.defaultValue(this.fields()[0]);
                record.bootstrapPartitionPath = this.fieldSetFlags()[1] ? this.bootstrapPartitionPath : (String)this.defaultValue(this.fields()[1]);
                record.partitionPath = this.fieldSetFlags()[2] ? this.partitionPath : (String)this.defaultValue(this.fields()[2]);
                record.fileIdToBootstrapFile = this.fieldSetFlags()[3] ? this.fileIdToBootstrapFile : (Map)this.defaultValue(this.fields()[3]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

