/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.checkpoint;

import org.apache.hudi.common.table.checkpoint.Checkpoint;
import org.apache.hudi.common.table.checkpoint.StreamerCheckpointV1;
import org.apache.hudi.common.table.checkpoint.StreamerCheckpointV2;
import org.apache.hudi.common.table.checkpoint.UnresolvedStreamerCheckpointBasedOnCfg;

public class HoodieIncrSourceCheckpointValUtils {
    public static final String RESET_CHECKPOINT_V2_SEPARATOR = ":";
    public static final String REQUEST_TIME_PREFIX = "resumeFromInstantRequestTime";
    public static final String COMPLETION_TIME_PREFIX = "resumeFromInstantCompletionTime";

    public static Checkpoint resolveToActualCheckpointVersion(UnresolvedStreamerCheckpointBasedOnCfg checkpoint) {
        String[] parts = HoodieIncrSourceCheckpointValUtils.extractKeyValues(checkpoint);
        switch (parts[0]) {
            case "resumeFromInstantRequestTime": {
                return new StreamerCheckpointV1(checkpoint).setCheckpointKey(parts[1]);
            }
            case "resumeFromInstantCompletionTime": {
                return new StreamerCheckpointV2(checkpoint).setCheckpointKey(parts[1]);
            }
        }
        throw new IllegalArgumentException("Unknown event ordering mode " + parts[0]);
    }

    private static String[] extractKeyValues(UnresolvedStreamerCheckpointBasedOnCfg checkpoint) {
        String checkpointKey = checkpoint.getCheckpointKey();
        String[] parts = checkpointKey.split(RESET_CHECKPOINT_V2_SEPARATOR);
        if (parts.length != 2 || !parts[0].trim().equals(REQUEST_TIME_PREFIX) && !parts[0].trim().equals(COMPLETION_TIME_PREFIX)) {
            throw new IllegalArgumentException("Illegal checkpoint key override `" + checkpointKey + "`. Valid format is either `resumeFromInstantRequestTime:<checkpoint value>` or `resumeFromInstantCompletionTime:<checkpoint value>`.");
        }
        parts[0] = parts[0].trim();
        parts[1] = parts[1].trim();
        return parts;
    }
}

