/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v1;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hudi.common.table.timeline.InstantFileNameParser;

public class InstantFileNameParserV1
implements InstantFileNameParser {
    private static final Pattern NAME_FORMAT = Pattern.compile("^(\\d+)(\\.\\w+)(\\.\\D+)?$");

    @Override
    public String extractTimestamp(String fileName) throws IllegalArgumentException {
        Matcher matcher = NAME_FORMAT.matcher(fileName);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("Failed to retrieve timestamp from name: " + String.format("The provided file name %s does not conform to the required format", fileName));
    }

    @Override
    public String getTimelineFileExtension(String fileName) {
        Objects.requireNonNull(fileName);
        Matcher matcher = NAME_FORMAT.matcher(fileName);
        if (matcher.find()) {
            return fileName.substring(matcher.group(1).length());
        }
        return "";
    }
}

