/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.gcp.bigquery;

import com.beust.jcommander.JCommander;
import com.google.cloud.bigquery.Schema;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.HadoopConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.gcp.bigquery.BigQuerySchemaResolver;
import org.apache.hudi.gcp.bigquery.BigQuerySyncConfig;
import org.apache.hudi.gcp.bigquery.HoodieBigQuerySyncClient;
import org.apache.hudi.gcp.bigquery.HoodieBigQuerySyncException;
import org.apache.hudi.sync.common.HoodieSyncTool;
import org.apache.hudi.sync.common.util.ManifestFileWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQuerySyncTool
extends HoodieSyncTool {
    private static final Logger LOG = LoggerFactory.getLogger(BigQuerySyncTool.class);
    private static final String SUFFIX_MANIFEST = "_manifest";
    private static final String SUFFIX_VERSIONS = "_versions";
    private final BigQuerySyncConfig config;
    private final String tableName;
    private final String manifestTableName;
    private final String versionsTableName;
    private final String snapshotViewName;
    private final ManifestFileWriter manifestFileWriter;
    private final HoodieBigQuerySyncClient bqSyncClient;
    private final HoodieTableMetaClient metaClient;
    private final BigQuerySchemaResolver bqSchemaResolver;

    public BigQuerySyncTool(Properties props) {
        this(props, HadoopConfigUtils.createHadoopConf(props), Option.empty());
    }

    public BigQuerySyncTool(Properties props, Configuration configuration, Option<HoodieTableMetaClient> metaClientOption) {
        super(props, configuration);
        this.config = new BigQuerySyncConfig(props);
        this.tableName = this.config.getString(BigQuerySyncConfig.BIGQUERY_SYNC_TABLE_NAME);
        this.manifestTableName = this.tableName + SUFFIX_MANIFEST;
        this.versionsTableName = this.tableName + SUFFIX_VERSIONS;
        this.snapshotViewName = this.tableName;
        this.bqSyncClient = new HoodieBigQuerySyncClient(this.config, metaClientOption.orElseGet(() -> BigQuerySyncTool.buildMetaClient(this.config)));
        this.metaClient = this.bqSyncClient.getMetaClient();
        this.manifestFileWriter = BigQuerySyncTool.buildManifestFileWriterFromConfig(this.metaClient, this.config);
        this.bqSchemaResolver = BigQuerySchemaResolver.getInstance();
    }

    @VisibleForTesting
    BigQuerySyncTool(Properties properties, ManifestFileWriter manifestFileWriter, HoodieBigQuerySyncClient bigQuerySyncClient, HoodieTableMetaClient metaClient, BigQuerySchemaResolver bigQuerySchemaResolver) {
        super(properties);
        this.config = new BigQuerySyncConfig(this.props);
        this.tableName = this.config.getString(BigQuerySyncConfig.BIGQUERY_SYNC_TABLE_NAME);
        this.manifestTableName = this.tableName + SUFFIX_MANIFEST;
        this.versionsTableName = this.tableName + SUFFIX_VERSIONS;
        this.snapshotViewName = this.tableName;
        this.bqSyncClient = bigQuerySyncClient;
        this.metaClient = metaClient;
        this.manifestFileWriter = manifestFileWriter;
        this.bqSchemaResolver = bigQuerySchemaResolver;
    }

    private static ManifestFileWriter buildManifestFileWriterFromConfig(HoodieTableMetaClient metaClient, BigQuerySyncConfig config) {
        return ManifestFileWriter.builder().setMetaClient(metaClient).setUseFileListingFromMetadata(config.getBoolean(BigQuerySyncConfig.BIGQUERY_SYNC_USE_FILE_LISTING_FROM_METADATA)).build();
    }

    @Override
    public void syncHoodieTable() {
        switch (this.bqSyncClient.getTableType()) {
            case COPY_ON_WRITE: 
            case MERGE_ON_READ: {
                this.syncTable(this.bqSyncClient);
                break;
            }
            default: {
                throw new UnsupportedOperationException((Object)((Object)this.bqSyncClient.getTableType()) + " table type is not supported yet.");
            }
        }
    }

    private boolean tableExists(HoodieBigQuerySyncClient bqSyncClient, String tableName) {
        if (bqSyncClient.tableExists(tableName)) {
            LOG.info("{} already exists. Skip table creation.", (Object)tableName);
            return true;
        }
        return false;
    }

    private void syncTable(HoodieBigQuerySyncClient bqSyncClient) {
        LOG.info("Sync hoodie table {} at base path {}", (Object)this.snapshotViewName, (Object)bqSyncClient.getBasePath());
        if (!bqSyncClient.datasetExists()) {
            throw new HoodieBigQuerySyncException("Dataset not found: " + this.config.getString(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_NAME));
        }
        List<String> partitionFields = !StringUtils.isNullOrEmpty(this.config.getString(BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI_PREFIX)) ? this.config.getSplitStrings(BigQuerySyncConfig.BIGQUERY_SYNC_PARTITION_FIELDS) : Collections.emptyList();
        Schema latestSchema = this.bqSchemaResolver.getTableSchema(this.metaClient, partitionFields);
        if (this.config.getBoolean(BigQuerySyncConfig.BIGQUERY_SYNC_USE_BQ_MANIFEST_FILE).booleanValue()) {
            this.manifestFileWriter.writeManifestFile(true);
            if (bqSyncClient.tableNotExistsOrDoesNotMatchSpecification(this.tableName)) {
                bqSyncClient.createOrUpdateTableUsingBqManifestFile(this.tableName, this.manifestFileWriter.getManifestSourceUri(true), this.config.getString(BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI_PREFIX), latestSchema);
                LOG.info("Completed table {} creation using the manifest file", (Object)this.tableName);
            } else {
                bqSyncClient.updateTableSchema(this.tableName, latestSchema, partitionFields);
                LOG.info("Synced schema for {}", (Object)this.tableName);
            }
            LOG.info("Sync table complete for {}", (Object)this.tableName);
            return;
        }
        this.manifestFileWriter.writeManifestFile(false);
        if (!this.tableExists(bqSyncClient, this.manifestTableName)) {
            bqSyncClient.createManifestTable(this.manifestTableName, this.manifestFileWriter.getManifestSourceUri(false));
            LOG.info("Manifest table creation complete for {}", (Object)this.manifestTableName);
        }
        if (!this.tableExists(bqSyncClient, this.versionsTableName)) {
            bqSyncClient.createVersionsTable(this.versionsTableName, this.config.getString(BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI), this.config.getString(BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI_PREFIX), this.config.getSplitStrings(BigQuerySyncConfig.BIGQUERY_SYNC_PARTITION_FIELDS));
            LOG.info("Versions table creation complete for {}", (Object)this.versionsTableName);
        }
        if (!this.tableExists(bqSyncClient, this.snapshotViewName)) {
            bqSyncClient.createSnapshotView(this.snapshotViewName, this.versionsTableName, this.manifestTableName);
            LOG.info("Snapshot view creation complete for {}", (Object)this.snapshotViewName);
        }
        LOG.info("Sync table complete for {}", (Object)this.snapshotViewName);
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.bqSyncClient.close();
    }

    public static void main(String[] args) {
        BigQuerySyncConfig.BigQuerySyncConfigParams params = new BigQuerySyncConfig.BigQuerySyncConfigParams();
        JCommander cmd = JCommander.newBuilder().addObject(params).build();
        cmd.parse(args);
        if (params.isHelp()) {
            cmd.usage();
            System.exit(0);
        }
        new BigQuerySyncTool(params.toProps()).syncHoodieTable();
    }
}

