/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.io.Writable;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieDuplicateKeyException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hadoop.fs.HoodieWrapperFileSystem;
import org.apache.hudi.io.hadoop.HoodieHFileConfig;
import org.apache.hudi.io.storage.HoodieAvroFileWriter;
import org.apache.hudi.storage.StoragePath;

public class HoodieAvroHFileWriter
implements HoodieAvroFileWriter {
    private static final AtomicLong RECORD_INDEX_COUNT = new AtomicLong(1L);
    private final Path file;
    private final HoodieHFileConfig hfileConfig;
    private final boolean isWrapperFileSystem;
    private final Option<HoodieWrapperFileSystem> wrapperFs;
    private final long maxFileSize;
    private final String instantTime;
    private final TaskContextSupplier taskContextSupplier;
    private final boolean populateMetaFields;
    private final Option<Schema.Field> keyFieldSchema;
    private HFile.Writer writer;
    private String minRecordKey;
    private String maxRecordKey;
    private String prevRecordKey;
    private static final String DROP_BEHIND_CACHE_COMPACTION_KEY = "hbase.hfile.drop.behind.compaction";

    public HoodieAvroHFileWriter(String instantTime, StoragePath file, HoodieHFileConfig hfileConfig, Schema schema, TaskContextSupplier taskContextSupplier, boolean populateMetaFields) throws IOException {
        Configuration conf = HadoopFSUtils.registerFileSystem(file, hfileConfig.getHadoopConf());
        this.file = HoodieWrapperFileSystem.convertToHoodiePath(file, conf);
        FileSystem fs = this.file.getFileSystem(conf);
        this.isWrapperFileSystem = fs instanceof HoodieWrapperFileSystem;
        this.wrapperFs = this.isWrapperFileSystem ? Option.of((HoodieWrapperFileSystem)fs) : Option.empty();
        this.hfileConfig = hfileConfig;
        this.keyFieldSchema = Option.ofNullable(schema.getField(hfileConfig.getKeyFieldName()));
        this.maxFileSize = hfileConfig.getMaxFileSize();
        this.instantTime = instantTime;
        this.taskContextSupplier = taskContextSupplier;
        this.populateMetaFields = populateMetaFields;
        HFileContext context = new HFileContextBuilder().withBlockSize(hfileConfig.getBlockSize()).withCompression(hfileConfig.getCompressionAlgorithm()).withCellComparator(hfileConfig.getHFileComparator()).build();
        conf.set("hbase.rs.prefetchblocksonopen", String.valueOf(hfileConfig.shouldPrefetchBlocksOnOpen()));
        conf.set("CACHE_DATA_IN_L1", String.valueOf(hfileConfig.shouldCacheDataInL1()));
        conf.set(DROP_BEHIND_CACHE_COMPACTION_KEY, String.valueOf(hfileConfig.shouldDropBehindCacheCompaction()));
        CacheConfig cacheConfig = new CacheConfig(conf);
        this.writer = HFile.getWriterFactory(conf, cacheConfig).withPath(fs, this.file).withFileContext(context).create();
        this.writer.appendFileInfo(StringUtils.getUTF8Bytes("schema"), StringUtils.getUTF8Bytes(schema.toString()));
        this.prevRecordKey = "";
    }

    @Override
    public void writeAvroWithMetadata(HoodieKey key, IndexedRecord avroRecord) throws IOException {
        if (this.populateMetaFields) {
            this.prepRecordWithMetadata(key, avroRecord, this.instantTime, this.taskContextSupplier.getPartitionIdSupplier().get(), RECORD_INDEX_COUNT.getAndIncrement(), this.file.getName());
            this.writeAvro(key.getRecordKey(), avroRecord);
        } else {
            this.writeAvro(key.getRecordKey(), avroRecord);
        }
    }

    @Override
    public boolean canWrite() {
        return !this.isWrapperFileSystem || this.wrapperFs.get().getBytesWritten(this.file) < this.maxFileSize;
    }

    @Override
    public void writeAvro(String recordKey, IndexedRecord record) throws IOException {
        if (this.prevRecordKey.equals(recordKey)) {
            throw new HoodieDuplicateKeyException("Duplicate recordKey " + recordKey + " found while writing to HFile.Record payload: " + record);
        }
        byte[] value = null;
        boolean isRecordSerialized = false;
        if (this.keyFieldSchema.isPresent()) {
            boolean isKeyAvailable;
            GenericRecord keyExcludedRecord = (GenericRecord)record;
            int keyFieldPos = this.keyFieldSchema.get().pos();
            boolean bl = isKeyAvailable = record.get(keyFieldPos) != null && !record.get(keyFieldPos).toString().isEmpty();
            if (isKeyAvailable) {
                Object originalKey = keyExcludedRecord.get(keyFieldPos);
                keyExcludedRecord.put(keyFieldPos, (Object)"");
                value = HoodieAvroUtils.avroToBytes((IndexedRecord)keyExcludedRecord);
                keyExcludedRecord.put(keyFieldPos, originalKey);
                isRecordSerialized = true;
            }
        }
        if (!isRecordSerialized) {
            value = HoodieAvroUtils.avroToBytes((IndexedRecord)((GenericRecord)record));
        }
        KeyValue kv = new KeyValue(StringUtils.getUTF8Bytes(recordKey), null, null, value);
        this.writer.append(kv);
        if (this.hfileConfig.useBloomFilter()) {
            this.hfileConfig.getBloomFilter().add(recordKey);
            if (this.minRecordKey == null) {
                this.minRecordKey = recordKey;
            }
            this.maxRecordKey = recordKey;
        }
        this.prevRecordKey = recordKey;
    }

    @Override
    public void close() throws IOException {
        if (this.hfileConfig.useBloomFilter()) {
            final BloomFilter bloomFilter = this.hfileConfig.getBloomFilter();
            if (this.minRecordKey == null) {
                this.minRecordKey = "";
            }
            if (this.maxRecordKey == null) {
                this.maxRecordKey = "";
            }
            this.writer.appendFileInfo(StringUtils.getUTF8Bytes("minRecordKey"), StringUtils.getUTF8Bytes(this.minRecordKey));
            this.writer.appendFileInfo(StringUtils.getUTF8Bytes("maxRecordKey"), StringUtils.getUTF8Bytes(this.maxRecordKey));
            this.writer.appendFileInfo(StringUtils.getUTF8Bytes("bloomFilterTypeCode"), StringUtils.getUTF8Bytes(bloomFilter.getBloomFilterTypeCode().toString()));
            this.writer.appendMetaBlock("bloomFilter", new Writable(){

                public void write(DataOutput out) throws IOException {
                    out.write(StringUtils.getUTF8Bytes(bloomFilter.serializeToString()));
                }

                public void readFields(DataInput in) throws IOException {
                }
            });
        }
        this.writer.close();
        this.writer = null;
    }
}

