/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.gcp.bigquery;

import com.beust.jcommander.JCommander;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.gcp.bigquery.BigQuerySyncConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBigQuerySyncToolArgs {
    @Test
    public void testArgsParse() {
        BigQuerySyncConfig.BigQuerySyncConfigParams params = new BigQuerySyncConfig.BigQuerySyncConfigParams();
        JCommander cmd = JCommander.newBuilder().addObject((Object)params).build();
        String[] args = new String[]{"--project-id", "hudi-bq", "--dataset-name", "foobar", "--dataset-location", "us-west1", "--table", "foobartable", "--source-uri", "gs://foobartable/year=*", "--source-uri-prefix", "gs://foobartable/", "--base-path", "gs://foobartable", "--partitioned-by", "year,month,day", "--use-file-listing-from-metadata"};
        cmd.parse(args);
        TypedProperties props = params.toProps();
        Assertions.assertEquals((Object)"hudi-bq", (Object)props.getProperty(BigQuerySyncConfig.BIGQUERY_SYNC_PROJECT_ID.key()));
        Assertions.assertEquals((Object)"foobar", (Object)props.getProperty(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_NAME.key()));
        Assertions.assertEquals((Object)"us-west1", (Object)props.getProperty(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_LOCATION.key()));
        Assertions.assertEquals((Object)"foobartable", (Object)props.getProperty(BigQuerySyncConfig.BIGQUERY_SYNC_TABLE_NAME.key()));
        Assertions.assertEquals((Object)"gs://foobartable/year=*", (Object)props.getProperty(BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI.key()));
        Assertions.assertEquals((Object)"gs://foobartable/", (Object)props.getProperty(BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI_PREFIX.key()));
        Assertions.assertEquals((Object)"gs://foobartable", (Object)props.getProperty(BigQuerySyncConfig.BIGQUERY_SYNC_SYNC_BASE_PATH.key()));
        Assertions.assertEquals((Object)"year,month,day", (Object)props.getProperty(BigQuerySyncConfig.BIGQUERY_SYNC_PARTITION_FIELDS.key()));
        Assertions.assertEquals((Object)"true", (Object)props.getProperty(BigQuerySyncConfig.BIGQUERY_SYNC_USE_FILE_LISTING_FROM_METADATA.key()));
        Assertions.assertFalse((boolean)props.containsKey(BigQuerySyncConfig.BIGQUERY_SYNC_ASSUME_DATE_PARTITIONING.key()));
    }
}

