/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs.inline;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.testutils.FileSystemTestUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.hadoop.fs.inline.HadoopInLineFSUtils;
import org.apache.hudi.hadoop.fs.inline.InLineFileSystem;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestInLineFileSystem {
    private Configuration conf = new Configuration();
    private List<Path> listOfGeneratedPaths;

    public TestInLineFileSystem() {
        this.conf.set("fs.inlinefs.impl", InLineFileSystem.class.getName());
        this.listOfGeneratedPaths = new ArrayList<Path>();
    }

    @AfterEach
    public void teardown() throws IOException {
        for (Path pathToDelete : this.listOfGeneratedPaths) {
            File filePath = new File(pathToDelete.toString().substring(pathToDelete.toString().indexOf(58) + 1));
            if (!filePath.exists()) continue;
            FileSystemTestUtils.deleteFile(filePath);
        }
    }

    @Test
    public void testReadInlineFile() throws IOException {
        Path outerPath = new Path(FileSystemTestUtils.getRandomOuterFSPath().toUri());
        this.listOfGeneratedPaths.add(outerPath);
        int totalSlices = 5;
        ArrayList<Pair> startOffsetLengthPairs = new ArrayList<Pair>();
        ArrayList<byte[]> expectedByteArrays = new ArrayList<byte[]>();
        FSDataOutputStream wrappedOut = outerPath.getFileSystem(this.conf).create(outerPath, true);
        for (int i = 0; i < totalSlices; ++i) {
            byte[] randomBytes = new byte[FileSystemTestUtils.RANDOM.nextInt(1000)];
            FileSystemTestUtils.RANDOM.nextBytes(randomBytes);
            wrappedOut.write(randomBytes);
            long startOffset = wrappedOut.getPos();
            byte[] embeddedInlineBytes = new byte[FileSystemTestUtils.RANDOM.nextInt(1000)];
            FileSystemTestUtils.RANDOM.nextBytes(embeddedInlineBytes);
            wrappedOut.write(embeddedInlineBytes);
            expectedByteArrays.add(embeddedInlineBytes);
            startOffsetLengthPairs.add(Pair.of((Object)startOffset, (Object)embeddedInlineBytes.length));
        }
        byte[] randomBytes = new byte[FileSystemTestUtils.RANDOM.nextInt(1000)];
        FileSystemTestUtils.RANDOM.nextBytes(randomBytes);
        wrappedOut.write(randomBytes);
        wrappedOut.flush();
        wrappedOut.close();
        FileStatus expectedFileStatus = outerPath.getFileSystem(this.conf).getFileStatus(outerPath);
        for (int i = 0; i < totalSlices; ++i) {
            Pair startOffsetLengthPair = (Pair)startOffsetLengthPairs.get(i);
            byte[] expectedBytes = (byte[])expectedByteArrays.get(i);
            Path inlinePath = new Path(FileSystemTestUtils.getPhantomFile(new StoragePath(outerPath.toUri()), (Long)startOffsetLengthPair.getLeft(), ((Integer)startOffsetLengthPair.getRight()).intValue()).toUri());
            InLineFileSystem inlineFileSystem = (InLineFileSystem)inlinePath.getFileSystem(this.conf);
            FSDataInputStream fsDataInputStream = inlineFileSystem.open(inlinePath);
            Assertions.assertTrue((boolean)inlineFileSystem.exists(inlinePath));
            this.verifyFileStatus(expectedFileStatus, inlinePath, ((Integer)startOffsetLengthPair.getRight()).intValue(), inlineFileSystem.getFileStatus(inlinePath));
            FileStatus[] actualFileStatuses = inlineFileSystem.listStatus(inlinePath);
            Assertions.assertEquals((int)1, (int)actualFileStatuses.length);
            this.verifyFileStatus(expectedFileStatus, inlinePath, ((Integer)startOffsetLengthPair.getRight()).intValue(), actualFileStatuses[0]);
            byte[] actualBytes = new byte[expectedBytes.length];
            fsDataInputStream.readFully(0L, actualBytes);
            Assertions.assertArrayEquals((byte[])expectedBytes, (byte[])actualBytes);
            fsDataInputStream.close();
            Assertions.assertEquals((Object)"inlinefs", (Object)inlineFileSystem.getScheme());
            Assertions.assertEquals((Object)URI.create("inlinefs"), (Object)inlineFileSystem.getUri());
        }
    }

    @Test
    public void testFileSystemApis() throws IOException {
        int[] invalidPositions;
        int[] validPositions;
        OuterPathInfo outerPathInfo = this.generateOuterFileAndGetInfo(1000);
        Path inlinePath = new Path(FileSystemTestUtils.getPhantomFile(new StoragePath(outerPathInfo.outerPath.toUri()), outerPathInfo.startOffset, outerPathInfo.length).toUri());
        InLineFileSystem inlineFileSystem = (InLineFileSystem)inlinePath.getFileSystem(this.conf);
        FSDataInputStream fsDataInputStream = inlineFileSystem.open(inlinePath);
        byte[] actualBytes = new byte[outerPathInfo.expectedBytes.length];
        Assertions.assertEquals((long)0L, (long)fsDataInputStream.getPos());
        fsDataInputStream.readFully(0L, actualBytes);
        Assertions.assertArrayEquals((byte[])outerPathInfo.expectedBytes, (byte[])actualBytes);
        for (int pos : validPositions = new int[]{1, 100, 290, 520, 990, 999, 1000}) {
            fsDataInputStream.seek((long)pos);
        }
        for (int pos : invalidPositions = new int[]{1001, 1100, 10000}) {
            Assertions.assertThrows(IOException.class, () -> fsDataInputStream.seek((long)pos), (String)"Should have thrown IOException");
        }
        actualBytes = new byte[100];
        fsDataInputStream.read(0L, actualBytes, 10, 10);
        this.verifyArrayEquality(outerPathInfo.expectedBytes, 0, 10, actualBytes, 10, 10);
        actualBytes = new byte[310];
        fsDataInputStream.read(25L, actualBytes, 100, 210);
        this.verifyArrayEquality(outerPathInfo.expectedBytes, 25, 210, actualBytes, 100, 210);
        Assertions.assertThrows(IOException.class, () -> fsDataInputStream.read(0L, new byte[1100], 0, 1101), (String)"Should have thrown IOException");
        Assertions.assertThrows(IOException.class, () -> fsDataInputStream.read(0L, new byte[10], 991, 10), (String)"Should have thrown IOException");
        actualBytes = new byte[100];
        fsDataInputStream.readFully(0L, actualBytes, 10, 20);
        this.verifyArrayEquality(outerPathInfo.expectedBytes, 0, 10, actualBytes, 10, 10);
        actualBytes = new byte[310];
        fsDataInputStream.readFully(25L, actualBytes, 100, 210);
        this.verifyArrayEquality(outerPathInfo.expectedBytes, 25, 210, actualBytes, 100, 210);
        Assertions.assertThrows(IOException.class, () -> fsDataInputStream.readFully(0L, new byte[1100], 0, 1101), (String)"Should have thrown IOException");
        Assertions.assertThrows(IOException.class, () -> fsDataInputStream.readFully(0L, new byte[100], 910, 100), (String)"Should have thrown IOException");
        actualBytes = new byte[100];
        fsDataInputStream.readFully(0L, actualBytes);
        this.verifyArrayEquality(outerPathInfo.expectedBytes, 0, 100, actualBytes, 0, 100);
        actualBytes = new byte[310];
        fsDataInputStream.readFully(25L, actualBytes);
        this.verifyArrayEquality(outerPathInfo.expectedBytes, 25, 210, actualBytes, 0, 210);
        Assertions.assertThrows(IOException.class, () -> fsDataInputStream.readFully(0L, new byte[1100]), (String)"Should have thrown IOException");
        ByteBuffer actualByteBuffer = ByteBuffer.allocate(100);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> fsDataInputStream.read(actualByteBuffer), (String)"Should have thrown");
        Assertions.assertEquals((Object)outerPathInfo.outerPath.getFileSystem(this.conf).open(outerPathInfo.outerPath).getFileDescriptor(), (Object)fsDataInputStream.getFileDescriptor());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> fsDataInputStream.setReadahead(Long.valueOf(10L)), (String)"Should have thrown exception");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> fsDataInputStream.setDropBehind(Boolean.valueOf(true)), (String)"Should have thrown exception");
        fsDataInputStream.close();
    }

    private void verifyArrayEquality(byte[] expected, int expectedOffset, int expectedLength, byte[] actual, int actualOffset, int actualLength) {
        Assertions.assertArrayEquals((byte[])Arrays.copyOfRange(expected, expectedOffset, expectedOffset + expectedLength), (byte[])Arrays.copyOfRange(actual, actualOffset, actualOffset + actualLength));
    }

    private OuterPathInfo generateOuterFileAndGetInfo(int inlineContentSize) throws IOException {
        OuterPathInfo toReturn = new OuterPathInfo();
        Path outerPath = new Path(FileSystemTestUtils.getRandomOuterFSPath().toUri());
        this.listOfGeneratedPaths.add(outerPath);
        toReturn.outerPath = outerPath;
        FSDataOutputStream wrappedOut = outerPath.getFileSystem(this.conf).create(outerPath, true);
        byte[] randomBytes = new byte[FileSystemTestUtils.RANDOM.nextInt(1000)];
        FileSystemTestUtils.RANDOM.nextBytes(randomBytes);
        wrappedOut.write(randomBytes);
        toReturn.startOffset = wrappedOut.getPos();
        byte[] embeddedInlineBytes = new byte[inlineContentSize];
        FileSystemTestUtils.RANDOM.nextBytes(embeddedInlineBytes);
        wrappedOut.write(embeddedInlineBytes);
        toReturn.expectedBytes = embeddedInlineBytes;
        toReturn.length = embeddedInlineBytes.length;
        randomBytes = new byte[FileSystemTestUtils.RANDOM.nextInt(1000)];
        FileSystemTestUtils.RANDOM.nextBytes(randomBytes);
        wrappedOut.write(randomBytes);
        wrappedOut.flush();
        wrappedOut.close();
        return toReturn;
    }

    @Test
    public void testOpen() throws IOException {
        Path inlinePath = this.getRandomInlinePath();
        Assertions.assertThrows(FileNotFoundException.class, () -> inlinePath.getFileSystem(this.conf).open(inlinePath), (String)"Should have thrown exception");
    }

    @Test
    public void testCreate() throws IOException {
        Path inlinePath = this.getRandomInlinePath();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> inlinePath.getFileSystem(this.conf).create(inlinePath, true), (String)"Should have thrown exception");
    }

    @Test
    public void testAppend() throws IOException {
        Path inlinePath = this.getRandomInlinePath();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> inlinePath.getFileSystem(this.conf).append(inlinePath), (String)"Should have thrown exception");
    }

    @Test
    public void testRename() throws IOException {
        Path inlinePath = this.getRandomInlinePath();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> inlinePath.getFileSystem(this.conf).rename(inlinePath, inlinePath), (String)"Should have thrown exception");
    }

    @Test
    public void testDelete() throws IOException {
        Path inlinePath = this.getRandomInlinePath();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> inlinePath.getFileSystem(this.conf).delete(inlinePath, true), (String)"Should have thrown exception");
    }

    @Test
    public void testgetWorkingDir() throws IOException {
        Path inlinePath = this.getRandomInlinePath();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> inlinePath.getFileSystem(this.conf).getWorkingDirectory(), (String)"Should have thrown exception");
    }

    @Test
    public void testsetWorkingDirectory() throws IOException {
        Path inlinePath = this.getRandomInlinePath();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> inlinePath.getFileSystem(this.conf).setWorkingDirectory(inlinePath), (String)"Should have thrown exception");
    }

    @Test
    public void testInLineFSPathConversions() {
        List<TestFSPath> expectedInLinePaths = Arrays.asList(new TestFSPath(new StoragePath("/zero/524bae7e-f01d-47ae-b7cd-910400a81336"), new StoragePath("inlinefs://zero/524bae7e-f01d-47ae-b7cd-910400a81336/file/?start_offset=10&length=10"), new StoragePath("file:/zero/524bae7e-f01d-47ae-b7cd-910400a81336")), new TestFSPath(new StoragePath("file:/one/524bae7e-f01d-47ae-b7cd-910400a81336"), new StoragePath("inlinefs://one/524bae7e-f01d-47ae-b7cd-910400a81336/file/?start_offset=10&length=10"), new StoragePath("file:/one/524bae7e-f01d-47ae-b7cd-910400a81336")), new TestFSPath(new StoragePath("file://two/524bae7e-f01d-47ae-b7cd-910400a81336"), new StoragePath("inlinefs://two/524bae7e-f01d-47ae-b7cd-910400a81336/file/?start_offset=10&length=10"), new StoragePath("file:/two/524bae7e-f01d-47ae-b7cd-910400a81336")), new TestFSPath(new StoragePath("hdfs://three/524bae7e-f01d-47ae-b7cd-910400a81336"), new StoragePath("inlinefs://three/524bae7e-f01d-47ae-b7cd-910400a81336/hdfs/?start_offset=10&length=10"), new StoragePath("hdfs://three/524bae7e-f01d-47ae-b7cd-910400a81336")), new TestFSPath(new StoragePath("s3://four/524bae7e-f01d-47ae-b7cd-910400a81336"), new StoragePath("inlinefs://four/524bae7e-f01d-47ae-b7cd-910400a81336/s3/?start_offset=10&length=10"), new StoragePath("s3://four/524bae7e-f01d-47ae-b7cd-910400a81336")), new TestFSPath(new StoragePath("s3a://five/524bae7e-f01d-47ae-b7cd-910400a81336"), new StoragePath("inlinefs://five/524bae7e-f01d-47ae-b7cd-910400a81336/s3a/?start_offset=10&length=10"), new StoragePath("s3a://five/524bae7e-f01d-47ae-b7cd-910400a81336")));
        for (TestFSPath entry : expectedInLinePaths) {
            StoragePath inputPath = entry.inputPath;
            StoragePath expectedInLineFSPath = entry.expectedInLineFSPath;
            StoragePath expectedTransformedInputPath = entry.transformedInputPath;
            String scheme = "file";
            if (inputPath.toString().contains(":")) {
                scheme = inputPath.toString().split(":")[0];
            }
            StoragePath actualInLineFSPath = HadoopInLineFSUtils.getInlineFilePath((StoragePath)new StoragePath(inputPath.toUri()), (String)scheme, (long)10L, (long)10L);
            Assertions.assertEquals((Object)expectedInLineFSPath, (Object)actualInLineFSPath);
            StoragePath actualOuterFilePath = HadoopInLineFSUtils.getOuterFilePathFromInlinePath((StoragePath)actualInLineFSPath);
            Assertions.assertEquals((Object)expectedTransformedInputPath, (Object)actualOuterFilePath);
        }
    }

    @Test
    public void testExists() throws IOException {
        Path inlinePath = this.getRandomInlinePath();
        Assertions.assertFalse((boolean)inlinePath.getFileSystem(this.conf).exists(inlinePath));
    }

    private Path getRandomInlinePath() {
        Path outerPath = new Path(FileSystemTestUtils.getRandomOuterFSPath().toUri());
        this.listOfGeneratedPaths.add(outerPath);
        return new Path(FileSystemTestUtils.getPhantomFile(new StoragePath(outerPath.toUri()), 100L, 100L).toUri());
    }

    private void verifyFileStatus(FileStatus expected, Path inlinePath, long expectedLength, FileStatus actual) {
        Assertions.assertEquals((Object)inlinePath, (Object)actual.getPath());
        Assertions.assertEquals((long)expectedLength, (long)actual.getLen());
        Assertions.assertEquals((long)expected.getBlockSize(), (long)actual.getBlockSize());
        Assertions.assertEquals((Object)expected.getGroup(), (Object)actual.getGroup());
        Assertions.assertEquals((long)expected.getModificationTime(), (long)actual.getModificationTime());
        Assertions.assertEquals((Object)expected.getOwner(), (Object)actual.getOwner());
        Assertions.assertEquals((Object)expected.getPermission(), (Object)actual.getPermission());
        Assertions.assertEquals((short)expected.getReplication(), (short)actual.getReplication());
    }

    class OuterPathInfo {
        Path outerPath;
        long startOffset;
        int length;
        byte[] expectedBytes;

        OuterPathInfo() {
        }
    }

    static class TestFSPath {
        final StoragePath inputPath;
        final StoragePath expectedInLineFSPath;
        final StoragePath transformedInputPath;

        TestFSPath(StoragePath inputPath, StoragePath expectedInLineFSPath, StoragePath transformedInputPath) {
            this.inputPath = inputPath;
            this.expectedInLineFSPath = expectedInLineFSPath;
            this.transformedInputPath = transformedInputPath;
        }
    }
}

