/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs.inline;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.testutils.FileSystemTestUtils;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.hadoop.fs.inline.InLineFileSystem;
import org.apache.hudi.hadoop.fs.inline.InMemoryFileSystem;
import org.apache.hudi.storage.StoragePath;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestParquetInLining {
    private final Configuration inMemoryConf = new Configuration();
    private final Configuration inlineConf;
    private Path generatedPath;

    public TestParquetInLining() {
        this.inMemoryConf.set("fs.inmemfs.impl", InMemoryFileSystem.class.getName());
        this.inlineConf = new Configuration();
        this.inlineConf.set("fs.inlinefs.impl", InLineFileSystem.class.getName());
    }

    @AfterEach
    public void teardown() throws IOException {
        File filePath;
        if (this.generatedPath != null && (filePath = new File(this.generatedPath.toString().substring(this.generatedPath.toString().indexOf(58) + 1))).exists()) {
            FileSystemTestUtils.deleteFile(filePath);
        }
    }

    @Test
    public void testSimpleInlineFileSystem() throws IOException {
        Path outerPath;
        Path outerInMemFSPath = FileSystemTestUtils.getRandomOuterInMemPath();
        this.generatedPath = outerPath = new Path("file" + outerInMemFSPath.toString().substring(outerInMemFSPath.toString().indexOf(58)));
        AvroParquetWriter inlineWriter = new AvroParquetWriter(outerInMemFSPath, HoodieTestDataGenerator.AVRO_SCHEMA, CompressionCodecName.GZIP, 0x6400000, 0x100000, true, this.inMemoryConf);
        List<GenericRecord> recordsToWrite = TestParquetInLining.getParquetHoodieRecords();
        for (GenericRecord rec : recordsToWrite) {
            inlineWriter.write((Object)rec);
        }
        inlineWriter.close();
        byte[] inlineBytes = this.getBytesToInline(outerInMemFSPath);
        long startOffset = this.generateOuterFile(outerPath, inlineBytes);
        long inlineLength = inlineBytes.length;
        Path inlinePath = new Path(FileSystemTestUtils.getPhantomFile(new StoragePath(outerPath.toUri()), startOffset, inlineLength).toUri());
        ParquetReader inLineReader = AvroParquetReader.builder((Path)inlinePath).withConf(this.inlineConf).build();
        List<GenericRecord> records = TestParquetInLining.readParquetGenericRecords(inLineReader);
        Assertions.assertArrayEquals((Object[])recordsToWrite.toArray(), (Object[])records.toArray());
        inLineReader.close();
    }

    private long generateOuterFile(Path outerPath, byte[] inlineBytes) throws IOException {
        FSDataOutputStream wrappedOut = outerPath.getFileSystem(this.inMemoryConf).create(outerPath, true);
        this.writeRandomBytes(wrappedOut, 10);
        long startOffset = wrappedOut.getPos();
        wrappedOut.write(inlineBytes);
        this.writeRandomBytes(wrappedOut, 5);
        wrappedOut.hsync();
        wrappedOut.close();
        return startOffset;
    }

    private byte[] getBytesToInline(Path outerInMemFSPath) throws IOException {
        InMemoryFileSystem inMemoryFileSystem = (InMemoryFileSystem)outerInMemFSPath.getFileSystem(this.inMemoryConf);
        return inMemoryFileSystem.getFileAsBytes();
    }

    static List<GenericRecord> readParquetGenericRecords(ParquetReader reader) throws IOException {
        ArrayList<GenericRecord> toReturn = new ArrayList<GenericRecord>();
        Object obj = reader.read();
        while (obj instanceof GenericRecord) {
            toReturn.add((GenericRecord)obj);
            obj = reader.read();
        }
        return toReturn;
    }

    private void writeRandomBytes(FSDataOutputStream writer, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            writer.writeUTF(UUID.randomUUID().toString());
        }
    }

    static List<GenericRecord> getParquetHoodieRecords() throws IOException {
        HoodieTestDataGenerator dataGenerator = new HoodieTestDataGenerator();
        String commitTime = "001";
        List hoodieRecords = dataGenerator.generateInsertsWithHoodieAvroPayload(commitTime, 10);
        ArrayList<GenericRecord> toReturn = new ArrayList<GenericRecord>();
        for (HoodieRecord record : hoodieRecords) {
            toReturn.add((GenericRecord)((HoodieAvroRecord)record).getData().getInsertValue(HoodieTestDataGenerator.AVRO_SCHEMA).get());
        }
        return toReturn;
    }
}

