/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestHoodieDeleteBlock {
    private static String KEY_PREFIX = "key";
    private static String PARTITION_PATH = "2023-01-01";
    private static Random random = new Random();

    @Test
    public void testSerializeAndDeserializeV3DeleteBlock() throws IOException {
        DeleteRecord[] deleteRecords = (DeleteRecord[])IntStream.range(0, 100).mapToObj(i -> DeleteRecord.create((String)(KEY_PREFIX + i), (String)PARTITION_PATH, (Comparable)Long.valueOf(random.nextLong()))).toArray(DeleteRecord[]::new);
        this.testDeleteBlockWithValidation(deleteRecords);
    }

    @Test
    public void testDeserializeV2DeleteBlock() {
        byte[] contentBytes = new byte[]{0, 0, 0, 2, 0, 0, 0, -88, 1, 0, 91, 76, 111, 114, 103, 46, 97, 112, 97, 99, 104, 101, 46, 104, 117, 100, 105, 46, 99, 111, 109, 109, 111, 110, 46, 109, 111, 100, 101, 108, 46, 68, 101, 108, 101, 116, 101, 82, 101, 99, 111, 114, 100, -69, 1, 3, 1, 1, 111, 114, 103, 46, 97, 112, 97, 99, 104, 101, 46, 104, 117, 100, 105, 46, 99, 111, 109, 109, 111, 110, 46, 109, 111, 100, 101, 108, 46, 68, 101, 108, 101, 116, 101, 82, 101, 99, 111, 114, -28, 1, 1, 2, 111, 114, 103, 46, 97, 112, 97, 99, 104, 101, 46, 104, 117, 100, 105, 46, 99, 111, 109, 109, 111, 110, 46, 109, 111, 100, 101, 108, 46, 72, 111, 111, 100, 105, 101, 75, 101, -7, 1, 1, 50, 48, 50, 51, 45, 48, 49, 45, 48, -79, 1, 107, 101, 121, -79, 2, -30, 91, 1, 1, 1, 1, 2, 1, 5, 1, 107, 101, 121, -78, 2, -60, -73, 1};
        DeleteRecord[] deleteRecords = (DeleteRecord[])IntStream.range(1, 3).mapToObj(i -> DeleteRecord.create((String)(KEY_PREFIX + i), (String)PARTITION_PATH, (Comparable)Integer.valueOf(i * 5873))).toArray(DeleteRecord[]::new);
        HoodieDeleteBlock deserializeDeleteBlock = new HoodieDeleteBlock(Option.of((Object)contentBytes), null, true, Option.empty(), new HashMap(), new HashMap());
        DeleteRecord[] deserializedDeleteRecords = deserializeDeleteBlock.getRecordsToDelete();
        Assertions.assertEquals(Arrays.stream(deleteRecords).sorted(Comparator.comparing(DeleteRecord::getRecordKey)).collect(Collectors.toList()), Arrays.stream(deserializedDeleteRecords).sorted(Comparator.comparing(DeleteRecord::getRecordKey)).collect(Collectors.toList()));
    }

    public static Stream<Arguments> orderingValueParams() {
        Object[][] data = new Object[][]{{new Boolean[]{false, true}}, {new Integer[]{Integer.MIN_VALUE, 14235, 2147465340, Integer.MAX_VALUE}}, {new Long[]{Long.MIN_VALUE, -233498L, 2930275823L, Long.MAX_VALUE}}, {new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(0.125f), Float.valueOf(Float.MAX_VALUE)}}, {new Double[]{Double.MIN_VALUE, 0.125, 809.25, Double.MAX_VALUE}}, {new String[]{"val1", "val2", "val3", null}}, {new Timestamp[]{new Timestamp(1690766971000L), new Timestamp(1672536571000L)}}, {new BigDecimal[]{new BigDecimal("12345678901234.2948"), new BigDecimal("23456789012345.4856")}}};
        return Stream.of(data).map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"orderingValueParams"})
    public void testOrderingValueInDeleteRecords(Comparable[] orderingValues) throws IOException {
        DeleteRecord[] deleteRecords = new DeleteRecord[orderingValues.length];
        for (int i = 0; i < orderingValues.length; ++i) {
            deleteRecords[i] = DeleteRecord.create((String)(KEY_PREFIX + i), (String)PARTITION_PATH, (Comparable)orderingValues[i]);
        }
        this.testDeleteBlockWithValidation(deleteRecords);
    }

    public void testDeleteBlockWithValidation(DeleteRecord[] deleteRecords) throws IOException {
        ArrayList<Pair> deleteRecordList = new ArrayList<Pair>();
        for (DeleteRecord dr : deleteRecords) {
            deleteRecordList.add(Pair.of((Object)dr, (Object)-1L));
        }
        HoodieDeleteBlock deleteBlock = new HoodieDeleteBlock(deleteRecordList, new HashMap());
        byte[] contentBytes = deleteBlock.getContentBytes(HoodieTestUtils.getDefaultStorage()).toByteArray();
        HoodieDeleteBlock deserializeDeleteBlock = new HoodieDeleteBlock(Option.of((Object)contentBytes), null, true, Option.empty(), new HashMap(), new HashMap());
        DeleteRecord[] deserializedDeleteRecords = deserializeDeleteBlock.getRecordsToDelete();
        Assertions.assertEquals((int)deleteRecords.length, (int)deserializedDeleteRecords.length);
        for (int i = 0; i < deleteRecords.length; ++i) {
            Assertions.assertEquals((Object)deleteRecords[i].getHoodieKey(), (Object)deserializedDeleteRecords[i].getHoodieKey());
            if (deleteRecords[i].getOrderingValue() != null) {
                if (deleteRecords[i].getOrderingValue() instanceof Timestamp) {
                    Assertions.assertEquals((long)((Timestamp)deleteRecords[i].getOrderingValue()).getTime(), (long)((Timestamp)deserializedDeleteRecords[i].getOrderingValue()).getTime());
                    continue;
                }
                if (deleteRecords[i].getOrderingValue() instanceof BigDecimal) {
                    Assertions.assertEquals((Object)"0.000000000000000", (Object)((BigDecimal)deleteRecords[i].getOrderingValue()).subtract((BigDecimal)deserializedDeleteRecords[i].getOrderingValue()).toPlainString());
                    continue;
                }
                Assertions.assertEquals((Object)deleteRecords[i].getOrderingValue(), (Object)deserializedDeleteRecords[i].getOrderingValue());
                continue;
            }
            Assertions.assertNull((Object)deserializedDeleteRecords[i].getOrderingValue());
        }
    }
}

