/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieActionInstant;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.versioning.clean.CleanPlanV2MigrationHandler;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TestClusteringUtils
extends HoodieCommonTestHarness {
    private static final String CLUSTERING_STRATEGY_CLASS = "org.apache.hudi.DefaultClusteringStrategy";
    private static final Map<String, String> STRATEGY_PARAMS = new HashMap<String, String>(){
        {
            this.put("sortColumn", "record_key");
        }
    };

    @BeforeEach
    public void init() throws IOException {
        this.initMetaClient();
    }

    @Test
    public void testClusteringPlanMultipleInstants() throws Exception {
        String partitionPath1 = "partition1";
        ArrayList<String> fileIds1 = new ArrayList<String>();
        fileIds1.add(UUID.randomUUID().toString());
        fileIds1.add(UUID.randomUUID().toString());
        String clusterTime1 = "1";
        this.createRequestedClusterInstant(partitionPath1, clusterTime1, fileIds1);
        ArrayList<String> fileIds2 = new ArrayList<String>();
        fileIds2.add(UUID.randomUUID().toString());
        fileIds2.add(UUID.randomUUID().toString());
        fileIds2.add(UUID.randomUUID().toString());
        ArrayList<String> fileIds3 = new ArrayList<String>();
        fileIds3.add(UUID.randomUUID().toString());
        String clusterTime = "2";
        this.createRequestedClusterInstant(partitionPath1, clusterTime, fileIds2, fileIds3);
        this.createRequestedReplaceInstantNotClustering("3");
        this.metaClient.getActiveTimeline().createNewInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "replacecommit", "4"));
        this.metaClient.reloadActiveTimeline();
        Assertions.assertEquals((int)2, (int)this.metaClient.getActiveTimeline().filterPendingClusteringTimeline().countInstants());
        Map fileGroupToInstantMap = ClusteringUtils.getAllFileGroupsInPendingClusteringPlans((HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((int)(fileIds1.size() + fileIds2.size() + fileIds3.size()), (int)fileGroupToInstantMap.size());
        this.validateClusteringInstant(fileIds1, partitionPath1, clusterTime1, fileGroupToInstantMap);
        this.validateClusteringInstant(fileIds2, partitionPath1, clusterTime, fileGroupToInstantMap);
        this.validateClusteringInstant(fileIds3, partitionPath1, clusterTime, fileGroupToInstantMap);
        Option lastPendingClustering = this.metaClient.getActiveTimeline().getLastPendingClusterInstant();
        Assertions.assertTrue((boolean)lastPendingClustering.isPresent());
        Assertions.assertEquals((Object)"2", (Object)((HoodieInstant)lastPendingClustering.get()).requestedTime());
        HoodieInstant inflight = this.metaClient.getActiveTimeline().transitionClusterRequestedToInflight((HoodieInstant)lastPendingClustering.get(), Option.empty());
        Assertions.assertEquals((Object)HoodieInstant.State.INFLIGHT, (Object)inflight.getState());
        lastPendingClustering = this.metaClient.reloadActiveTimeline().getLastPendingClusterInstant();
        Assertions.assertEquals((Object)"2", (Object)((HoodieInstant)lastPendingClustering.get()).requestedTime());
        HoodieInstant complete = this.metaClient.getActiveTimeline().transitionClusterInflightToComplete(false, inflight, new HoodieReplaceCommitMetadata());
        Assertions.assertEquals((Object)HoodieInstant.State.COMPLETED, (Object)complete.getState());
        lastPendingClustering = this.metaClient.reloadActiveTimeline().getLastPendingClusterInstant();
        Assertions.assertEquals((Object)"1", (Object)((HoodieInstant)lastPendingClustering.get()).requestedTime());
    }

    @Disabled(value="Will fail due to avro issue AVRO-3789. This is fixed in avro 1.11.3")
    @Test
    public void testClusteringPlanInflight() throws Exception {
        String partitionPath1 = "partition1";
        ArrayList<String> fileIds1 = new ArrayList<String>();
        fileIds1.add(UUID.randomUUID().toString());
        fileIds1.add(UUID.randomUUID().toString());
        String clusterTime1 = "1";
        HoodieInstant requestedInstant = this.createRequestedClusterInstant(partitionPath1, clusterTime1, fileIds1);
        HoodieInstant inflightInstant = this.metaClient.getActiveTimeline().transitionReplaceRequestedToInflight(requestedInstant, Option.empty());
        Assertions.assertTrue((boolean)ClusteringUtils.isClusteringInstant((HoodieTimeline)this.metaClient.getActiveTimeline(), (HoodieInstant)requestedInstant, (InstantGenerator)HoodieTestUtils.INSTANT_GENERATOR));
        HoodieClusteringPlan requestedClusteringPlan = (HoodieClusteringPlan)((Pair)ClusteringUtils.getClusteringPlan((HoodieTableMetaClient)this.metaClient, (HoodieInstant)requestedInstant).get()).getRight();
        Assertions.assertTrue((boolean)ClusteringUtils.isClusteringInstant((HoodieTimeline)this.metaClient.getActiveTimeline(), (HoodieInstant)inflightInstant, (InstantGenerator)HoodieTestUtils.INSTANT_GENERATOR));
        HoodieClusteringPlan inflightClusteringPlan = (HoodieClusteringPlan)((Pair)ClusteringUtils.getClusteringPlan((HoodieTableMetaClient)this.metaClient, (HoodieInstant)inflightInstant).get()).getRight();
        Assertions.assertEquals((Object)requestedClusteringPlan, (Object)inflightClusteringPlan);
    }

    @Test
    public void testGetOldestInstantToRetainForClustering() throws IOException {
        String partitionPath1 = "partition1";
        ArrayList<String> fileIds1 = new ArrayList<String>();
        fileIds1.add(UUID.randomUUID().toString());
        String clusterTime1 = "1";
        HoodieInstant requestedInstant1 = this.createRequestedClusterInstant(partitionPath1, clusterTime1, fileIds1);
        HoodieInstant inflightInstant1 = this.metaClient.getActiveTimeline().transitionClusterRequestedToInflight(requestedInstant1, Option.empty());
        this.metaClient.getActiveTimeline().transitionClusterInflightToComplete(true, inflightInstant1, new HoodieReplaceCommitMetadata());
        ArrayList<String> fileIds2 = new ArrayList<String>();
        fileIds2.add(UUID.randomUUID().toString());
        fileIds2.add(UUID.randomUUID().toString());
        String clusterTime2 = "2";
        HoodieInstant requestedInstant2 = this.createRequestedClusterInstant(partitionPath1, clusterTime2, fileIds2);
        HoodieInstant inflightInstant2 = this.metaClient.getActiveTimeline().transitionClusterRequestedToInflight(requestedInstant2, Option.empty());
        this.metaClient.getActiveTimeline().transitionClusterInflightToComplete(true, inflightInstant2, new HoodieReplaceCommitMetadata());
        ArrayList<String> fileIds3 = new ArrayList<String>();
        fileIds3.add(UUID.randomUUID().toString());
        fileIds3.add(UUID.randomUUID().toString());
        fileIds3.add(UUID.randomUUID().toString());
        String clusterTime3 = "3";
        HoodieInstant requestedInstant3 = this.createRequestedClusterInstant(partitionPath1, clusterTime3, fileIds3);
        HoodieInstant inflightInstant3 = this.metaClient.getActiveTimeline().transitionClusterRequestedToInflight(requestedInstant3, Option.empty());
        HoodieInstant completedInstant3 = this.metaClient.getActiveTimeline().transitionClusterInflightToComplete(true, inflightInstant3, new HoodieReplaceCommitMetadata());
        this.metaClient.reloadActiveTimeline();
        Option actual = ClusteringUtils.getEarliestInstantToRetainForClustering((HoodieActiveTimeline)this.metaClient.getActiveTimeline(), (HoodieTableMetaClient)this.metaClient, null);
        Assertions.assertTrue((boolean)actual.isPresent());
        Assertions.assertEquals((Object)clusterTime1, (Object)((HoodieInstant)actual.get()).requestedTime(), (String)"no clean in timeline, retain first replace commit");
        String cleanTime1 = "4";
        HoodieInstant requestedInstant4 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "clean", cleanTime1);
        HoodieCleanerPlan cleanerPlan1 = HoodieCleanerPlan.newBuilder().setEarliestInstantToRetainBuilder(HoodieActionInstant.newBuilder().setAction(completedInstant3.getAction()).setTimestamp(completedInstant3.requestedTime()).setState(completedInstant3.getState().name())).setPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS.name()).setFilesToBeDeletedPerPartition(new HashMap()).setVersion(CleanPlanV2MigrationHandler.VERSION).build();
        this.metaClient.getActiveTimeline().saveToCleanRequested(requestedInstant4, Option.of((Object)cleanerPlan1));
        HoodieInstant inflightInstant4 = this.metaClient.getActiveTimeline().transitionCleanRequestedToInflight(requestedInstant4, Option.empty());
        HoodieCleanMetadata cleanMetadata = new HoodieCleanMetadata(cleanTime1, Long.valueOf(1L), Integer.valueOf(1), completedInstant3.requestedTime(), "", Collections.emptyMap(), Integer.valueOf(0), Collections.emptyMap(), Collections.emptyMap());
        this.metaClient.getActiveTimeline().transitionCleanInflightToComplete(true, inflightInstant4, Option.of((Object)cleanMetadata));
        this.metaClient.reloadActiveTimeline();
        actual = ClusteringUtils.getEarliestInstantToRetainForClustering((HoodieActiveTimeline)this.metaClient.getActiveTimeline(), (HoodieTableMetaClient)this.metaClient, null);
        Assertions.assertEquals((Object)clusterTime3, (Object)((HoodieInstant)actual.get()).requestedTime(), (String)"retain the first replace commit after the earliestInstantToRetain ");
    }

    @Test
    public void testGetOldestInstantToRetainForClusteringKeepFileVersion() throws IOException {
        String partitionPath1 = "partition1";
        ArrayList<String> fileIds1 = new ArrayList<String>();
        fileIds1.add(UUID.randomUUID().toString());
        String clusterTime1 = "1";
        HoodieInstant requestedInstant1 = this.createRequestedClusterInstant(partitionPath1, clusterTime1, fileIds1);
        HoodieInstant inflightInstant1 = this.metaClient.getActiveTimeline().transitionClusterRequestedToInflight(requestedInstant1, Option.empty());
        this.metaClient.getActiveTimeline().transitionClusterInflightToComplete(true, inflightInstant1, new HoodieReplaceCommitMetadata());
        String cleanTime1 = "2";
        HoodieInstant requestedInstant2 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "clean", cleanTime1);
        HoodieCleanerPlan cleanerPlan1 = new HoodieCleanerPlan(null, clusterTime1, HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS.name(), Collections.emptyMap(), CleanPlanV2MigrationHandler.VERSION, Collections.emptyMap(), Collections.emptyList(), Collections.EMPTY_MAP);
        this.metaClient.getActiveTimeline().saveToCleanRequested(requestedInstant2, Option.of((Object)cleanerPlan1));
        HoodieInstant inflightInstant2 = this.metaClient.getActiveTimeline().transitionCleanRequestedToInflight(requestedInstant2, Option.empty());
        HoodieCleanMetadata cleanMetadata = new HoodieCleanMetadata(cleanTime1, Long.valueOf(1L), Integer.valueOf(1), "", "", Collections.emptyMap(), Integer.valueOf(0), Collections.emptyMap(), Collections.emptyMap());
        this.metaClient.getActiveTimeline().transitionCleanInflightToComplete(true, inflightInstant2, Option.of((Object)cleanMetadata));
        this.metaClient.reloadActiveTimeline();
        ArrayList<String> fileIds2 = new ArrayList<String>();
        fileIds2.add(UUID.randomUUID().toString());
        fileIds2.add(UUID.randomUUID().toString());
        String clusterTime2 = "3";
        HoodieInstant requestedInstant3 = this.createRequestedClusterInstant(partitionPath1, clusterTime2, fileIds2);
        HoodieInstant inflightInstant3 = this.metaClient.getActiveTimeline().transitionClusterRequestedToInflight(requestedInstant3, Option.empty());
        this.metaClient.getActiveTimeline().transitionClusterInflightToComplete(true, inflightInstant3, new HoodieReplaceCommitMetadata());
        this.metaClient.reloadActiveTimeline();
        Option actual = ClusteringUtils.getEarliestInstantToRetainForClustering((HoodieActiveTimeline)this.metaClient.getActiveTimeline(), (HoodieTableMetaClient)this.metaClient, (HoodieCleaningPolicy)HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS);
        Assertions.assertEquals((Object)clusterTime2, (Object)((HoodieInstant)actual.get()).requestedTime(), (String)"retain the first replace commit after the last complete clean ");
    }

    private void validateClusteringInstant(List<String> fileIds, String partitionPath, String expectedInstantTime, Map<HoodieFileGroupId, HoodieInstant> fileGroupToInstantMap) {
        for (String fileId : fileIds) {
            Assertions.assertEquals((Object)expectedInstantTime, (Object)fileGroupToInstantMap.get(new HoodieFileGroupId(partitionPath, fileId)).requestedTime());
        }
    }

    private HoodieInstant createRequestedReplaceInstantNotClustering(String instantTime) {
        HoodieInstant newRequestedInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "replacecommit", instantTime);
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = HoodieRequestedReplaceMetadata.newBuilder().setOperationType(WriteOperationType.UNKNOWN.name()).build();
        this.metaClient.getActiveTimeline().saveToPendingReplaceCommit(newRequestedInstant, requestedReplaceMetadata);
        return newRequestedInstant;
    }

    private HoodieInstant createRequestedClusterInstant(String partitionPath1, String clusterTime, List<String> ... fileIds) throws IOException {
        List[] fileSliceGroups = new List[fileIds.length];
        for (int i = 0; i < fileIds.length; ++i) {
            fileSliceGroups[i] = fileIds[i].stream().map(fileId -> this.generateFileSlice(partitionPath1, (String)fileId, "0")).collect(Collectors.toList());
        }
        HoodieClusteringPlan clusteringPlan = ClusteringUtils.createClusteringPlan((String)CLUSTERING_STRATEGY_CLASS, STRATEGY_PARAMS, (List[])fileSliceGroups, Collections.emptyMap());
        HoodieInstant clusteringInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "clustering", clusterTime);
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = HoodieRequestedReplaceMetadata.newBuilder().setClusteringPlan(clusteringPlan).setOperationType(WriteOperationType.CLUSTER.name()).build();
        this.metaClient.getActiveTimeline().saveToPendingClusterCommit(clusteringInstant, requestedReplaceMetadata);
        return clusteringInstant;
    }

    private FileSlice generateFileSlice(String partitionPath, String fileId, String baseInstant) {
        FileSlice fs = new FileSlice(new HoodieFileGroupId(partitionPath, fileId), baseInstant);
        fs.setBaseFile(new HoodieBaseFile(FSUtils.makeBaseFileName((String)baseInstant, (String)"1-0-1", (String)fileId, (String)BASE_FILE_EXTENSION)));
        return fs;
    }

    @Override
    protected HoodieTableType getTableType() {
        return HoodieTableType.MERGE_ON_READ;
    }
}

