/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.fs;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;

public class TestHadoopFSUtils {
    @ParameterizedTest
    @ValueSource(strings={"/a/b/c", "s3://bucket/partition=1%2F2%2F3", "hdfs://x/y/z.file#bar"})
    public void testPathConversion(String pathString) {
        Path path = new Path(pathString);
        StoragePath storagePath = HadoopFSUtils.convertToStoragePath((Path)path);
        Path convertedPath = HadoopFSUtils.convertToHadoopPath((StoragePath)storagePath);
        Assertions.assertEquals((Object)path.toUri(), (Object)storagePath.toUri());
        Assertions.assertEquals((Object)path, (Object)convertedPath);
        storagePath = new StoragePath(pathString);
        path = HadoopFSUtils.convertToHadoopPath((StoragePath)storagePath);
        StoragePath convertedStoragePath = HadoopFSUtils.convertToStoragePath((Path)path);
        Assertions.assertEquals((Object)storagePath.toUri(), (Object)path.toUri());
        Assertions.assertEquals((Object)storagePath, (Object)convertedStoragePath);
    }

    @ParameterizedTest
    @CsvSource(value={"/a/b/c,1000,false,1,1000000,1238493920", "/x/y/z,0,true,2,0,2002403203"})
    public void testFileStatusConversion(String path, long length, boolean isDirectory, short blockReplication, long blockSize, long modificationTime) {
        FileStatus fileStatus = new FileStatus(length, isDirectory, (int)blockReplication, blockSize, modificationTime, new Path(path));
        StoragePathInfo pathInfo = HadoopFSUtils.convertToStoragePathInfo((FileStatus)fileStatus);
        this.assertStoragePathInfo(pathInfo, path, length, isDirectory, blockReplication, blockSize, modificationTime);
        FileStatus convertedFileStatus = HadoopFSUtils.convertToHadoopFileStatus((StoragePathInfo)pathInfo);
        this.assertFileStatus(convertedFileStatus, path, length, isDirectory, blockReplication, blockSize, modificationTime);
        pathInfo = new StoragePathInfo(new StoragePath(path), length, isDirectory, blockReplication, blockSize, modificationTime);
        fileStatus = HadoopFSUtils.convertToHadoopFileStatus((StoragePathInfo)pathInfo);
        this.assertFileStatus(fileStatus, path, length, isDirectory, blockReplication, blockSize, modificationTime);
        StoragePathInfo convertedPathInfo = HadoopFSUtils.convertToStoragePathInfo((FileStatus)fileStatus);
        this.assertStoragePathInfo(convertedPathInfo, path, length, isDirectory, blockReplication, blockSize, modificationTime);
    }

    private void assertFileStatus(FileStatus fileStatus, String path, long length, boolean isDirectory, short blockReplication, long blockSize, long modificationTime) {
        Assertions.assertEquals((Object)new Path(path), (Object)fileStatus.getPath());
        Assertions.assertEquals((long)length, (long)fileStatus.getLen());
        Assertions.assertEquals((Object)isDirectory, (Object)fileStatus.isDirectory());
        Assertions.assertEquals((Object)(!isDirectory ? 1 : 0), (Object)fileStatus.isFile());
        Assertions.assertEquals((short)blockReplication, (short)fileStatus.getReplication());
        Assertions.assertEquals((long)blockSize, (long)fileStatus.getBlockSize());
        Assertions.assertEquals((long)modificationTime, (long)fileStatus.getModificationTime());
    }

    private void assertStoragePathInfo(StoragePathInfo pathInfo, String path, long length, boolean isDirectory, short blockReplication, long blockSize, long modificationTime) {
        Assertions.assertEquals((Object)new StoragePath(path), (Object)pathInfo.getPath());
        Assertions.assertEquals((long)length, (long)pathInfo.getLength());
        Assertions.assertEquals((Object)isDirectory, (Object)pathInfo.isDirectory());
        Assertions.assertEquals((Object)(!isDirectory ? 1 : 0), (Object)pathInfo.isFile());
        Assertions.assertEquals((short)blockReplication, (short)pathInfo.getBlockReplication());
        Assertions.assertEquals((long)blockSize, (long)pathInfo.getBlockSize());
        Assertions.assertEquals((long)modificationTime, (long)pathInfo.getModificationTime());
    }
}

