/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.avro.HoodieAvroReadSupport;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TestHoodieAvroReadSupport {
    private final Type legacyListType = ConversionPatterns.listType((Type.Repetition)Type.Repetition.REQUIRED, (String)"legacyList", (Type)((Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REPEATED).named("double_field")));
    private final Type legacyListTypeWithObject = ConversionPatterns.listType((Type.Repetition)Type.Repetition.REQUIRED, (String)"legacyList", (Type)new MessageType("foo", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REPEATED).named("double_field")}));
    private final Type listType = ConversionPatterns.listOfElements((Type.Repetition)Type.Repetition.REQUIRED, (String)"newList", (Type)((Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REPEATED).named("element")));
    private final Type integerField = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named("int_field");
    private final Type legacyMapType = new GroupType(Type.Repetition.OPTIONAL, "my_map", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "map", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).named("key"), (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).named("value")})});
    private final Type mapType = ConversionPatterns.stringKeyMapType((Type.Repetition)Type.Repetition.OPTIONAL, (String)"newMap", (Type)((Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).named("value")));
    private final Configuration configuration = (Configuration)Mockito.mock(Configuration.class);

    TestHoodieAvroReadSupport() {
    }

    @Test
    void fileContainsLegacyList() {
        Mockito.when((Object)this.configuration.getBoolean("parquet.avro.write-old-list-structure", true)).thenReturn((Object)false);
        MessageType messageType = new MessageType("LegacyList", new Type[]{this.integerField, this.legacyListType, this.mapType});
        new HoodieAvroReadSupport().init(this.configuration, Collections.emptyMap(), messageType);
        ((Configuration)Mockito.verify((Object)this.configuration)).set((String)ArgumentMatchers.eq((Object)"parquet.avro.write-old-list-structure"), (String)ArgumentMatchers.eq((Object)"true"), ArgumentMatchers.anyString());
    }

    @Test
    void fileContainsLegacyListWithElements() {
        Mockito.when((Object)this.configuration.getBoolean("parquet.avro.write-old-list-structure", true)).thenReturn((Object)false);
        MessageType messageType = new MessageType("LegacyList", new Type[]{this.integerField, this.legacyListTypeWithObject, this.mapType});
        new HoodieAvroReadSupport().init(this.configuration, Collections.emptyMap(), messageType);
        ((Configuration)Mockito.verify((Object)this.configuration)).set((String)ArgumentMatchers.eq((Object)"parquet.avro.write-old-list-structure"), (String)ArgumentMatchers.eq((Object)"true"), ArgumentMatchers.anyString());
    }

    @Test
    void fileContainsLegacyMap() {
        Mockito.when((Object)this.configuration.getBoolean("parquet.avro.write-old-list-structure", true)).thenReturn((Object)false);
        MessageType messageType = new MessageType("LegacyList", new Type[]{this.integerField, this.legacyMapType, this.listType});
        new HoodieAvroReadSupport().init(this.configuration, Collections.emptyMap(), messageType);
        ((Configuration)Mockito.verify((Object)this.configuration)).set((String)ArgumentMatchers.eq((Object)"parquet.avro.write-old-list-structure"), (String)ArgumentMatchers.eq((Object)"true"), ArgumentMatchers.anyString());
    }

    @Test
    void fileContainsNewListAndMap() {
        Mockito.when((Object)this.configuration.get("parquet.avro.write-old-list-structure")).thenReturn(null);
        MessageType messageType = new MessageType("newFieldTypes", new Type[]{this.listType, this.mapType, this.integerField});
        new HoodieAvroReadSupport().init(this.configuration, Collections.emptyMap(), messageType);
        ((Configuration)Mockito.verify((Object)this.configuration)).set((String)ArgumentMatchers.eq((Object)"parquet.avro.write-old-list-structure"), (String)ArgumentMatchers.eq((Object)"false"), ArgumentMatchers.anyString());
    }

    @Test
    void fileContainsNoListOrMap() {
        MessageType messageType = new MessageType("noListOrMap", new Type[]{this.integerField});
        new HoodieAvroReadSupport().init(this.configuration, Collections.emptyMap(), messageType);
        ((Configuration)Mockito.verify((Object)this.configuration, (VerificationMode)Mockito.never())).set(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
    }

    @Test
    void nestedLegacyList() {
        Mockito.when((Object)this.configuration.getBoolean("parquet.avro.write-old-list-structure", true)).thenReturn((Object)false);
        MessageType nested = new MessageType("Nested", new Type[]{this.integerField, this.legacyListType});
        MessageType messageType = new MessageType("NestedList", new Type[]{this.integerField, nested});
        new HoodieAvroReadSupport().init(this.configuration, Collections.emptyMap(), messageType);
        ((Configuration)Mockito.verify((Object)this.configuration)).set((String)ArgumentMatchers.eq((Object)"parquet.avro.write-old-list-structure"), (String)ArgumentMatchers.eq((Object)"true"), ArgumentMatchers.anyString());
    }

    @Test
    void nestedLegacyMap() {
        Mockito.when((Object)this.configuration.getBoolean("parquet.avro.write-old-list-structure", true)).thenReturn((Object)false);
        MessageType nested = new MessageType("Nested", new Type[]{this.integerField, this.legacyMapType});
        MessageType messageType = new MessageType("NestedList", new Type[]{this.integerField, nested});
        new HoodieAvroReadSupport().init(this.configuration, Collections.emptyMap(), messageType);
        ((Configuration)Mockito.verify((Object)this.configuration)).set((String)ArgumentMatchers.eq((Object)"parquet.avro.write-old-list-structure"), (String)ArgumentMatchers.eq((Object)"true"), ArgumentMatchers.anyString());
    }

    @Test
    void mapWithLegacyList() {
        Mockito.when((Object)this.configuration.getBoolean("parquet.avro.write-old-list-structure", true)).thenReturn((Object)false);
        GroupType listValue = ConversionPatterns.listType((Type.Repetition)Type.Repetition.REQUIRED, (String)"value", (Type)((Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REPEATED).named("double_field")));
        GroupType mapWithList = ConversionPatterns.stringKeyMapType((Type.Repetition)Type.Repetition.OPTIONAL, (String)"newMap", (Type)listValue);
        MessageType messageType = new MessageType("NestedList", new Type[]{this.integerField, mapWithList});
        new HoodieAvroReadSupport().init(this.configuration, Collections.emptyMap(), messageType);
        ((Configuration)Mockito.verify((Object)this.configuration)).set((String)ArgumentMatchers.eq((Object)"parquet.avro.write-old-list-structure"), (String)ArgumentMatchers.eq((Object)"true"), ArgumentMatchers.anyString());
    }
}

