/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.fs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hudi.avro.model.HoodieFSPermission;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.avro.model.HoodiePath;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.InvalidHoodiePathException;
import org.apache.hudi.hadoop.fs.BoundedFsDataInputStream;
import org.apache.hudi.hadoop.fs.HoodieWrapperFileSystem;
import org.apache.hudi.hadoop.fs.SchemeAwareFSDataInputStream;
import org.apache.hudi.hadoop.fs.TimedFSDataInputStream;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.storage.StorageSchemes;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopFSUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopFSUtils.class);
    private static final String HOODIE_ENV_PROPS_PREFIX = "HOODIE_ENV_";
    private static final int MAX_ATTEMPTS_RECOVER_LEASE = 10;

    public static Configuration prepareHadoopConf(Configuration conf) {
        for (Map.Entry<String, String> prop : System.getenv().entrySet()) {
            if (!prop.getKey().startsWith(HOODIE_ENV_PROPS_PREFIX)) continue;
            LOG.info("Picking up value for hoodie env var : {}", (Object)prop.getKey());
            conf.set(prop.getKey().replace(HOODIE_ENV_PROPS_PREFIX, "").replaceAll("_DOT_", "."), prop.getValue());
        }
        return conf;
    }

    public static StorageConfiguration<Configuration> getStorageConf(Configuration conf) {
        return HadoopFSUtils.getStorageConf(conf, false);
    }

    public static StorageConfiguration<Configuration> getStorageConf() {
        return HadoopFSUtils.getStorageConf(HadoopFSUtils.prepareHadoopConf(new Configuration()), false);
    }

    public static StorageConfiguration<Configuration> getStorageConfWithCopy(Configuration conf) {
        return HadoopFSUtils.getStorageConf(conf, true);
    }

    public static <T> FileSystem getFs(String pathStr, StorageConfiguration<T> storageConf) {
        return HadoopFSUtils.getFs(new Path(pathStr), storageConf);
    }

    public static <T> FileSystem getFs(String pathStr, StorageConfiguration<T> storageConf, boolean newCopy) {
        return HadoopFSUtils.getFs(new Path(pathStr), storageConf, newCopy);
    }

    public static <T> FileSystem getFs(Path path, StorageConfiguration<T> storageConf) {
        return HadoopFSUtils.getFs(path, storageConf, false);
    }

    public static <T> FileSystem getFs(Path path, StorageConfiguration<T> storageConf, boolean newCopy) {
        Configuration conf = newCopy ? (Configuration)storageConf.unwrapCopyAs(Configuration.class) : (Configuration)storageConf.unwrapAs(Configuration.class);
        return HadoopFSUtils.getFs(path, conf);
    }

    public static FileSystem getFs(String pathStr, Configuration conf) {
        return HadoopFSUtils.getFs(new Path(pathStr), conf);
    }

    public static FileSystem getFs(StoragePath path, Configuration conf) {
        return HadoopFSUtils.getFs(HadoopFSUtils.convertToHadoopPath(path), conf);
    }

    public static FileSystem getFs(Path path, Configuration conf) {
        FileSystem fs;
        HadoopFSUtils.prepareHadoopConf(conf);
        try {
            fs = path.getFileSystem(conf);
        }
        catch (IOException e) {
            throw new HoodieIOException(String.format("Failed to get instance of %s", FileSystem.class.getName()), e);
        }
        return fs;
    }

    public static FileSystem getFs(String pathStr, Configuration conf, boolean localByDefault) {
        if (localByDefault) {
            return HadoopFSUtils.getFs(HadoopFSUtils.addSchemeIfLocalPath(pathStr), conf);
        }
        return HadoopFSUtils.getFs(pathStr, conf);
    }

    public static Path addSchemeIfLocalPath(String path) {
        Path providedPath = new Path(path);
        File localFile = new File(path);
        if (!providedPath.isAbsolute() && localFile.exists()) {
            Path resolvedPath = new Path("file://" + localFile.getAbsolutePath());
            LOG.info("Resolving file {} to be a local file.", (Object)path);
            return resolvedPath;
        }
        LOG.info("Resolving file {} to be a remote file.", (Object)path);
        return providedPath;
    }

    public static Path convertToHadoopPath(StoragePath path) {
        return new Path(path.toUri());
    }

    public static StoragePath convertToStoragePath(Path path) {
        return new StoragePath(path.toUri());
    }

    public static StoragePathInfo convertToStoragePathInfo(FileStatus fileStatus) {
        return new StoragePathInfo(HadoopFSUtils.convertToStoragePath(fileStatus.getPath()), fileStatus.getLen(), fileStatus.isDirectory(), fileStatus.getReplication(), fileStatus.getBlockSize(), fileStatus.getModificationTime());
    }

    public static StoragePathInfo convertToStoragePathInfo(FileStatus fileStatus, String[] locations) {
        return new StoragePathInfo(HadoopFSUtils.convertToStoragePath(fileStatus.getPath()), fileStatus.getLen(), fileStatus.isDirectory(), fileStatus.getReplication(), fileStatus.getBlockSize(), fileStatus.getModificationTime(), locations);
    }

    public static FileStatus convertToHadoopFileStatus(StoragePathInfo pathInfo) {
        return new FileStatus(pathInfo.getLength(), pathInfo.isDirectory(), (int)pathInfo.getBlockReplication(), pathInfo.getBlockSize(), pathInfo.getModificationTime(), HadoopFSUtils.convertToHadoopPath(pathInfo.getPath()));
    }

    public static FSDataInputStream getFSDataInputStream(FileSystem fs, StoragePath filePath, int bufferSize, boolean wrapStream) {
        FSDataInputStream fsDataInputStream = null;
        try {
            fsDataInputStream = fs.open(HadoopFSUtils.convertToHadoopPath(filePath), bufferSize);
        }
        catch (IOException e) {
            throw new HoodieIOException(String.format("Exception creating input stream from file: %s", filePath), e);
        }
        if (!wrapStream) {
            return fsDataInputStream;
        }
        if (HadoopFSUtils.isGCSFileSystem(fs)) {
            return new SchemeAwareFSDataInputStream((InputStream)HadoopFSUtils.getFSDataInputStreamForGCS(fsDataInputStream, filePath, bufferSize), true);
        }
        if (HadoopFSUtils.isCHDFileSystem(fs)) {
            return new BoundedFsDataInputStream(fs, HadoopFSUtils.convertToHadoopPath(filePath), (InputStream)fsDataInputStream);
        }
        if (fsDataInputStream.getWrappedStream() instanceof FSInputStream) {
            return new TimedFSDataInputStream(HadoopFSUtils.convertToHadoopPath(filePath), new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)fsDataInputStream.getWrappedStream(), bufferSize)));
        }
        return fsDataInputStream;
    }

    private static FSDataInputStream getFSDataInputStreamForGCS(FSDataInputStream fsDataInputStream, StoragePath filePath, int bufferSize) {
        if (fsDataInputStream.getWrappedStream() instanceof FSInputStream) {
            return new TimedFSDataInputStream(HadoopFSUtils.convertToHadoopPath(filePath), new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)fsDataInputStream.getWrappedStream(), bufferSize)));
        }
        if (fsDataInputStream.getWrappedStream() instanceof FSDataInputStream && ((FSDataInputStream)fsDataInputStream.getWrappedStream()).getWrappedStream() instanceof FSInputStream) {
            FSInputStream inputStream = (FSInputStream)((FSDataInputStream)fsDataInputStream.getWrappedStream()).getWrappedStream();
            return new TimedFSDataInputStream(HadoopFSUtils.convertToHadoopPath(filePath), new FSDataInputStream((InputStream)new BufferedFSInputStream(inputStream, bufferSize)));
        }
        return fsDataInputStream;
    }

    public static boolean isGCSFileSystem(FileSystem fs) {
        return fs.getScheme().equals(StorageSchemes.GCS.getScheme());
    }

    public static boolean isCHDFileSystem(FileSystem fs) {
        return StorageSchemes.CHDFS.getScheme().equals(fs.getScheme());
    }

    private static StorageConfiguration<Configuration> getStorageConf(Configuration conf, boolean copy) {
        return new HadoopStorageConfiguration(conf, copy);
    }

    public static Configuration registerFileSystem(StoragePath file, Configuration conf) {
        Configuration returnConf = new Configuration(conf);
        String scheme = HadoopFSUtils.getFs(file.toString(), conf).getScheme();
        returnConf.set("fs." + HoodieWrapperFileSystem.getHoodieScheme(scheme) + ".impl", HoodieWrapperFileSystem.class.getName());
        return returnConf;
    }

    public static Path toPath(HoodiePath path) {
        if (null == path) {
            return null;
        }
        return new Path(path.getUri());
    }

    public static HoodiePath fromPath(Path path) {
        if (null == path) {
            return null;
        }
        return HoodiePath.newBuilder().setUri(path.toString()).build();
    }

    public static FsPermission toFSPermission(HoodieFSPermission fsPermission) {
        if (null == fsPermission) {
            return null;
        }
        FsAction userAction = fsPermission.getUserAction() != null ? FsAction.valueOf((String)fsPermission.getUserAction()) : null;
        FsAction grpAction = fsPermission.getGroupAction() != null ? FsAction.valueOf((String)fsPermission.getGroupAction()) : null;
        FsAction otherAction = fsPermission.getOtherAction() != null ? FsAction.valueOf((String)fsPermission.getOtherAction()) : null;
        boolean stickyBit = fsPermission.getStickyBit() != null ? fsPermission.getStickyBit() : false;
        return new FsPermission(userAction, grpAction, otherAction, stickyBit);
    }

    public static HoodieFSPermission fromFSPermission(FsPermission fsPermission) {
        if (null == fsPermission) {
            return null;
        }
        String userAction = fsPermission.getUserAction() != null ? fsPermission.getUserAction().name() : null;
        String grpAction = fsPermission.getGroupAction() != null ? fsPermission.getGroupAction().name() : null;
        String otherAction = fsPermission.getOtherAction() != null ? fsPermission.getOtherAction().name() : null;
        return HoodieFSPermission.newBuilder().setUserAction(userAction).setGroupAction(grpAction).setOtherAction(otherAction).setStickyBit(Boolean.valueOf(fsPermission.getStickyBit())).build();
    }

    public static HoodieFileStatus fromFileStatus(FileStatus fileStatus) {
        if (null == fileStatus) {
            return null;
        }
        HoodieFileStatus fStatus = new HoodieFileStatus();
        try {
            fStatus.setPath(HadoopFSUtils.fromPath(fileStatus.getPath()));
            fStatus.setLength(Long.valueOf(fileStatus.getLen()));
            fStatus.setIsDir(Boolean.valueOf(fileStatus.isDirectory()));
            fStatus.setBlockReplication(Integer.valueOf(fileStatus.getReplication()));
            fStatus.setBlockSize(Long.valueOf(fileStatus.getBlockSize()));
            fStatus.setModificationTime(Long.valueOf(fileStatus.getModificationTime()));
            fStatus.setAccessTime(Long.valueOf(fileStatus.getModificationTime()));
            fStatus.setSymlink(fileStatus.isSymlink() ? HadoopFSUtils.fromPath(fileStatus.getSymlink()) : null);
            HadoopFSUtils.safeReadAndSetMetadata(fStatus, fileStatus);
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
        return fStatus;
    }

    private static void safeReadAndSetMetadata(HoodieFileStatus fStatus, FileStatus fileStatus) {
        try {
            fStatus.setOwner(fileStatus.getOwner());
            fStatus.setGroup(fileStatus.getGroup());
            fStatus.setPermission(HadoopFSUtils.fromFSPermission(fileStatus.getPermission()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static long getFileSize(FileSystem fs, Path path) throws IOException {
        return fs.getFileStatus(path).getLen();
    }

    public static String getRelativePartitionPath(Path basePath, Path fullPartitionPath) {
        return FSUtils.getRelativePartitionPath((StoragePath)new StoragePath(basePath.toUri()), (StoragePath)new StoragePath(fullPartitionPath.toUri()));
    }

    public static String getFileIdFromLogPath(Path path) {
        Matcher matcher = FSUtils.LOG_FILE_PATTERN.matcher(path.getName());
        if (!matcher.find()) {
            throw new InvalidHoodiePathException(path.toString(), "LogFile");
        }
        return matcher.group(1);
    }

    public static String getDeltaCommitTimeFromLogPath(Path path) {
        Matcher matcher = FSUtils.LOG_FILE_PATTERN.matcher(path.getName());
        if (!matcher.find()) {
            throw new InvalidHoodiePathException(path.toString(), "LogFile");
        }
        return matcher.group(2);
    }

    public static String getFileIdFromFilePath(Path filePath) {
        if (HadoopFSUtils.isLogFile(filePath)) {
            return HadoopFSUtils.getFileIdFromLogPath(filePath);
        }
        return FSUtils.getFileId((String)filePath.getName());
    }

    public static boolean isBaseFile(Path path) {
        String extension = FSUtils.getFileExtension((String)path.getName());
        return HoodieFileFormat.BASE_FILE_EXTENSIONS.contains(extension);
    }

    public static boolean isLogFile(Path logPath) {
        return FSUtils.isLogFile((StoragePath)new StoragePath(logPath.getName()));
    }

    public static boolean isDataFile(Path path) {
        return HadoopFSUtils.isBaseFile(path) || HadoopFSUtils.isLogFile(path);
    }

    public static FileStatus[] getAllDataFilesInPartition(FileSystem fs, Path partitionPath) throws IOException {
        Set validFileExtensions = Arrays.stream(HoodieFileFormat.values()).map(HoodieFileFormat::getFileExtension).collect(Collectors.toCollection(HashSet::new));
        String logFileExtension = HoodieFileFormat.HOODIE_LOG.getFileExtension();
        try {
            return (FileStatus[])Arrays.stream(fs.listStatus(partitionPath, path -> {
                String extension = FSUtils.getFileExtension((String)path.getName());
                return validFileExtensions.contains(extension) || path.getName().contains(logFileExtension);
            })).filter(FileStatus::isFile).toArray(FileStatus[]::new);
        }
        catch (IOException e) {
            if (!fs.exists(partitionPath)) {
                return new FileStatus[0];
            }
            throw e;
        }
    }

    public static boolean recoverDFSFileLease(DistributedFileSystem dfs, Path p) throws IOException, InterruptedException {
        LOG.info("Recover lease on dfs file {}", (Object)p);
        boolean recovered = false;
        for (int nbAttempt = 0; nbAttempt < 10; ++nbAttempt) {
            LOG.info("Attempt {} to recover lease on dfs file {}", (Object)nbAttempt, (Object)p);
            recovered = dfs.recoverLease(p);
            if (recovered) break;
            Thread.sleep(1000L);
        }
        return recovered;
    }

    public static Path constructAbsolutePathInHadoopPath(String basePath, String relativePartitionPath) {
        return new Path(FSUtils.constructAbsolutePath((String)basePath, (String)relativePartitionPath).toUri());
    }

    public static String getDFSFullPartitionPath(FileSystem fs, Path fullPartitionPath) {
        return fs.getUri() + fullPartitionPath.toUri().getRawPath();
    }

    public static <T> Map<String, T> parallelizeFilesProcess(HoodieEngineContext hoodieEngineContext, FileSystem fs, int parallelism, FSUtils.SerializableFunction<Pair<String, StorageConfiguration<Configuration>>, T> pairFunction, List<String> subPaths) {
        Map result = new HashMap();
        if (subPaths.size() > 0) {
            HadoopStorageConfiguration conf = new HadoopStorageConfiguration(fs.getConf(), true);
            int actualParallelism = Math.min(subPaths.size(), parallelism);
            hoodieEngineContext.setJobStatus(FSUtils.class.getSimpleName(), "Parallel listing paths " + String.join((CharSequence)",", subPaths));
            result = hoodieEngineContext.mapToPair(subPaths, (SerializablePairFunction & Serializable)subPath -> new ImmutablePair(subPath, pairFunction.apply((Object)new ImmutablePair(subPath, (Object)conf))), Integer.valueOf(actualParallelism));
        }
        return result;
    }

    public static List<FileStatus> getFileStatusAtLevel(HoodieEngineContext hoodieEngineContext, FileSystem fs, Path rootPath, int expectLevel, int parallelism) {
        List<String> levelPaths = new ArrayList<String>();
        List<Object> result = new ArrayList<FileStatus>();
        levelPaths.add(rootPath.toString());
        for (int i = 0; i <= expectLevel; ++i) {
            result = HadoopFSUtils.parallelizeFilesProcess(hoodieEngineContext, fs, parallelism, (FSUtils.SerializableFunction & Serializable)pairOfSubPathAndConf -> {
                Path path = new Path((String)pairOfSubPathAndConf.getKey());
                try {
                    FileSystem fileSystem = path.getFileSystem((Configuration)((StorageConfiguration)pairOfSubPathAndConf.getValue()).unwrap());
                    return Arrays.stream(fileSystem.listStatus(path)).collect(Collectors.toList());
                }
                catch (IOException e) {
                    throw new HoodieIOException("Failed to list " + path, e);
                }
            }, levelPaths).values().stream().flatMap(list -> list.stream()).collect(Collectors.toList());
            if (i >= expectLevel) continue;
            levelPaths = result.stream().filter(FileStatus::isDirectory).map(fileStatus -> fileStatus.getPath().toString()).collect(Collectors.toList());
        }
        return result;
    }

    public static Map<String, Boolean> deleteFilesParallelize(HoodieTableMetaClient metaClient, List<String> paths, HoodieEngineContext context, int parallelism, boolean ignoreFailed) {
        return HadoopFSUtils.parallelizeFilesProcess(context, (FileSystem)metaClient.getStorage().getFileSystem(), parallelism, (FSUtils.SerializableFunction & Serializable)pairOfSubPathAndConf -> {
            Path file = new Path((String)pairOfSubPathAndConf.getKey());
            try {
                FileSystem fs = (FileSystem)metaClient.getStorage().getFileSystem();
                if (fs.exists(file)) {
                    return fs.delete(file, false);
                }
                return true;
            }
            catch (IOException e) {
                if (!ignoreFailed) {
                    throw new HoodieIOException("Failed to delete : " + file, e);
                }
                LOG.warn("Ignore failed deleting : " + file);
                return true;
            }
        }, paths);
    }
}

