/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.client;

import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.ClientScanner;
import io.hops.hudi.org.apache.hadoop.hbase.client.ClusterConnection;
import io.hops.hudi.org.apache.hadoop.hbase.client.ConnectionUtils;
import io.hops.hudi.org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import io.hops.hudi.org.apache.hadoop.hbase.client.Scan;
import io.hops.hudi.org.apache.hadoop.hbase.client.ScannerCallable;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ClientSimpleScanner
extends ClientScanner {
    public ClientSimpleScanner(Configuration configuration, Scan scan, TableName name, ClusterConnection connection, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcControllerFactory, ExecutorService pool, int replicaCallTimeoutMicroSecondScan) throws IOException {
        super(configuration, scan, name, connection, rpcCallerFactory, rpcControllerFactory, pool, replicaCallTimeoutMicroSecondScan);
    }

    @Override
    protected boolean setNewStartKey() {
        if (ConnectionUtils.noMoreResultsForScan(this.scan, this.currentRegion)) {
            return false;
        }
        this.scan.withStartRow(this.currentRegion.getEndKey(), true);
        return true;
    }

    @Override
    protected ScannerCallable createScannerCallable() {
        if (!this.scan.includeStartRow() && !ConnectionUtils.isEmptyStartRow(this.scan.getStartRow())) {
            this.scan.withStartRow(ConnectionUtils.createClosestRowAfter(this.scan.getStartRow()), true);
        }
        return new ScannerCallable(this.getConnection(), this.getTable(), this.scan, this.scanMetrics, this.rpcControllerFactory, this.getScanReplicaId());
    }
}

