/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.client;

import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.ClusterConnection;
import io.hops.hudi.org.apache.hadoop.hbase.client.Connection;
import io.hops.hudi.org.apache.hadoop.hbase.client.ConnectionUtils;
import io.hops.hudi.org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfoBuilder;
import io.hops.hudi.org.apache.hadoop.hbase.client.RetryingCallable;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.HBaseRpcController;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import java.io.Closeable;
import java.io.IOException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class MasterCallable<V>
implements RetryingCallable<V>,
Closeable {
    protected final ClusterConnection connection;
    protected MasterKeepAliveConnection master;
    private final HBaseRpcController rpcController;

    MasterCallable(Connection connection, RpcControllerFactory rpcConnectionFactory) {
        this.connection = (ClusterConnection)connection;
        this.rpcController = rpcConnectionFactory.newController();
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        this.master = this.connection.getMaster();
    }

    @Override
    public void close() throws IOException {
        if (this.master != null) {
            this.master.close();
            this.master = null;
        }
    }

    @Override
    public void throwable(Throwable t, boolean retrying) {
    }

    @Override
    public String getExceptionMessageAdditionalDetail() {
        return "";
    }

    @Override
    public long sleep(long pause, int tries) {
        return ConnectionUtils.getPauseTime(pause, tries);
    }

    @Override
    public V call(int callTimeout) throws IOException {
        try {
            if (this.rpcController != null) {
                this.rpcController.reset();
                this.rpcController.setCallTimeout(callTimeout);
            }
            return this.rpcCall();
        }
        catch (Exception e) {
            throw ProtobufUtil.handleRemoteException(e);
        }
    }

    protected abstract V rpcCall() throws Exception;

    HBaseRpcController getRpcController() {
        return this.rpcController;
    }

    void setPriority(int priority) {
        if (this.rpcController != null) {
            this.rpcController.setPriority(priority);
        }
    }

    void setPriority(TableName tableName) {
        if (this.rpcController != null) {
            this.rpcController.setPriority(tableName);
        }
    }

    void setPriority(byte[] regionName) {
        if (MasterCallable.isMetaRegion(regionName)) {
            this.setPriority(TableName.META_TABLE_NAME);
        }
    }

    private static boolean isMetaRegion(byte[] regionName) {
        return Bytes.equals(regionName, RegionInfoBuilder.FIRST_META_REGIONINFO.getRegionName()) || Bytes.equals(regionName, RegionInfoBuilder.FIRST_META_REGIONINFO.getEncodedNameAsBytes());
    }
}

