/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.client;

import io.hops.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

class RetryingTimeTracker {
    private long globalStartTime = -1L;

    RetryingTimeTracker() {
    }

    public RetryingTimeTracker start() {
        if (this.globalStartTime < 0L) {
            this.globalStartTime = EnvironmentEdgeManager.currentTime();
        }
        return this;
    }

    public int getRemainingTime(int callTimeout) {
        if (callTimeout <= 0) {
            return 0;
        }
        if (callTimeout == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        long remaining = EnvironmentEdgeManager.currentTime() - this.globalStartTime;
        long remainingTime = (long)callTimeout - remaining;
        if (remainingTime < 1L) {
            remainingTime = 1L;
        }
        if (remainingTime > Integer.MAX_VALUE) {
            throw new RuntimeException("remainingTime=" + remainingTime + " which is > Integer.MAX_VALUE");
        }
        return (int)remainingTime;
    }

    public long getStartTime() {
        return this.globalStartTime;
    }
}

