/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.codec;

import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.codec.Codec;
import io.hops.hudi.org.apache.hadoop.hbase.codec.CodecException;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
public abstract class BaseEncoder
implements Codec.Encoder {
    protected final OutputStream out;
    protected boolean flushed = false;

    public BaseEncoder(OutputStream out) {
        this.out = out;
    }

    protected OutputStream getOuputStream() {
        return this.out;
    }

    @Override
    public abstract void write(Cell var1) throws IOException;

    protected void checkFlushed() throws CodecException {
        if (this.flushed) {
            throw new CodecException("Flushed; done");
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.flushed) {
            return;
        }
        this.flushed = true;
        this.out.flush();
    }
}

