/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.coordination;

import io.hops.hudi.org.apache.hadoop.hbase.ServerName;
import io.hops.hudi.org.apache.hadoop.hbase.SplitLogCounters;
import io.hops.hudi.org.apache.hadoop.hbase.SplitLogTask;
import io.hops.hudi.org.apache.hadoop.hbase.coordination.SplitLogWorkerCoordination;
import io.hops.hudi.org.apache.hadoop.hbase.exceptions.DeserializationException;
import io.hops.hudi.org.apache.hadoop.hbase.log.HBaseMarkers;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.RegionServerServices;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.SplitLogWorker;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.handler.WALSplitterHandler;
import io.hops.hudi.org.apache.hadoop.hbase.util.CancelableProgressable;
import io.hops.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import io.hops.hudi.org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import io.hops.hudi.org.apache.hadoop.hbase.zookeeper.ZKListener;
import io.hops.hudi.org.apache.hadoop.hbase.zookeeper.ZKMetadata;
import io.hops.hudi.org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import io.hops.hudi.org.apache.hadoop.hbase.zookeeper.ZKUtil;
import io.hops.hudi.org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import io.hops.hudi.org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ZkSplitLogWorkerCoordination
extends ZKListener
implements SplitLogWorkerCoordination {
    private static final Logger LOG = LoggerFactory.getLogger(ZkSplitLogWorkerCoordination.class);
    private static final int checkInterval = 5000;
    private static final int FAILED_TO_OWN_TASK = -1;
    private SplitLogWorker worker;
    private SplitLogWorker.TaskExecutor splitTaskExecutor;
    private final AtomicInteger taskReadySeq = new AtomicInteger(0);
    private volatile String currentTask = null;
    private int currentVersion;
    private volatile boolean shouldStop = false;
    private final Object grabTaskLock = new Object();
    private boolean workerInGrabTask = false;
    private int reportPeriod;
    private RegionServerServices server = null;
    protected final AtomicInteger tasksInProgress = new AtomicInteger(0);
    private int maxConcurrentTasks = 0;
    private final ServerName serverName;

    public ZkSplitLogWorkerCoordination(ServerName serverName, ZKWatcher watcher) {
        super(watcher);
        this.serverName = serverName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeChildrenChanged(String path) {
        if (path.equals(this.watcher.getZNodePaths().splitLogZNode)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("tasks arrived or departed on " + path);
            }
            AtomicInteger atomicInteger = this.taskReadySeq;
            synchronized (atomicInteger) {
                this.taskReadySeq.incrementAndGet();
                this.taskReadySeq.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeDataChanged(String path) {
        Object object = this.grabTaskLock;
        synchronized (object) {
            String taskpath;
            if (this.workerInGrabTask && (taskpath = this.currentTask) != null && taskpath.equals(path)) {
                this.getDataSetWatchAsync();
            }
        }
    }

    @Override
    public void init(RegionServerServices server, Configuration conf, SplitLogWorker.TaskExecutor splitExecutor, SplitLogWorker worker) {
        this.server = server;
        this.worker = worker;
        this.splitTaskExecutor = splitExecutor;
        this.maxConcurrentTasks = conf.getInt("hbase.regionserver.wal.max.splitters", 2);
        this.reportPeriod = conf.getInt("hbase.splitlog.report.period", conf.getInt("hbase.splitlog.manager.timeout", 120000) / 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getDataSetWatchFailure(String path) {
        Object object = this.grabTaskLock;
        synchronized (object) {
            String taskpath;
            if (this.workerInGrabTask && (taskpath = this.currentTask) != null && taskpath.equals(path)) {
                LOG.info("retrying data watch on " + path);
                SplitLogCounters.tot_wkr_get_data_retry.increment();
                this.getDataSetWatchAsync();
            }
        }
    }

    public void getDataSetWatchAsync() {
        this.watcher.getRecoverableZooKeeper().getZooKeeper().getData(this.currentTask, (Watcher)this.watcher, (AsyncCallback.DataCallback)new GetDataAsyncCallback(), null);
        SplitLogCounters.tot_wkr_get_data_queued.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getDataSetWatchSuccess(String path, byte[] data) {
        SplitLogTask slt;
        try {
            slt = SplitLogTask.parseFrom(data);
        }
        catch (DeserializationException e) {
            LOG.warn("Failed parse", (Throwable)e);
            return;
        }
        Object object = this.grabTaskLock;
        synchronized (object) {
            String taskpath;
            if (this.workerInGrabTask && (taskpath = this.currentTask) != null && taskpath.equals(path) && !slt.isOwned(this.serverName) && !slt.isDone(this.serverName) && !slt.isErr(this.serverName) && !slt.isResigned(this.serverName)) {
                LOG.info("task " + taskpath + " preempted from " + this.serverName + ", current task state and owner=" + slt.toString());
                this.worker.stopTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean grabTask(String path) {
        Stat stat = new Stat();
        Object object = this.grabTaskLock;
        synchronized (object) {
            this.currentTask = path;
            this.workerInGrabTask = true;
            if (Thread.interrupted()) {
                return false;
            }
        }
        try {
            SplitLogTask slt;
            byte[] data;
            block46: {
                data = ZKUtil.getDataNoWatch((ZKWatcher)this.watcher, (String)path, (Stat)stat);
                if (data == null) {
                    SplitLogCounters.tot_wkr_failed_to_grab_task_no_data.increment();
                    boolean bl = false;
                    return bl;
                }
                break block46;
                catch (KeeperException e) {
                    LOG.warn("Failed to get data for znode " + path, (Throwable)e);
                    SplitLogCounters.tot_wkr_failed_to_grab_task_exception.increment();
                    boolean bl = false;
                    return bl;
                }
            }
            try {
                slt = SplitLogTask.parseFrom(data);
            }
            catch (DeserializationException e) {
                LOG.warn("Failed parse data for znode " + path, (Throwable)e);
                SplitLogCounters.tot_wkr_failed_to_grab_task_exception.increment();
                boolean bl = false;
                Object object2 = this.grabTaskLock;
                synchronized (object2) {
                    this.workerInGrabTask = false;
                    Thread.interrupted();
                }
                return bl;
            }
            if (!slt.isUnassigned()) {
                SplitLogCounters.tot_wkr_failed_to_grab_task_owned.increment();
                boolean e = false;
                return e;
            }
            this.currentVersion = ZkSplitLogWorkerCoordination.attemptToOwnTask(true, this.watcher, this.server.getServerName(), path, stat.getVersion());
            if (this.currentVersion < 0) {
                SplitLogCounters.tot_wkr_failed_to_grab_task_lost_race.increment();
                boolean e = false;
                return e;
            }
            if (ZKSplitLog.isRescanNode((ZKWatcher)this.watcher, (String)this.currentTask)) {
                ZkSplitTaskDetails splitTaskDetails = new ZkSplitTaskDetails();
                splitTaskDetails.setTaskNode(this.currentTask);
                splitTaskDetails.setCurTaskZKVersion(new MutableInt(this.currentVersion));
                this.endTask(new SplitLogTask.Done(this.server.getServerName()), SplitLogCounters.tot_wkr_task_acquired_rescan, splitTaskDetails);
                boolean bl = false;
                return bl;
            }
            LOG.info("worker " + this.server.getServerName() + " acquired task " + path);
            SplitLogCounters.tot_wkr_task_acquired.increment();
            this.getDataSetWatchAsync();
            this.submitTask(path, this.currentVersion, this.reportPeriod);
            try {
                int sleepTime = RandomUtils.nextInt((int)0, (int)500) + 500;
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while yielding for other region servers", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Object object3 = this.grabTaskLock;
            synchronized (object3) {
                this.workerInGrabTask = false;
                Thread.interrupted();
            }
        }
    }

    void submitTask(final String curTask, int curTaskZKVersion, final int reportPeriod) {
        final MutableInt zkVersion = new MutableInt(curTaskZKVersion);
        CancelableProgressable reporter = new CancelableProgressable(){
            private long last_report_at = 0L;

            public boolean progress() {
                long t = EnvironmentEdgeManager.currentTime();
                if (t - this.last_report_at > (long)reportPeriod) {
                    this.last_report_at = t;
                    int latestZKVersion = ZkSplitLogWorkerCoordination.attemptToOwnTask(false, ZkSplitLogWorkerCoordination.this.watcher, ZkSplitLogWorkerCoordination.this.server.getServerName(), curTask, zkVersion.intValue());
                    if (latestZKVersion < 0) {
                        LOG.warn("Failed to heartbeat the task" + curTask);
                        return false;
                    }
                    zkVersion.setValue(latestZKVersion);
                }
                return true;
            }
        };
        ZkSplitTaskDetails splitTaskDetails = new ZkSplitTaskDetails();
        splitTaskDetails.setTaskNode(curTask);
        splitTaskDetails.setCurTaskZKVersion(zkVersion);
        WALSplitterHandler hsh = new WALSplitterHandler(this.server, this, splitTaskDetails, reporter, this.tasksInProgress, this.splitTaskExecutor);
        this.server.getExecutorService().submit(hsh);
    }

    private boolean areSplittersAvailable() {
        return this.maxConcurrentTasks - this.tasksInProgress.get() > 0;
    }

    protected static int attemptToOwnTask(boolean isFirstTime, ZKWatcher zkw, ServerName server, String task, int taskZKVersion) {
        int latestZKVersion = -1;
        try {
            SplitLogTask.Owned slt = new SplitLogTask.Owned(server);
            Stat stat = zkw.getRecoverableZooKeeper().setData(task, slt.toByteArray(), taskZKVersion);
            if (stat == null) {
                LOG.warn("zk.setData() returned null for path " + task);
                SplitLogCounters.tot_wkr_task_heartbeat_failed.increment();
                return -1;
            }
            latestZKVersion = stat.getVersion();
            SplitLogCounters.tot_wkr_task_heartbeat.increment();
            return latestZKVersion;
        }
        catch (KeeperException e) {
            if (!isFirstTime) {
                if (e.code().equals((Object)KeeperException.Code.NONODE)) {
                    LOG.warn("NONODE failed to assert ownership for " + task, (Throwable)e);
                } else if (e.code().equals((Object)KeeperException.Code.BADVERSION)) {
                    LOG.warn("BADVERSION failed to assert ownership for " + task, (Throwable)e);
                } else {
                    LOG.warn("failed to assert ownership for " + task, (Throwable)e);
                }
            }
        }
        catch (InterruptedException e1) {
            LOG.warn("Interrupted while trying to assert ownership of " + task + " " + StringUtils.stringifyException((Throwable)e1));
            Thread.currentThread().interrupt();
        }
        SplitLogCounters.tot_wkr_task_heartbeat_failed.increment();
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskLoop() throws InterruptedException {
        while (!this.shouldStop) {
            int seq_start = this.taskReadySeq.get();
            List<String> paths = this.getTaskList();
            if (paths == null) {
                LOG.warn("Could not get tasks, did someone remove " + this.watcher.getZNodePaths().splitLogZNode + " ... worker thread exiting.");
                return;
            }
            Collections.shuffle(paths);
            int offset = 0;
            for (int i = 0; i < paths.size(); ++i) {
                if (!AbstractFSWALProvider.isMetaFile(paths.get(i))) continue;
                offset = i;
                break;
            }
            int numTasks = paths.size();
            boolean taskGrabbed = false;
            for (int i = 0; i < numTasks; ++i) {
                while (!this.shouldStop) {
                    if (this.areSplittersAvailable()) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Current region server " + this.server.getServerName() + " is ready to take more tasks, will get task list and try grab tasks again.");
                        }
                        int idx = (i + offset) % paths.size();
                        taskGrabbed |= this.grabTask(ZNodePaths.joinZNode(this.watcher.getZNodePaths().splitLogZNode, paths.get(idx)));
                        break;
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Current region server " + this.server.getServerName() + " has " + this.tasksInProgress.get() + " tasks in progress and can't take more.");
                    }
                    Thread.sleep(100L);
                }
                if (!this.shouldStop) continue;
                return;
            }
            if (!taskGrabbed && !this.shouldStop) {
                Thread.sleep(1000L);
            }
            SplitLogCounters.tot_wkr_task_grabing.increment();
            AtomicInteger atomicInteger = this.taskReadySeq;
            synchronized (atomicInteger) {
                while (seq_start == this.taskReadySeq.get()) {
                    this.taskReadySeq.wait(5000L);
                }
            }
        }
    }

    private List<String> getTaskList() throws InterruptedException {
        List childrenPaths = null;
        long sleepTime = 1000L;
        while (!this.shouldStop) {
            try {
                childrenPaths = ZKUtil.listChildrenAndWatchForNewChildren((ZKWatcher)this.watcher, (String)this.watcher.getZNodePaths().splitLogZNode);
                if (childrenPaths != null) {
                    return childrenPaths;
                }
            }
            catch (KeeperException e) {
                LOG.warn("Could not get children of znode " + this.watcher.getZNodePaths().splitLogZNode, (Throwable)e);
            }
            LOG.debug("Retry listChildren of znode " + this.watcher.getZNodePaths().splitLogZNode + " after sleep for " + sleepTime + "ms!");
            Thread.sleep(sleepTime);
        }
        return childrenPaths;
    }

    @Override
    public void markCorrupted(Path rootDir, String name, FileSystem fs) {
        ZKSplitLog.markCorrupted((Path)rootDir, (String)name, (FileSystem)fs);
    }

    @Override
    public boolean isReady() throws InterruptedException {
        int result = -1;
        try {
            result = ZKUtil.checkExists((ZKWatcher)this.watcher, (String)this.watcher.getZNodePaths().splitLogZNode);
        }
        catch (KeeperException e) {
            LOG.warn("Exception when checking for " + this.watcher.getZNodePaths().splitLogZNode + " ... retrying", (Throwable)e);
        }
        if (result == -1) {
            LOG.info(this.watcher.getZNodePaths().splitLogZNode + " znode does not exist, waiting for master to create");
            Thread.sleep(1000L);
        }
        return result != -1;
    }

    @Override
    public int getTaskReadySeq() {
        return this.taskReadySeq.get();
    }

    @Override
    public void registerListener() {
        this.watcher.registerListener((ZKListener)this);
    }

    @Override
    public void removeListener() {
        this.watcher.unregisterListener((ZKListener)this);
    }

    @Override
    public void stopProcessingTasks() {
        this.shouldStop = true;
    }

    @Override
    public boolean isStop() {
        return this.shouldStop;
    }

    @Override
    public void endTask(SplitLogTask slt, LongAdder ctr, SplitLogWorkerCoordination.SplitTaskDetails details) {
        ZkSplitTaskDetails zkDetails = (ZkSplitTaskDetails)details;
        String task = zkDetails.getTaskNode();
        int taskZKVersion = zkDetails.getCurTaskZKVersion().intValue();
        try {
            if (ZKUtil.setData((ZKWatcher)this.watcher, (String)task, (byte[])slt.toByteArray(), (int)taskZKVersion)) {
                LOG.info("successfully transitioned task " + task + " to final state " + slt);
                ctr.increment();
                return;
            }
            LOG.warn("failed to transistion task " + task + " to end state " + slt + " because of version mismatch ");
        }
        catch (KeeperException.BadVersionException bve) {
            LOG.warn("transisition task " + task + " to " + slt + " failed because of version mismatch", (Throwable)bve);
        }
        catch (KeeperException.NoNodeException e) {
            LOG.error(HBaseMarkers.FATAL, "logic error - end task " + task + " " + slt + " failed because task doesn't exist", (Throwable)e);
        }
        catch (KeeperException e) {
            LOG.warn("failed to end task, " + task + " " + slt, (Throwable)e);
        }
        SplitLogCounters.tot_wkr_final_transition_failed.increment();
    }

    public static class ZkSplitTaskDetails
    implements SplitLogWorkerCoordination.SplitTaskDetails {
        private String taskNode;
        private MutableInt curTaskZKVersion;

        public ZkSplitTaskDetails() {
        }

        public ZkSplitTaskDetails(String taskNode, MutableInt curTaskZKVersion) {
            this.taskNode = taskNode;
            this.curTaskZKVersion = curTaskZKVersion;
        }

        public String getTaskNode() {
            return this.taskNode;
        }

        public void setTaskNode(String taskNode) {
            this.taskNode = taskNode;
        }

        public MutableInt getCurTaskZKVersion() {
            return this.curTaskZKVersion;
        }

        public void setCurTaskZKVersion(MutableInt curTaskZKVersion) {
            this.curTaskZKVersion = curTaskZKVersion;
        }

        @Override
        public String getWALFile() {
            return ZKSplitLog.getFileName((String)this.taskNode);
        }
    }

    class GetDataAsyncCallback
    implements AsyncCallback.DataCallback {
        private final Logger LOG = LoggerFactory.getLogger(GetDataAsyncCallback.class);

        GetDataAsyncCallback() {
        }

        public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            SplitLogCounters.tot_wkr_get_data_result.increment();
            if (rc != 0) {
                this.LOG.warn("getdata rc = " + KeeperException.Code.get((int)rc) + " " + path);
                ZkSplitLogWorkerCoordination.this.getDataSetWatchFailure(path);
                return;
            }
            data = ZKMetadata.removeMetaData(data);
            ZkSplitLogWorkerCoordination.this.getDataSetWatchSuccess(path, data);
        }
    }
}

