/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.generated.master;

import io.hops.hudi.org.apache.hadoop.hbase.HRegionInfo;
import io.hops.hudi.org.apache.hadoop.hbase.HRegionLocation;
import io.hops.hudi.org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import io.hops.hudi.org.apache.hadoop.hbase.RegionMetrics;
import io.hops.hudi.org.apache.hadoop.hbase.RegionMetricsBuilder;
import io.hops.hudi.org.apache.hadoop.hbase.ServerMetrics;
import io.hops.hudi.org.apache.hadoop.hbase.ServerName;
import io.hops.hudi.org.apache.hadoop.hbase.Size;
import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.TableNotFoundException;
import io.hops.hudi.org.apache.hadoop.hbase.client.AsyncAdmin;
import io.hops.hudi.org.apache.hadoop.hbase.client.AsyncConnection;
import io.hops.hudi.org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import io.hops.hudi.org.apache.hadoop.hbase.client.CompactionState;
import io.hops.hudi.org.apache.hadoop.hbase.client.ConnectionFactory;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfoBuilder;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionLocator;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionReplicaUtil;
import io.hops.hudi.org.apache.hadoop.hbase.client.Table;
import io.hops.hudi.org.apache.hadoop.hbase.client.TableState;
import io.hops.hudi.org.apache.hadoop.hbase.http.InfoServer;
import io.hops.hudi.org.apache.hadoop.hbase.master.HMaster;
import io.hops.hudi.org.apache.hadoop.hbase.master.RegionState;
import io.hops.hudi.org.apache.hadoop.hbase.master.assignment.RegionStates;
import io.hops.hudi.org.apache.hadoop.hbase.master.webapp.MetaBrowser;
import io.hops.hudi.org.apache.hadoop.hbase.master.webapp.RegionReplicaInfo;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.ThrottleSettings;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import io.hops.hudi.org.apache.hadoop.hbase.util.FSUtils;
import io.hops.hudi.org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import io.hops.hudi.org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.runtime.PageContextImpl;
import org.glassfish.jsp.api.ResourceInjector;

public final class table_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static List<String> _jspx_dependants;
    private ResourceInjector _jspx_resourceInjector;

    private static RegionMetrics getEmptyRegionMetrics(RegionInfo regionInfo) {
        return RegionMetricsBuilder.toRegionMetrics(ClusterStatusProtos.RegionLoad.newBuilder().setRegionSpecifier(HBaseProtos.RegionSpecifier.newBuilder().setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME).setValue(ByteString.copyFrom(regionInfo.getRegionName())).build()).build());
    }

    private static String buildRegionServerLink(ServerName serverName, int rsInfoPort, RegionInfo regionInfo, RegionState.State regionState) {
        if (serverName == null || regionInfo == null) {
            return null;
        }
        if (regionState != RegionState.State.OPEN) {
            return serverName.getServerName();
        }
        String socketAddress = serverName.getHostname() + ":" + rsInfoPort;
        String URI2 = "//" + socketAddress + "/region.jsp?name=" + regionInfo.getEncodedName();
        return "<a href=\"" + URI2 + "\">" + serverName.getServerName() + "</a>";
    }

    public List<String> getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block147: {
            PageContext pageContext = null;
            HttpSession session = null;
            ServletContext application = null;
            ServletConfig config = null;
            JspWriter out = null;
            table_jsp page = this;
            JspWriter _jspx_out = null;
            PageContext _jspx_page_context = null;
            try {
                block144: {
                    response.setContentType("text/html;charset=UTF-8");
                    _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
                    application = pageContext.getServletContext();
                    config = pageContext.getServletConfig();
                    session = pageContext.getSession();
                    _jspx_out = out = pageContext.getOut();
                    this._jspx_resourceInjector = (ResourceInjector)application.getAttribute("com.sun.appserv.jsp.resource.injector");
                    out.write("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
                    out.write(10);
                    String ZEROMB = "0 MB";
                    HMaster master = (HMaster)this.getServletContext().getAttribute("master");
                    Configuration conf = master.getConfiguration();
                    String fqtn = request.getParameter("name");
                    String escaped_fqtn = StringEscapeUtils.escapeHtml4((String)fqtn);
                    boolean withReplica = false;
                    boolean showFragmentation = conf.getBoolean("hbase.master.ui.fragmentation.enabled", false);
                    boolean readOnly = !InfoServer.canUserModifyUI((HttpServletRequest)request, (ServletContext)this.getServletContext(), (Configuration)conf);
                    int numMetaReplicas = master.getTableDescriptors().get(TableName.META_TABLE_NAME).getRegionReplication();
                    Map<String, Integer> frags = null;
                    if (showFragmentation) {
                        frags = FSUtils.getTableFragmentation(master);
                    }
                    boolean quotasEnabled = conf.getBoolean("hbase.quota.enabled", false);
                    String action = request.getParameter("action");
                    String key = request.getParameter("key");
                    String left = request.getParameter("left");
                    String right = request.getParameter("right");
                    long totalStoreFileSizeMB = 0L;
                    String numRegionsParam = request.getParameter("numRegions");
                    int numRegionsToRender = 10000;
                    if (numRegionsParam != null) {
                        if (numRegionsParam.equals("all")) {
                            numRegionsToRender = -1;
                        } else {
                            try {
                                numRegionsToRender = Integer.parseInt(numRegionsParam);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    int numRegions = 0;
                    String pageTitle = !readOnly && action != null ? "HBase Master: " + StringEscapeUtils.escapeHtml4((String)master.getServerName().toString()) : "Table: " + escaped_fqtn;
                    pageContext.setAttribute("pageTitle", (Object)pageTitle);
                    AsyncConnection connection = ConnectionFactory.createAsyncConnection(master.getConfiguration()).get();
                    AsyncAdmin admin = connection.getAdminBuilder().setOperationTimeout(5L, TimeUnit.SECONDS).build();
                    MetaBrowser metaBrowser = new MetaBrowser(connection, request);
                    out.write(10);
                    out.write(10);
                    JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)("header.jsp?" + JspRuntimeLibrary.URLEncode((String)"pageTitle", (String)request.getCharacterEncoding()) + "=" + JspRuntimeLibrary.URLEncode((String)((String)PageContextImpl.evaluateExpression((String)"${pageTitle}", String.class, (PageContext)_jspx_page_context, null)), (String)request.getCharacterEncoding())), (JspWriter)out, (boolean)false);
                    out.write(10);
                    out.write(10);
                    if (fqtn != null && master.isInitialized()) {
                        try {
                            Table table = master.getConnection().getTable(TableName.valueOf(fqtn));
                            if (table.getTableDescriptor().getRegionReplication() > 1) {
                                withReplica = true;
                            }
                            if (!readOnly && action != null) {
                                out.write("\n<div class=\"container-fluid content\">\n  <div class=\"row inner_header\">\n    <div class=\"page-header\">\n      <h1>Table action request accepted</h1>\n    </div>\n  </div>\n  <p><hr><p>\n    ");
                                if (action.equals("split")) {
                                    if (key != null && key.length() > 0) {
                                        admin.split(TableName.valueOf(fqtn), Bytes.toBytes(key));
                                    } else {
                                        admin.split(TableName.valueOf(fqtn));
                                    }
                                    out.write(" Split request accepted. ");
                                } else if (action.equals("compact")) {
                                    if (key != null && key.length() > 0) {
                                        List<RegionInfo> regions = admin.getRegions(TableName.valueOf(fqtn)).get();
                                        byte[] row = Bytes.toBytes(key);
                                        for (RegionInfo region : regions) {
                                            if (!region.containsRow(row)) continue;
                                            admin.compactRegion(region.getRegionName());
                                        }
                                    } else {
                                        admin.compact(TableName.valueOf(fqtn));
                                    }
                                    out.write(" Compact request accepted. ");
                                } else if (action.equals("merge")) {
                                    if (left != null && left.length() > 0 && right != null && right.length() > 0) {
                                        admin.mergeRegions(Bytes.toBytesBinary(left), Bytes.toBytesBinary(right), false);
                                    }
                                    out.write(" Merge request accepted. ");
                                }
                                out.write("\n  ");
                                JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)"redirect.jsp", (JspWriter)out, (boolean)false);
                                out.write("\n</div>\n");
                                break block144;
                            }
                            out.write("\n<div class=\"container-fluid content\">\n  <div class=\"row inner_header\">\n    <div class=\"page-header\">\n      <h1>Table <small>");
                            out.print(escaped_fqtn);
                            out.write("</small></h1>\n    </div>\n  </div>\n  <div class=\"row\">\n    ");
                            if (fqtn.equals(TableName.META_TABLE_NAME.getNameAsString())) {
                                void var45_103;
                                boolean metaScanHasMore;
                                Object map32;
                                RegionMetrics load;
                                String hostAndPort;
                                ServerName metaLocation;
                                RegionInfo meta;
                                int j;
                                out.write("\n    <h2>Table Regions</h2>\n    <div class=\"tabbable\">\n      <ul class=\"nav nav-pills\">\n        <li class=\"active\">\n          <a href=\"#metaTab_baseStats\" data-toggle=\"tab\">Base Stats</a>\n        </li>\n        <li class=\"\">\n          <a href=\"#metaTab_localityStats\" data-toggle=\"tab\">Localities</a>\n        </li>\n        <li class=\"\">\n          <a href=\"#metaTab_compactStats\" data-toggle=\"tab\">Compactions</a>\n        </li>\n      </ul>\n      <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"metaTab_baseStats\">\n          <table id=\"tableRegionTable\" class=\"tablesorter table table-striped\">\n            <thead>\n            <tr>\n              <th>Name</th>\n              <th>Region Server</th>\n              <th>ReadRequests</th>\n              <th>WriteRequests</th>\n              <th>StorefileSize</th>\n              <th>Num.Storefiles</th>\n              <th>MemSize</th>\n              <th>Start Key</th>\n              <th>End Key</th>\n              ");
                                if (withReplica) {
                                    out.write("\n              <th>ReplicaID</th>\n              ");
                                }
                                out.write("\n            </tr>\n            </thead>\n            <tbody>\n            ");
                                for (j = 0; j < numMetaReplicas; ++j) {
                                    meta = RegionReplicaUtil.getRegionInfoForReplica(RegionInfoBuilder.FIRST_META_REGIONINFO, j);
                                    metaLocation = null;
                                    try {
                                        metaLocation = MetaTableLocator.waitMetaRegionLocation((ZKWatcher)master.getZooKeeper(), (int)j, (long)1L);
                                    }
                                    catch (NotAllMetaRegionsOnlineException region) {
                                        // empty catch block
                                    }
                                    for (int i2 = 0; i2 < 1; ++i2) {
                                        void var45_89;
                                        hostAndPort = "";
                                        String readReq = "N/A";
                                        String writeReq = "N/A";
                                        String fileSize = "0 MB";
                                        String fileCount = "N/A";
                                        String string = "0 MB";
                                        if (metaLocation != null) {
                                            Map<byte[], RegionMetrics> map2;
                                            ServerMetrics serverMetrics = master.getServerManager().getLoad(metaLocation);
                                            hostAndPort = URLEncoder.encode(metaLocation.getHostname()) + ":" + master.getRegionServerInfoPort(metaLocation);
                                            if (serverMetrics != null && (map2 = serverMetrics.getRegionMetrics()).containsKey(meta.getRegionName())) {
                                                load = map2.get(meta.getRegionName());
                                                readReq = String.format("%,1d", load.getReadRequestCount());
                                                writeReq = String.format("%,1d", load.getWriteRequestCount());
                                                double rSize = load.getStoreFileSize().get(Size.Unit.BYTE);
                                                if (rSize > 0.0) {
                                                    fileSize = StringUtils.byteDesc((long)((long)rSize));
                                                }
                                                fileCount = String.format("%,1d", load.getStoreFileCount());
                                                double mSize = load.getMemStoreSize().get(Size.Unit.BYTE);
                                                if (mSize > 0.0) {
                                                    String string2 = StringUtils.byteDesc((long)((long)mSize));
                                                }
                                            }
                                        }
                                        out.write("\n            <tr>\n              <td>");
                                        out.print(StringEscapeUtils.escapeXml((String)meta.getRegionNameAsString()));
                                        out.write("</td>\n              <td><a href=\"http://");
                                        out.print(hostAndPort);
                                        out.write("/rs-status\">");
                                        out.print(StringEscapeUtils.escapeHtml4((String)hostAndPort));
                                        out.write("</a></td>\n              <td>");
                                        out.print(readReq);
                                        out.write("</td>\n              <td>");
                                        out.print(writeReq);
                                        out.write("</td>\n              <td>");
                                        out.print(fileSize);
                                        out.write("</td>\n              <td>");
                                        out.print(fileCount);
                                        out.write("</td>\n              <td>");
                                        out.print((String)var45_89);
                                        out.write("</td>\n              <td>");
                                        out.print(StringEscapeUtils.escapeXml((String)Bytes.toString(meta.getStartKey())));
                                        out.write("</td>\n              <td>");
                                        out.print(StringEscapeUtils.escapeXml((String)Bytes.toString(meta.getEndKey())));
                                        out.write("</td>\n              ");
                                        if (withReplica) {
                                            out.write("\n              <td>");
                                            out.print(meta.getReplicaId());
                                            out.write("</td>\n              ");
                                        }
                                        out.write("\n            </tr>\n            ");
                                    }
                                    out.write("\n            ");
                                }
                                out.write("\n            </tbody>\n          </table>\n        </div>\n        <div class=\"tab-pane\" id=\"metaTab_localityStats\">\n           <table id=\"tableRegionTable\" class=\"tablesorter table table-striped\">\n             <thead>\n               <tr>\n                 <th>Name</th>\n                 <th>Region Server</th>\n                 <th>Locality</th>\n                 <th>LocalityForSsd</th>\n               </tr>\n             </thead>\n             <tbody>\n             ");
                                for (j = 0; j < numMetaReplicas; ++j) {
                                    meta = RegionReplicaUtil.getRegionInfoForReplica(RegionInfoBuilder.FIRST_META_REGIONINFO, j);
                                    metaLocation = null;
                                    try {
                                        metaLocation = MetaTableLocator.waitMetaRegionLocation((ZKWatcher)master.getZooKeeper(), (int)j, (long)1L);
                                    }
                                    catch (NotAllMetaRegionsOnlineException i2) {
                                        // empty catch block
                                    }
                                    for (int i3 = 0; i3 < 1; ++i3) {
                                        hostAndPort = "";
                                        float locality = 0.0f;
                                        float localityForSsd = 0.0f;
                                        if (metaLocation != null) {
                                            ServerMetrics sl2 = master.getServerManager().getLoad(metaLocation);
                                            hostAndPort = URLEncoder.encode(metaLocation.getHostname()) + ":" + master.getRegionServerInfoPort(metaLocation);
                                            if (sl2 != null && (map32 = sl2.getRegionMetrics()).containsKey(meta.getRegionName())) {
                                                RegionMetrics regionMetrics = map32.get(meta.getRegionName());
                                                locality = regionMetrics.getDataLocality();
                                                localityForSsd = regionMetrics.getDataLocalityForSsd();
                                            }
                                        }
                                        out.write("\n               <tr>\n                 <td>");
                                        out.print(StringEscapeUtils.escapeXml((String)meta.getRegionNameAsString()));
                                        out.write("</td>\n                 <td><a href=\"http://");
                                        out.print(hostAndPort);
                                        out.write("/rs-status\">");
                                        out.print(StringEscapeUtils.escapeHtml4((String)hostAndPort));
                                        out.write("</a></td>\n                 <td>");
                                        out.print(locality);
                                        out.write("</td>\n                 <td>");
                                        out.print(localityForSsd);
                                        out.write("</td>\n               </tr>\n             ");
                                    }
                                    out.write("\n             ");
                                }
                                out.write("\n             </tbody>\n           </table>\n         </div>\n        <div class=\"tab-pane\" id=\"metaTab_compactStats\">\n          <table id=\"metaTableCompactStatsTable\" class=\"tablesorter table table-striped\">\n            <thead>\n            <tr>\n              <th>Name</th>\n              <th>Region Server</th>\n              <th>Num. Compacting Cells</th>\n              <th>Num. Compacted Cells</th>\n              <th>Remaining Cells</th>\n              <th>Compaction Progress</th>\n            </tr>\n            </thead>\n            <tbody>\n            ");
                                for (j = 0; j < numMetaReplicas; ++j) {
                                    meta = RegionReplicaUtil.getRegionInfoForReplica(RegionInfoBuilder.FIRST_META_REGIONINFO, j);
                                    metaLocation = null;
                                    try {
                                        metaLocation = MetaTableLocator.waitMetaRegionLocation((ZKWatcher)master.getZooKeeper(), (int)j, (long)1L);
                                    }
                                    catch (NotAllMetaRegionsOnlineException i3) {
                                        // empty catch block
                                    }
                                    for (int i = 0; i < 1; ++i) {
                                        void var45_97;
                                        hostAndPort = "";
                                        long compactingCells = 0L;
                                        long compactedCells = 0L;
                                        String string = "";
                                        if (metaLocation != null) {
                                            Map<byte[], RegionMetrics> map;
                                            ServerMetrics serverMetrics = master.getServerManager().getLoad(metaLocation);
                                            hostAndPort = URLEncoder.encode(metaLocation.getHostname()) + ":" + master.getRegionServerInfoPort(metaLocation);
                                            if (serverMetrics != null && (map = serverMetrics.getRegionMetrics()).containsKey(meta.getRegionName())) {
                                                load = map.get(meta.getRegionName());
                                                compactingCells = load.getCompactingCellCount();
                                                compactedCells = load.getCompactedCellCount();
                                                if (compactingCells > 0L) {
                                                    String string3 = String.format("%.2f", Float.valueOf(100.0f * ((float)compactedCells / (float)compactingCells))) + "%";
                                                }
                                            }
                                        }
                                        out.write("\n            <tr>\n              <td>");
                                        out.print(StringEscapeUtils.escapeXml((String)meta.getRegionNameAsString()));
                                        out.write("</td>\n              <td><a href=\"http://");
                                        out.print(hostAndPort);
                                        out.write("/rs-status\">");
                                        out.print(StringEscapeUtils.escapeHtml4((String)hostAndPort));
                                        out.write("</a></td>\n              <td>");
                                        out.print(String.format("%,1d", compactingCells));
                                        out.write("</td>\n              <td>");
                                        out.print(String.format("%,1d", compactedCells));
                                        out.write("</td>\n              <td>");
                                        out.print(String.format("%,1d", compactingCells - compactedCells));
                                        out.write("</td>\n              <td>");
                                        out.print((String)var45_97);
                                        out.write("</td>\n            </tr>\n            ");
                                    }
                                    out.write("\n            ");
                                }
                                out.write("\n            </tbody>\n          </table>\n        </div>\n      </div>\n    </div>\n    <h2 id=\"meta-entries\">Meta Entries</h2>\n");
                                if (!metaBrowser.getErrorMessages().isEmpty()) {
                                    for (String errorMessage : metaBrowser.getErrorMessages()) {
                                        out.write("\n    <div class=\"alert alert-warning\" role=\"alert\">\n      ");
                                        out.print(errorMessage);
                                        out.write("\n    </div>\n");
                                    }
                                }
                                String regionInfoColumnName = "info:regioninfo";
                                String serverColumnName = "info:server";
                                String startCodeColumnName = "info:serverstartcode";
                                String serverNameColumnName = "info:sn";
                                String seqNumColumnName = "info:seqnumDuringOpen";
                                out.write("\n    <div style=\"overflow-x: auto\">\n      <table class=\"table table-striped nowrap\">\n        <tr>\n          <th title=\"Region name, stored in ");
                                out.print(regionInfoColumnName);
                                out.write(" column\">RegionName</th>\n          <th title=\"The startKey of this region\">Start Key</th>\n          <th title=\"The endKey of this region\">End Key</th>\n          <th title=\"Region replica id\">Replica ID</th>\n          <th title=\"State of the region while undergoing transitions\">RegionState</th>\n          <th title=\"Server hosting this region replica, stored in ");
                                out.print(serverColumnName);
                                out.write(" column\">Server</th>\n          <th title=\"The seqNum for the region at the time the server opened this region replica, stored in ");
                                out.print(seqNumColumnName);
                                out.write("\">Sequence Number</th>\n          <th title=\"The server to which the region is transiting, stored in ");
                                out.print(serverNameColumnName);
                                out.write(" column\">Target Server</th>\n          <th title=\"The parents regions if this region is undergoing a merge\">info:merge*</th>\n          <th title=\"The daughter regions if this region is split\">info:split*</th>\n        </tr>\n");
                                byte[] lastRow = null;
                                RegionState.State[] results = metaBrowser.getResults();
                                map32 = null;
                                try {
                                    for (RegionReplicaInfo regionReplicaInfo : results) {
                                        lastRow = Optional.ofNullable(regionReplicaInfo).map(RegionReplicaInfo::getRow).orElse(null);
                                        if (regionReplicaInfo == null) {
                                            out.write("\n        <tr>\n          <td colspan=\"6\">Null result</td>\n        </tr>\n");
                                            continue;
                                        }
                                        String regionNameDisplay = regionReplicaInfo.getRegionName() != null ? Bytes.toStringBinary(regionReplicaInfo.getRegionName()) : "";
                                        String startKeyDisplay = regionReplicaInfo.getStartKey() != null ? Bytes.toStringBinary(regionReplicaInfo.getStartKey()) : "";
                                        String endKeyDisplay = regionReplicaInfo.getEndKey() != null ? Bytes.toStringBinary(regionReplicaInfo.getEndKey()) : "";
                                        String replicaIdDisplay = regionReplicaInfo.getReplicaId() != null ? regionReplicaInfo.getReplicaId().toString() : "";
                                        String regionStateDisplay = regionReplicaInfo.getRegionState() != null ? regionReplicaInfo.getRegionState().toString() : "";
                                        RegionInfo regionInfo = regionReplicaInfo.getRegionInfo();
                                        ServerName serverName = regionReplicaInfo.getServerName();
                                        RegionState.State regionState = regionReplicaInfo.getRegionState();
                                        int rsPort = master.getRegionServerInfoPort(serverName);
                                        long seqNum = regionReplicaInfo.getSeqNum();
                                        String regionSpanFormat = "<span title=info:%s>%s</span>";
                                        String targetServerName = regionReplicaInfo.getTargetServerName().toString();
                                        Map<String, RegionInfo> mergeRegions = regionReplicaInfo.getMergeRegionInfo();
                                        String mergeRegionNames = mergeRegions == null ? "" : mergeRegions.entrySet().stream().map(entry -> String.format("<span title=info:%s>%s</span>", entry.getKey(), ((RegionInfo)entry.getValue()).getRegionNameAsString())).collect(Collectors.joining("<br/>"));
                                        Map<String, RegionInfo> splitRegions = regionReplicaInfo.getSplitRegionInfo();
                                        String splitName = splitRegions == null ? "" : splitRegions.entrySet().stream().map(entry -> String.format("<span title=info:%s>%s</span>", entry.getKey(), ((RegionInfo)entry.getValue()).getRegionNameAsString())).collect(Collectors.joining("<br/>"));
                                        out.write("\n        <tr>\n          <td title=\"");
                                        out.print(regionInfoColumnName);
                                        out.write(34);
                                        out.write(62);
                                        out.print(regionNameDisplay);
                                        out.write("</td>\n          <td title=\"startKey\">");
                                        out.print(startKeyDisplay);
                                        out.write("</td>\n          <td title=\"endKey\">");
                                        out.print(endKeyDisplay);
                                        out.write("</td>\n          <td title=\"replicaId\">");
                                        out.print(replicaIdDisplay);
                                        out.write("</td>\n          <td title=\"regionState\">");
                                        out.print(regionStateDisplay);
                                        out.write("</td>\n          <td title=\"");
                                        out.print(serverColumnName + "," + startCodeColumnName);
                                        out.write(34);
                                        out.write(62);
                                        out.print(table_jsp.buildRegionServerLink(serverName, rsPort, regionInfo, regionState));
                                        out.write("</td>\n          <td title=\"");
                                        out.print(seqNumColumnName);
                                        out.write(34);
                                        out.write(62);
                                        out.print(seqNum);
                                        out.write("</td>\n          <td title=\"");
                                        out.print(serverNameColumnName);
                                        out.write(34);
                                        out.write(62);
                                        out.print(targetServerName);
                                        out.write("</td>\n          <td>");
                                        out.print(mergeRegionNames);
                                        out.write("</td>\n          <td>");
                                        out.print(splitName);
                                        out.write("</td>\n        </tr>\n");
                                    }
                                    metaScanHasMore = results.hasMoreResults();
                                }
                                catch (Throwable throwable) {
                                    map32 = throwable;
                                    throw throwable;
                                }
                                finally {
                                    if (results != null) {
                                        if (map32 != null) {
                                            try {
                                                results.close();
                                            }
                                            catch (Throwable throwable) {
                                                ((Throwable)map32).addSuppressed(throwable);
                                            }
                                        } else {
                                            results.close();
                                        }
                                    }
                                }
                                out.write("\n      </table>\n    </div>\n    <div class=\"row\">\n      <div class=\"col-md-4\">\n        <ul class=\"pagination\" style=\"margin: 20px 0\">\n          <li>\n            <a href=\"");
                                out.print(metaBrowser.buildFirstPageUrl());
                                out.write("\" aria-label=\"Previous\">\n              <span aria-hidden=\"true\">&#x21E4;</span>\n            </a>\n          </li>\n          <li");
                                out.print(metaScanHasMore ? "" : " class=\"disabled\"");
                                out.write(">\n            <a");
                                out.print(metaScanHasMore ? " href=\"" + metaBrowser.buildNextPageUrl(lastRow) + "\"" : "");
                                out.write(" aria-label=\"Next\">\n              <span aria-hidden=\"true\">&raquo;</span>\n            </a>\n          </li>\n        </ul>\n      </div>\n      <div class=\"col-md-8\">\n        <form action=\"/table.jsp\" method=\"get\" class=\"form-inline pull-right\" style=\"margin: 20px 0\">\n          <input type=\"hidden\" name=\"name\" value=\"");
                                out.print((Object)TableName.META_TABLE_NAME);
                                out.write("\" />\n          <div class=\"form-group\">\n            <label for=\"scan-limit\">Scan Limit</label>\n            <input type=\"text\" id=\"scan-limit\" name=\"");
                                out.print("scan_limit");
                                out.write("\"\n                              class=\"form-control\" placeholder=\"");
                                out.print(10);
                                out.write("\"\n                              ");
                                out.print(metaBrowser.getScanLimit() != null ? "value=\"" + metaBrowser.getScanLimit() + "\"" : "");
                                out.write("\n                              aria-describedby=\"scan-limit\" style=\"display:inline; width:auto\" />\n            <label for=\"table-name-filter\">Table</label>\n            <input type=\"text\" id=\"table-name-filter\" name=\"");
                                out.print("scan_table");
                                out.write("\"\n                              ");
                                out.print(metaBrowser.getScanTable() != null ? "value=\"" + metaBrowser.getScanTable() + "\"" : "");
                                out.write("\n                              aria-describedby=\"scan-filter-table\" style=\"display:inline; width:auto\" />\n            <label for=\"region-state-filter\">Region State</label>\n            <select class=\"form-control\" id=\"region-state-filter\" style=\"display:inline; width:auto\"\n                               name=\"");
                                out.print("scan_region_state");
                                out.write("\">\n              <option></option>\n");
                                results = RegionState.State.values();
                                int map32 = results.length;
                                boolean bl = false;
                                while (var45_103 < map32) {
                                    RegionState.State state = results[var45_103];
                                    boolean selected = metaBrowser.getScanRegionState() == state;
                                    out.write("\n              <option");
                                    out.print(selected ? " selected" : "");
                                    out.write(62);
                                    out.print((Object)state);
                                    out.write("</option>\n");
                                    ++var45_103;
                                }
                                out.write("\n            </select>\n            <button type=\"submit\" class=\"btn btn-primary\" style=\"display:inline; width:auto\">\n              Filter Results\n            </button>\n          </div>\n        </form>\n      </div>\n    </div>\n    ");
                            } else {
                                RegionStates states = master.getAssignmentManager().getRegionStates();
                                Map<RegionState.State, List<RegionInfo>> regionStates = states.getRegionByStateOfTable(table.getName());
                                HashMap<String, RegionState.State> stateMap = new HashMap<String, RegionState.State>();
                                for (RegionState.State regionState : regionStates.keySet()) {
                                    for (RegionInfo regionInfo : regionStates.get((Object)regionState)) {
                                        stateMap.put(regionInfo.getEncodedName(), regionState);
                                    }
                                }
                                RegionLocator r = master.getConnection().getRegionLocator(table.getName());
                                try {
                                    out.write("\n    <h2>Table Attributes</h2>\n    <table class=\"table table-striped\">\n      <tr>\n        <th>Attribute Name</th>\n        <th>Value</th>\n        <th>Description</th>\n      </tr>\n      <tr>\n        <td>Enabled</td>\n        <td>");
                                    out.print(master.getTableStateManager().isTableState(table.getName(), TableState.State.ENABLED));
                                    out.write("</td>\n        <td>Is the table enabled</td>\n      </tr>\n      <tr>\n        <td>Compaction</td>\n        <td>\n          ");
                                    if (master.getTableStateManager().isTableState(table.getName(), TableState.State.ENABLED)) {
                                        CompactionState compactionState = master.getCompactionState(table.getName());
                                        out.print(compactionState == null ? "UNKNOWN" : compactionState);
                                    } else {
                                        out.print((Object)CompactionState.NONE);
                                    }
                                    out.write("\n        </td>\n        <td>Is the table compacting</td>\n      </tr>\n      ");
                                    if (showFragmentation) {
                                        out.write("\n      <tr>\n        <td>Fragmentation</td>\n        <td>");
                                        out.print(frags.get(fqtn) != null ? frags.get(fqtn) + "%" : "n/a");
                                        out.write("</td>\n        <td>How fragmented is the table. After a major compaction it is 0%.</td>\n      </tr>\n      ");
                                    }
                                    out.write("\n      ");
                                    if (quotasEnabled) {
                                        List<ThrottleSettings> throttles;
                                        TableName tn = TableName.valueOf(fqtn);
                                        SpaceQuotaSnapshot masterSnapshot = null;
                                        Object quota = QuotaTableUtil.getTableQuota(master.getConnection(), tn);
                                        if (quota == null || !((QuotaProtos.Quotas)quota).hasSpace()) {
                                            quota = QuotaTableUtil.getNamespaceQuota(master.getConnection(), tn.getNamespaceAsString());
                                            if (quota != null) {
                                                masterSnapshot = master.getQuotaObserverChore().getNamespaceQuotaSnapshots().get(tn.getNamespaceAsString());
                                            }
                                        } else {
                                            masterSnapshot = master.getQuotaObserverChore().getTableQuotaSnapshots().get(tn);
                                        }
                                        if (quota != null && ((QuotaProtos.Quotas)quota).hasSpace()) {
                                            QuotaProtos.SpaceQuota spaceQuota = ((QuotaProtos.Quotas)quota).getSpace();
                                            out.write("\n      <tr>\n        <td>Space Quota</td>\n        <td>\n          <table>\n            <tr>\n              <th>Property</th>\n              <th>Value</th>\n            </tr>\n            <tr>\n              <td>Limit</td>\n              <td>");
                                            out.print(StringUtils.byteDesc((long)spaceQuota.getSoftLimit()));
                                            out.write("</td>\n            </tr>\n            <tr>\n              <td>Policy</td>\n              <td>");
                                            out.print((Object)spaceQuota.getViolationPolicy());
                                            out.write("</td>\n            </tr>\n            ");
                                            if (masterSnapshot != null) {
                                                out.write("\n            <tr>\n              <td>Usage</td>\n              <td>");
                                                out.print(StringUtils.byteDesc((long)masterSnapshot.getUsage()));
                                                out.write("</td>\n            </tr>\n            <tr>\n              <td>State</td>\n              <td>");
                                                out.print(masterSnapshot.getQuotaStatus().isInViolation() ? "In Violation" : "In Observance");
                                                out.write("</td>\n            </tr>\n            ");
                                            }
                                            out.write("\n          </table>\n        </td>\n        <td>Information about a Space Quota on this table, if set.</td>\n      </tr>\n      ");
                                        }
                                        if (quota != null && ((QuotaProtos.Quotas)quota).hasThrottle() && (throttles = QuotaSettingsFactory.fromTableThrottles(table.getName(), ((QuotaProtos.Quotas)quota).getThrottle())).size() > 0) {
                                            out.write("\n      <tr>\n        <td>Throttle Quota</td>\n        <td>\n          <table>\n            <tr>\n              <th>Limit</th>\n              <th>Type</th>\n              <th>TimeUnit</th>\n              <th>Scope</th>\n            </tr>\n            ");
                                            for (ThrottleSettings throttleSettings : throttles) {
                                                out.write("\n            <tr>\n              <td>");
                                                out.print(throttleSettings.getSoftLimit());
                                                out.write("</td>\n              <td>");
                                                out.print((Object)throttleSettings.getThrottleType());
                                                out.write("</td>\n              <td>");
                                                out.print((Object)throttleSettings.getTimeUnit());
                                                out.write("</td>\n              <td>");
                                                out.print((Object)throttleSettings.getQuotaScope());
                                                out.write("</td>\n            </tr>\n            ");
                                            }
                                            out.write("\n          </table>\n        </td>\n        <td>Information about a Throttle Quota on this table, if set.</td>\n      </tr>\n      ");
                                        }
                                    }
                                    out.write("\n    </table>\n    <h2>Table Schema</h2>\n    <table class=\"table table-striped\">\n    ");
                                    ColumnFamilyDescriptor[] families = table.getDescriptor().getColumnFamilies();
                                    HashSet<Bytes> familyKeySet = new HashSet<Bytes>();
                                    for (ColumnFamilyDescriptor columnFamilyDescriptor : families) {
                                        familyKeySet.addAll(columnFamilyDescriptor.getValues().keySet());
                                    }
                                    out.write("\n      <tr>\n        <th>Property \\ Column Family Name</th>\n        ");
                                    for (ColumnFamilyDescriptor columnFamilyDescriptor : families) {
                                        out.write("\n        <th>\n          ");
                                        out.print(StringEscapeUtils.escapeHtml4((String)columnFamilyDescriptor.getNameAsString()));
                                        out.write("\n        </th>\n        ");
                                    }
                                    out.write("\n      </tr>\n        ");
                                    for (Bytes familyKey : familyKeySet) {
                                        out.write("\n          <tr>\n            <td>\n              ");
                                        out.print(StringEscapeUtils.escapeHtml4((String)familyKey.toString()));
                                        out.write("\n            </td>\n            ");
                                        for (ColumnFamilyDescriptor family : families) {
                                            String familyValue = "-";
                                            if (family.getValues().containsKey(familyKey)) {
                                                familyValue = family.getValues().get(familyKey).toString();
                                            }
                                            out.write("\n            <td>\n              ");
                                            out.print(StringEscapeUtils.escapeHtml4((String)familyValue));
                                            out.write("\n            </td>\n            ");
                                        }
                                        out.write("\n          </tr>\n        ");
                                    }
                                    out.write("\n    </table>\n    ");
                                    long totalReadReq = 0L;
                                    long totalWriteReq = 0L;
                                    long l = 0L;
                                    long totalStoreFileCount = 0L;
                                    long totalMemSize = 0L;
                                    long totalCompactingCells = 0L;
                                    long totalCompactedCells = 0L;
                                    long totalBlocksTotalWeight = 0L;
                                    long totalBlocksLocalWeight = 0L;
                                    long totalBlocksLocalWithSsdWeight = 0L;
                                    String totalCompactionProgress = "";
                                    String totalMemSizeStr = "0 MB";
                                    String totalSizeStr = "0 MB";
                                    String totalLocality = "";
                                    String totalLocalityForSsd = "";
                                    String urlRegionServer = null;
                                    TreeMap<ServerName, Integer> regDistribution = new TreeMap<ServerName, Integer>();
                                    TreeMap<ServerName, Integer> primaryRegDistribution = new TreeMap<ServerName, Integer>();
                                    List<HRegionLocation> regions = r.getAllRegionLocations();
                                    LinkedHashMap<HRegionInfo, RegionMetrics> regionsToLoad = new LinkedHashMap<HRegionInfo, RegionMetrics>();
                                    LinkedHashMap<HRegionInfo, ServerName> regionsToServer = new LinkedHashMap<HRegionInfo, ServerName>();
                                    for (HRegionLocation hriEntry : regions) {
                                        HRegionInfo regionInfo = hriEntry.getRegionInfo();
                                        ServerName serverName = hriEntry.getServerName();
                                        regionsToServer.put(regionInfo, serverName);
                                        if (serverName != null) {
                                            ServerMetrics sl = master.getServerManager().getLoad(serverName);
                                            if (sl != null) {
                                                RegionMetrics regionMetrics = sl.getRegionMetrics().get(regionInfo.getRegionName());
                                                regionsToLoad.put(regionInfo, regionMetrics);
                                                if (regionMetrics != null) {
                                                    totalReadReq += regionMetrics.getReadRequestCount();
                                                    totalWriteReq += regionMetrics.getWriteRequestCount();
                                                    l = (long)((double)l + regionMetrics.getStoreFileSize().get(Size.Unit.MEGABYTE));
                                                    totalStoreFileCount += (long)regionMetrics.getStoreFileCount();
                                                    totalMemSize = (long)((double)totalMemSize + regionMetrics.getMemStoreSize().get(Size.Unit.MEGABYTE));
                                                    totalStoreFileSizeMB = (long)((double)totalStoreFileSizeMB + regionMetrics.getStoreFileSize().get(Size.Unit.MEGABYTE));
                                                    totalCompactingCells += regionMetrics.getCompactingCellCount();
                                                    totalCompactedCells += regionMetrics.getCompactedCellCount();
                                                    totalBlocksTotalWeight += regionMetrics.getBlocksTotalWeight();
                                                    totalBlocksLocalWeight += regionMetrics.getBlocksLocalWeight();
                                                    totalBlocksLocalWithSsdWeight += regionMetrics.getBlocksLocalWithSsdWeight();
                                                    continue;
                                                }
                                                RegionMetrics load0 = table_jsp.getEmptyRegionMetrics(regionInfo);
                                                regionsToLoad.put(regionInfo, load0);
                                                continue;
                                            }
                                            RegionMetrics load0 = table_jsp.getEmptyRegionMetrics(regionInfo);
                                            regionsToLoad.put(regionInfo, load0);
                                            continue;
                                        }
                                        RegionMetrics load0 = table_jsp.getEmptyRegionMetrics(regionInfo);
                                        regionsToLoad.put(regionInfo, load0);
                                    }
                                    if (l > 0L) {
                                        totalSizeStr = StringUtils.byteDesc((long)(l * 1024L * 1024L));
                                    }
                                    if (totalMemSize > 0L) {
                                        totalMemSizeStr = StringUtils.byteDesc((long)(totalMemSize * 1024L * 1024L));
                                    }
                                    if (totalCompactingCells > 0L) {
                                        totalCompactionProgress = String.format("%.2f", Float.valueOf(100.0f * ((float)totalCompactedCells / (float)totalCompactingCells))) + "%";
                                    }
                                    if (totalBlocksTotalWeight > 0L) {
                                        totalLocality = String.format("%.1f", Float.valueOf((float)totalBlocksLocalWeight / (float)totalBlocksTotalWeight));
                                        totalLocalityForSsd = String.format("%.1f", Float.valueOf((float)totalBlocksLocalWithSsdWeight / (float)totalBlocksTotalWeight));
                                    }
                                    if (regions != null && regions.size() > 0) {
                                        Object allRegionsUrl;
                                        RegionMetrics load;
                                        ServerName addr;
                                        RegionInfo regionInfo;
                                        out.write("\n    <h2>Table Regions</h2>\n    <div class=\"tabbable\">\n      <ul class=\"nav nav-pills\">\n        <li class=\"active\">\n          <a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a>\n        </li>\n        <li class=\"\">\n          <a href=\"#tab_localityStats\" data-toggle=\"tab\">Localities</a>\n        </li>\n        <li class=\"\">\n          <a href=\"#tab_compactStats\" data-toggle=\"tab\">Compactions</a>\n        </li>\n      </ul>\n      <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_baseStats\">\n          <table id=\"regionServerDetailsTable\" class=\"tablesorter table table-striped\">\n            <thead>\n            <tr>\n              <th>Name(");
                                        out.print(String.format("%,1d", regions.size()));
                                        out.write(")</th>\n              <th>Region Server</th>\n              <th>ReadRequests<br>(");
                                        out.print(String.format("%,1d", totalReadReq));
                                        out.write(")</th>\n              <th>WriteRequests<br>(");
                                        out.print(String.format("%,1d", totalWriteReq));
                                        out.write(")</th>\n              <th>StorefileSize<br>(");
                                        out.print(totalSizeStr);
                                        out.write(")</th>\n              <th>Num.Storefiles<br>(");
                                        out.print(String.format("%,1d", totalStoreFileCount));
                                        out.write(")</th>\n              <th>MemSize<br>(");
                                        out.print(totalMemSizeStr);
                                        out.write(")</th>\n              <th>Start Key</th>\n              <th>End Key</th>\n              <th>Region State</th>\n              ");
                                        if (withReplica) {
                                            out.write("\n              <th>ReplicaID</th>\n              ");
                                        }
                                        out.write("\n            </tr>\n            </thead>\n            <tbody>\n            ");
                                        ArrayList entryList = new ArrayList(regionsToLoad.entrySet());
                                        numRegions = regions.size();
                                        int numRegionsRendered = 0;
                                        if (numRegionsToRender < 0) {
                                            numRegionsToRender = numRegions;
                                        }
                                        for (Map.Entry entry2 : entryList) {
                                            regionInfo = (RegionInfo)entry2.getKey();
                                            addr = (ServerName)regionsToServer.get(regionInfo);
                                            load = (RegionMetrics)entry2.getValue();
                                            String readReq = "N/A";
                                            String writeReq = "N/A";
                                            String regionSize = "0 MB";
                                            String fileCount = "N/A";
                                            String memSize = "0 MB";
                                            String state = "N/A";
                                            if (load != null) {
                                                readReq = String.format("%,1d", load.getReadRequestCount());
                                                writeReq = String.format("%,1d", load.getWriteRequestCount());
                                                double rSize = load.getStoreFileSize().get(Size.Unit.BYTE);
                                                if (rSize > 0.0) {
                                                    regionSize = StringUtils.byteDesc((long)((long)rSize));
                                                }
                                                fileCount = String.format("%,1d", load.getStoreFileCount());
                                                double mSize = load.getMemStoreSize().get(Size.Unit.BYTE);
                                                if (mSize > 0.0) {
                                                    memSize = StringUtils.byteDesc((long)((long)mSize));
                                                }
                                            }
                                            if (stateMap.containsKey(regionInfo.getEncodedName())) {
                                                state = ((RegionState.State)((Object)stateMap.get(regionInfo.getEncodedName()))).toString();
                                            }
                                            if (addr != null) {
                                                ServerMetrics sl = master.getServerManager().getLoad(addr);
                                                urlRegionServer = "//" + URLEncoder.encode(addr.getHostname()) + ":" + master.getRegionServerInfoPort(addr) + "/rs-status";
                                                if (sl != null) {
                                                    Integer i = (Integer)regDistribution.get(addr);
                                                    if (null == i) {
                                                        i = 0;
                                                    }
                                                    regDistribution.put(addr, i + 1);
                                                    if (withReplica && RegionReplicaUtil.isDefaultReplica(regionInfo.getReplicaId())) {
                                                        i = (Integer)primaryRegDistribution.get(addr);
                                                        if (null == i) {
                                                            i = 0;
                                                        }
                                                        primaryRegDistribution.put(addr, i + 1);
                                                    }
                                                }
                                            }
                                            if (numRegionsRendered < numRegionsToRender) {
                                                ++numRegionsRendered;
                                                out.write("\n            <tr>\n              <td>");
                                                out.print(StringEscapeUtils.escapeXml((String)Bytes.toStringBinary(regionInfo.getRegionName())));
                                                out.write("</td>\n              ");
                                                if (urlRegionServer != null) {
                                                    out.write("\n              <td>\n                <a href=\"");
                                                    out.print(urlRegionServer);
                                                    out.write(34);
                                                    out.write(62);
                                                    out.print(addr == null ? "-" : StringEscapeUtils.escapeHtml4((String)addr.getHostname().toString()) + ":" + master.getRegionServerInfoPort(addr));
                                                    out.write("</a>\n              </td>\n              ");
                                                } else {
                                                    out.write("\n              <td class=\"undeployed-region\">not deployed</td>\n              ");
                                                }
                                                out.write("\n              <td>");
                                                out.print(readReq);
                                                out.write("</td>\n              <td>");
                                                out.print(writeReq);
                                                out.write("</td>\n              <td>");
                                                out.print(regionSize);
                                                out.write("</td>\n              <td>");
                                                out.print(fileCount);
                                                out.write("</td>\n              <td>");
                                                out.print(memSize);
                                                out.write("</td>\n              <td>");
                                                out.print(StringEscapeUtils.escapeXml((String)Bytes.toStringBinary(regionInfo.getStartKey())));
                                                out.write("</td>\n              <td>");
                                                out.print(StringEscapeUtils.escapeXml((String)Bytes.toStringBinary(regionInfo.getEndKey())));
                                                out.write("</td>\n              <td>");
                                                out.print(state);
                                                out.write("</td>\n              ");
                                                if (withReplica) {
                                                    out.write("\n              <td>");
                                                    out.print(regionInfo.getReplicaId());
                                                    out.write("</td>\n              ");
                                                }
                                                out.write("\n            </tr>\n            ");
                                            }
                                            out.write("\n            ");
                                        }
                                        out.write("\n            </tbody>\n          </table>\n          ");
                                        if (numRegions > numRegionsRendered) {
                                            allRegionsUrl = "?name=" + URLEncoder.encode(fqtn, "UTF-8") + "&numRegions=all";
                                            out.write("\n          <p>This table has <b>");
                                            out.print(numRegions);
                                            out.write("</b> regions in total, in order to improve the page load time,\n            only <b>");
                                            out.print(numRegionsRendered);
                                            out.write("</b> regions are displayed here, <a href=\"");
                                            out.print((String)allRegionsUrl);
                                            out.write("\">click\n              here</a> to see all regions.</p>\n          ");
                                        }
                                        out.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_localityStats\">\n          <table id=\"regionServerDetailsTable\" class=\"tablesorter table table-striped\">\n            <thead>\n              <tr>\n                <th>Name(");
                                        out.print(String.format("%,1d", regions.size()));
                                        out.write(")</th>\n                <th>Region Server</th>\n                <th>Locality<br>(");
                                        out.print(totalLocality);
                                        out.write(")</th>\n                <th>LocalityForSsd<br>(");
                                        out.print(totalLocalityForSsd);
                                        out.write(")</th>\n              </tr>\n            </thead>\n            <tbody>\n            ");
                                        numRegionsRendered = 0;
                                        for (Map.Entry entry3 : entryList) {
                                            regionInfo = (RegionInfo)entry3.getKey();
                                            addr = (ServerName)regionsToServer.get(regionInfo);
                                            load = (RegionMetrics)entry3.getValue();
                                            float locality = 0.0f;
                                            float localityForSsd = 0.0f;
                                            String state = "N/A";
                                            if (load != null) {
                                                locality = load.getDataLocality();
                                                localityForSsd = load.getDataLocalityForSsd();
                                            }
                                            if (addr != null) {
                                                urlRegionServer = "//" + URLEncoder.encode(addr.getHostname()) + ":" + master.getRegionServerInfoPort(addr) + "/rs-status";
                                            }
                                            if (numRegionsRendered < numRegionsToRender) {
                                                ++numRegionsRendered;
                                                out.write("\n            <tr>\n              <td>");
                                                out.print(StringEscapeUtils.escapeXml((String)Bytes.toStringBinary(regionInfo.getRegionName())));
                                                out.write("</td>\n              ");
                                                if (urlRegionServer != null) {
                                                    out.write("\n              <td>\n                 <a href=\"");
                                                    out.print(urlRegionServer);
                                                    out.write(34);
                                                    out.write(62);
                                                    out.print(addr == null ? "-" : StringEscapeUtils.escapeHtml4((String)addr.getHostname().toString()) + ":" + master.getRegionServerInfoPort(addr));
                                                    out.write("</a>\n              </td>\n              ");
                                                } else {
                                                    out.write("\n              <td class=\"undeployed-region\">not deployed</td>\n              ");
                                                }
                                                out.write("\n              <td>");
                                                out.print(locality);
                                                out.write("</td>\n              <td>");
                                                out.print(localityForSsd);
                                                out.write("</td>\n            </tr>\n            ");
                                            }
                                            out.write("\n            ");
                                        }
                                        out.write("\n            </tbody>\n          </table>\n        </div>\n        <div class=\"tab-pane\" id=\"tab_compactStats\">\n          <table id=\"tableCompactStatsTable\" class=\"tablesorter table table-striped\">\n            <thead>\n            <tr>\n              <th>Name(");
                                        out.print(String.format("%,1d", regions.size()));
                                        out.write(")</th>\n              <th>Region Server</th>\n              <th>Num. Compacting Cells<br>(");
                                        out.print(String.format("%,1d", totalCompactingCells));
                                        out.write(")</th>\n              <th>Num. Compacted Cells<br>(");
                                        out.print(String.format("%,1d", totalCompactedCells));
                                        out.write(")</th>\n              <th>Remaining Cells<br>(");
                                        out.print(String.format("%,1d", totalCompactingCells - totalCompactedCells));
                                        out.write(")</th>\n              <th>Compaction Progress<br>(");
                                        out.print(totalCompactionProgress);
                                        out.write(")</th>\n            </tr>\n            </thead>\n            <tbody>\n            ");
                                        numRegionsRendered = 0;
                                        for (Map.Entry entry4 : entryList) {
                                            regionInfo = (RegionInfo)entry4.getKey();
                                            addr = (ServerName)regionsToServer.get(regionInfo);
                                            load = (RegionMetrics)entry4.getValue();
                                            long compactingCells = 0L;
                                            long compactedCells = 0L;
                                            String compactionProgress = "";
                                            if (load != null) {
                                                compactingCells = load.getCompactingCellCount();
                                                compactedCells = load.getCompactedCellCount();
                                                if (compactingCells > 0L) {
                                                    compactionProgress = String.format("%.2f", Float.valueOf(100.0f * ((float)compactedCells / (float)compactingCells))) + "%";
                                                }
                                            }
                                            if (addr != null) {
                                                urlRegionServer = "//" + URLEncoder.encode(addr.getHostname()) + ":" + master.getRegionServerInfoPort(addr) + "/rs-status";
                                            }
                                            if (numRegionsRendered < numRegionsToRender) {
                                                ++numRegionsRendered;
                                                out.write("\n            <tr>\n              <td>");
                                                out.print(StringEscapeUtils.escapeXml((String)Bytes.toStringBinary(regionInfo.getRegionName())));
                                                out.write("</td>\n              ");
                                                if (urlRegionServer != null) {
                                                    out.write("\n              <td>\n                <a href=\"");
                                                    out.print(urlRegionServer);
                                                    out.write(34);
                                                    out.write(62);
                                                    out.print(addr == null ? "-" : StringEscapeUtils.escapeHtml4((String)addr.getHostname().toString()) + ":" + master.getRegionServerInfoPort(addr));
                                                    out.write("</a>\n              </td>\n              ");
                                                } else {
                                                    out.write("\n              <td class=\"undeployed-region\">not deployed</td>\n              ");
                                                }
                                                out.write("\n              <td>");
                                                out.print(String.format("%,1d", compactingCells));
                                                out.write("</td>\n              <td>");
                                                out.print(String.format("%,1d", compactedCells));
                                                out.write("</td>\n              <td>");
                                                out.print(String.format("%,1d", compactingCells - compactedCells));
                                                out.write("</td>\n              <td>");
                                                out.print(compactionProgress);
                                                out.write("</td>\n            </tr>\n            ");
                                            }
                                            out.write("\n            ");
                                        }
                                        out.write("\n            </tbody>\n          </table>\n          ");
                                        if (numRegions > numRegionsRendered) {
                                            allRegionsUrl = "?name=" + URLEncoder.encode(fqtn, "UTF-8") + "&numRegions=all";
                                            out.write("\n          <p>This table has <b>");
                                            out.print(numRegions);
                                            out.write("</b> regions in total, in order to improve the page load time,\n            only <b>");
                                            out.print(numRegionsRendered);
                                            out.write("</b> regions are displayed here, <a href=\"");
                                            out.print((String)allRegionsUrl);
                                            out.write("\">click\n              here</a> to see all regions.</p>\n          ");
                                        }
                                        out.write("\n        </div>\n      </div>\n    </div>\n    <h2>Regions by Region Server</h2>\n    ");
                                        if (withReplica) {
                                            out.write("\n    <table id=\"regionServerTable\" class=\"tablesorter table table-striped\"><thead><tr><th>Region Server</th><th>Region Count</th><th>Primary Region Count</th></tr></thead>\n        ");
                                        } else {
                                            out.write("\n      <table id=\"regionServerTable\" class=\"tablesorter table table-striped\"><thead><tr><th>Region Server</th><th>Region Count</th></tr></thead>\n        <tbody>\n        ");
                                        }
                                        out.write("\n        ");
                                        for (Map.Entry entry5 : regDistribution.entrySet()) {
                                            ServerName addr2 = (ServerName)entry5.getKey();
                                            String url = "//" + URLEncoder.encode(addr2.getHostname()) + ":" + master.getRegionServerInfoPort(addr2) + "/rs-status";
                                            out.write("\n        <tr>\n          <td><a href=\"");
                                            out.print(url);
                                            out.write(34);
                                            out.write(62);
                                            out.print(StringEscapeUtils.escapeHtml4((String)addr2.getHostname().toString()) + ":" + master.getRegionServerInfoPort(addr2));
                                            out.write("</a></td>\n          <td>");
                                            out.print(entry5.getValue());
                                            out.write("</td>\n          ");
                                            if (withReplica) {
                                                out.write("\n          <td>");
                                                out.print(primaryRegDistribution.get(addr2));
                                                out.write("</td>\n          ");
                                            }
                                            out.write("\n        </tr>\n        ");
                                        }
                                        out.write("\n        </tbody>\n      </table>\n        ");
                                    }
                                }
                                catch (Exception ex) {
                                    out.write("\n  Unknown Issue with Regions\n  <div onclick=\"document.getElementById('closeStackTrace').style.display='block';document.getElementById('openStackTrace').style.display='none';\">\n    <a id=\"openStackTrace\" style=\"cursor:pointer;\"> Show StackTrace</a>\n  </div>\n  <div id=\"closeStackTrace\" style=\"display:none;clear:both;\">\n    <div onclick=\"document.getElementById('closeStackTrace').style.display='none';document.getElementById('openStackTrace').style.display='block';\">\n      <a style=\"cursor:pointer;\"> Close StackTrace</a>\n    </div>\n  ");
                                    for (StackTraceElement element : ex.getStackTrace()) {
                                        out.print(StringEscapeUtils.escapeHtml4((String)(element.toString() + "\n")));
                                    }
                                }
                                finally {
                                    connection.close();
                                }
                            }
                            out.write("\n\n      <h2>Table Stats</h2>\n      <table class=\"table table-striped\">\n        <tr>\n          <th>Name</th>\n          <th>Value</th>\n          <th>Description</th>\n        </tr>\n        <tr>\n          <td>Size</td>\n          <td>\n            ");
                            if (totalStoreFileSizeMB > 0L) {
                                out.write("\n            ");
                                out.print(StringUtils.TraditionalBinaryPrefix.long2String((long)(totalStoreFileSizeMB * 1024L * 1024L), (String)"B", (int)2));
                                out.write("</td>\n          ");
                            } else {
                                out.write("\n          0 MB </td>\n          ");
                            }
                            out.write("\n          <td>Total size of store files</td>\n        </tr>\n      </table>\n\n        ");
                            if (!readOnly) {
                                out.write("\n      <p><hr/></p>\n      Actions:\n      <p>\n      <center>\n        <table class=\"table\" style=\"border: 0;\" width=\"95%\" >\n          <tr>\n            <form method=\"get\">\n              <input type=\"hidden\" name=\"action\" value=\"compact\" />\n              <input type=\"hidden\" name=\"name\" value=\"");
                                out.print(escaped_fqtn);
                                out.write("\" />\n              <td class=\"centered\">\n                <input style=\"font-size: 12pt; width: 10em\" type=\"submit\" value=\"Compact\" class=\"btn\" />\n              </td>\n              <td style=\"text-align: center;\">\n                <input type=\"text\" name=\"key\" size=\"40\" placeholder=\"Row Key (optional)\" />\n              </td>\n              <td>\n                This action will force a compaction of all regions of the table, or,\n                if a key is supplied, only the region containing the\n                given key.\n              </td>\n            </form>\n          </tr>\n          <tr>\n            <form method=\"get\">\n              <input type=\"hidden\" name=\"action\" value=\"split\" />\n              <input type=\"hidden\" name=\"name\" value=\"");
                                out.print(escaped_fqtn);
                                out.write("\" />\n              <td class=\"centered\">\n                <input style=\"font-size: 12pt; width: 10em\" type=\"submit\" value=\"Split\" class=\"btn\" />\n              </td>\n              <td style=\"text-align: center;\">\n                <input type=\"text\" name=\"key\" size=\"40\" placeholder=\"Row Key (optional)\" />\n              </td>\n              <td>\n                This action will force a split of all eligible\n                regions of the table, or, if a key is supplied, only the region containing the\n                given key. An eligible region is one that does not contain any references to\n                other regions. Split requests for noneligible regions will be ignored.\n              </td>\n            </form>\n          </tr>\n          <tr>\n            <form method=\"get\">\n              <input type=\"hidden\" name=\"action\" value=\"merge\" />\n              <input type=\"hidden\" name=\"name\" value=\"");
                                out.print(escaped_fqtn);
                                out.write("\" />\n              <td class=\"centered\">\n                <input style=\"font-size: 12pt; width: 10em\" type=\"submit\" value=\"Merge\" class=\"btn\" />\n              </td>\n              <td style=\"text-align: center;\">\n                <input type=\"text\" name=\"left\" size=\"40\" placeholder=\"Region Key (required)\" />\n                <input type=\"text\" name=\"right\" size=\"40\" placeholder=\"Region Key (required)\" />\n              </td>\n              <td>\n                This action will merge two regions of the table, Merge requests for\n                noneligible regions will be ignored.\n              </td>\n            </form>\n          </tr>\n        </table>\n      </center>\n      </p>\n        ");
                            }
                            out.write("\n  </div>\n</div>\n");
                        }
                        catch (TableNotFoundException e) {
                            out.write("\n<div class=\"container-fluid content\">\n  <div class=\"row inner_header\">\n    <div class=\"page-header\">\n      <h1>Table not found</h1>\n    </div>\n  </div>\n  <p><hr><p>\n  <p>Go <a href=\"javascript:history.back()\">Back</a>\n</div> ");
                        }
                        catch (IllegalArgumentException e) {
                            out.write("\n<div class=\"container-fluid content\">\n  <div class=\"row inner_header\">\n    <div class=\"page-header\">\n      <h1>Table qualifier must not be empty</h1>\n    </div>\n  </div>\n  <p><hr><p>\n  <p>Go <a href=\"javascript:history.back()\">Back</a>\n</div> ");
                        }
                    } else {
                        out.write("\n<div class=\"container-fluid content\">\n  <div class=\"row inner_header\">\n    <div class=\"page-header\">\n      <h1>Table not ready</h1>\n    </div>\n  </div>\n  <p><hr><p>\n  ");
                        JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)"redirect.jsp", (JspWriter)out, (boolean)false);
                        out.write("\n</div>\n");
                    }
                }
                out.write(10);
                out.write(10);
                JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)"footer.jsp", (JspWriter)out, (boolean)false);
                out.write("\n<script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/jquery.tablesorter.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n\n<script>\n    $(document).ready(function()\n        {\n            $.tablesorter.addParser(\n                {\n                    id: 'filesize',\n                    is: function(s) {\n                        return s.match(new RegExp( /([\\.0-9]+)\\ (B|KB|MB|GB|TB)/ ));\n                    },\n                    format: function(s) {\n                        var suf = s.match(new RegExp( /(B|KB|MB|GB|TB)$/ ))[1];\n                        var num = parseFloat(s.match( new RegExp( /([\\.0-9]+)\\ (B|KB|MB|GB|TB)/ ))[0]);\n                        switch(suf) {\n                            case 'B':\n                                return num;\n                            case 'KB':\n                                return num * 1024;\n                            case 'MB':\n                                return num * 1024 * 1024;\n");
                out.write("                            case 'GB':\n                                return num * 1024 * 1024 * 1024;\n                            case 'TB':\n                                return num * 1024 * 1024 * 1024 * 1024;\n                        }\n                    },\n                    type: 'numeric'\n                });\n            $.tablesorter.addParser(\n                {\n                    id: \"separator\",\n                    is: function (s) {\n                        return /^[0-9]?[0-9,]*$/.test(s);\n                    }, format: function (s) {\n                        return $.tablesorter.formatFloat( s.replace(/,/g,'') );\n                    }, type: \"numeric\"\n                });\n            $(\"#regionServerTable\").tablesorter({\n                headers: {\n                    1: {sorter: 'separator'}\n                }\n            });\n            $(\"#regionServerDetailsTable\").tablesorter({\n                headers: {\n                    2: {sorter: 'separator'},\n                    3: {sorter: 'separator'},\n");
                out.write("                    4: {sorter: 'filesize'},\n                    5: {sorter: 'separator'},\n                    6: {sorter: 'filesize'}\n                }\n            });\n            $(\"#tableRegionTable\").tablesorter({\n                headers: {\n                    2: {sorter: 'separator'},\n                    3: {sorter: 'separator'},\n                    4: {sorter: 'filesize'},\n                    5: {sorter: 'separator'},\n                    6: {sorter: 'filesize'}\n                }\n            });\n            $(\"#tableCompactStatsTable\").tablesorter({\n                headers: {\n                    2: {sorter: 'separator'},\n                    3: {sorter: 'separator'},\n                    4: {sorter: 'separator'}\n                }\n            });\n            $(\"#metaTableCompactStatsTable\").tablesorter({\n                headers: {\n                    2: {sorter: 'separator'},\n                    3: {sorter: 'separator'},\n                    4: {sorter: 'separator'}\n                }\n            });\n        }\n");
                out.write("    );\n</script>\n");
            }
            catch (Throwable t) {
                try {
                    if (t instanceof SkipPageException) break block147;
                    out = _jspx_out;
                    if (out != null && out.getBufferSize() != 0) {
                        out.clearBuffer();
                    }
                    if (_jspx_page_context != null) {
                        _jspx_page_context.handlePageException(t);
                    }
                    throw new ServletException(t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
            _jspxFactory.releasePageContext(_jspx_page_context);
        }
    }
}

