/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.io;

import io.hops.hudi.org.apache.hadoop.hbase.io.ByteBufferWriter;
import io.hops.hudi.org.apache.hadoop.hbase.io.util.StreamUtils;
import io.hops.hudi.org.apache.hadoop.hbase.util.ByteBufferUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ByteBufferWriterOutputStream
extends OutputStream
implements ByteBufferWriter {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final OutputStream os;
    private final int bufSize;
    private byte[] buf;

    public ByteBufferWriterOutputStream(OutputStream os) {
        this(os, 4096);
    }

    public ByteBufferWriterOutputStream(OutputStream os, int size) {
        this.os = os;
        this.bufSize = size;
        this.buf = null;
    }

    @Override
    public void write(ByteBuffer b, int off, int len) throws IOException {
        int bytesToCopy;
        if (this.buf == null) {
            this.buf = new byte[this.bufSize];
        }
        for (int totalCopied = 0; totalCopied < len; totalCopied += bytesToCopy) {
            bytesToCopy = Math.min(len - totalCopied, this.bufSize);
            ByteBufferUtils.copyFromBufferToArray(this.buf, b, off + totalCopied, 0, bytesToCopy);
            this.os.write(this.buf, 0, bytesToCopy);
        }
    }

    @Override
    public void writeInt(int i) throws IOException {
        StreamUtils.writeInt(this.os, i);
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }
}

