/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.io.hfile;

import io.hops.hudi.org.apache.hadoop.hbase.CellComparator;
import io.hops.hudi.org.apache.hadoop.hbase.CellComparatorImpl;
import io.hops.hudi.org.apache.hadoop.hbase.KeyValue;
import io.hops.hudi.org.apache.hadoop.hbase.MetaCellComparator;
import io.hops.hudi.org.apache.hadoop.hbase.io.compress.Compression;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.BlockType;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.HFileUtil;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.HFileProtos;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FixedFileTrailer {
    private static final Logger LOG = LoggerFactory.getLogger(FixedFileTrailer.class);
    private static final int MAX_COMPARATOR_NAME_LENGTH = 128;
    private long fileInfoOffset;
    private long loadOnOpenDataOffset;
    private int dataIndexCount;
    private long uncompressedDataIndexSize;
    private int metaIndexCount;
    private long totalUncompressedBytes;
    private long entryCount;
    private Compression.Algorithm compressionCodec = Compression.Algorithm.NONE;
    private int numDataIndexLevels;
    private long firstDataBlockOffset;
    private long lastDataBlockOffset;
    private String comparatorClassName = CellComparator.getInstance().getClass().getName();
    private byte[] encryptionKey;
    private final int majorVersion;
    private final int minorVersion;
    private static final int[] TRAILER_SIZE = FixedFileTrailer.computeTrailerSizeByVersion();
    private static final int MAX_TRAILER_SIZE = FixedFileTrailer.getMaxTrailerSize();
    private static final int NOT_PB_SIZE = 12;

    FixedFileTrailer(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        HFile.checkFormatVersion(majorVersion);
    }

    private static int[] computeTrailerSizeByVersion() {
        int[] versionToSize = new int[4];
        versionToSize[2] = 212;
        for (int version = 3; version <= 3; ++version) {
            versionToSize[version] = 4096;
        }
        return versionToSize;
    }

    private static int getMaxTrailerSize() {
        int maxSize = 0;
        for (int version = 2; version <= 3; ++version) {
            maxSize = Math.max(FixedFileTrailer.getTrailerSize(version), maxSize);
        }
        return maxSize;
    }

    static int getTrailerSize(int version) {
        return TRAILER_SIZE[version];
    }

    public int getTrailerSize() {
        return FixedFileTrailer.getTrailerSize(this.majorVersion);
    }

    void serialize(DataOutputStream outputStream) throws IOException {
        HFile.checkFormatVersion(this.majorVersion);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream baosDos = new DataOutputStream(baos);
        BlockType.TRAILER.write(baosDos);
        this.serializeAsPB(baosDos);
        baosDos.writeInt(FixedFileTrailer.materializeVersion(this.majorVersion, this.minorVersion));
        baos.writeTo(outputStream);
    }

    HFileProtos.FileTrailerProto toProtobuf() {
        HFileProtos.FileTrailerProto.Builder builder = HFileProtos.FileTrailerProto.newBuilder().setFileInfoOffset(this.fileInfoOffset).setLoadOnOpenDataOffset(this.loadOnOpenDataOffset).setUncompressedDataIndexSize(this.uncompressedDataIndexSize).setTotalUncompressedBytes(this.totalUncompressedBytes).setDataIndexCount(this.dataIndexCount).setMetaIndexCount(this.metaIndexCount).setEntryCount(this.entryCount).setNumDataIndexLevels(this.numDataIndexLevels).setFirstDataBlockOffset(this.firstDataBlockOffset).setLastDataBlockOffset(this.lastDataBlockOffset).setComparatorClassName(this.getHBase1CompatibleName(this.comparatorClassName)).setCompressionCodec(this.compressionCodec.ordinal());
        if (this.encryptionKey != null) {
            builder.setEncryptionKey(UnsafeByteOperations.unsafeWrap(this.encryptionKey));
        }
        return builder.build();
    }

    void serializeAsPB(DataOutputStream output) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.toProtobuf().writeDelimitedTo(baos);
        baos.writeTo(output);
        int padding = this.getTrailerSize() - 12 - baos.size();
        if (padding < 0) {
            throw new IOException("Pbuf encoding size exceeded fixed trailer size limit");
        }
        for (int i = 0; i < padding; ++i) {
            output.write(0);
        }
    }

    void deserialize(DataInputStream inputStream) throws IOException {
        HFile.checkFormatVersion(this.majorVersion);
        BlockType.TRAILER.readAndCheck(inputStream);
        if (this.majorVersion > 2 || this.majorVersion == 2 && this.minorVersion >= 2) {
            this.deserializeFromPB(inputStream);
        } else {
            this.deserializeFromWritable(inputStream);
        }
        int version = inputStream.readInt();
        this.expectMajorVersion(FixedFileTrailer.extractMajorVersion(version));
        this.expectMinorVersion(FixedFileTrailer.extractMinorVersion(version));
    }

    void deserializeFromPB(DataInputStream inputStream) throws IOException {
        int start = inputStream.available();
        HFileProtos.FileTrailerProto trailerProto = HFileProtos.FileTrailerProto.PARSER.parseDelimitedFrom(inputStream);
        int size = start - inputStream.available();
        inputStream.skip(this.getTrailerSize() - 12 - size);
        if (trailerProto.hasFileInfoOffset()) {
            this.fileInfoOffset = trailerProto.getFileInfoOffset();
        }
        if (trailerProto.hasLoadOnOpenDataOffset()) {
            this.loadOnOpenDataOffset = trailerProto.getLoadOnOpenDataOffset();
        }
        if (trailerProto.hasUncompressedDataIndexSize()) {
            this.uncompressedDataIndexSize = trailerProto.getUncompressedDataIndexSize();
        }
        if (trailerProto.hasTotalUncompressedBytes()) {
            this.totalUncompressedBytes = trailerProto.getTotalUncompressedBytes();
        }
        if (trailerProto.hasDataIndexCount()) {
            this.dataIndexCount = trailerProto.getDataIndexCount();
        }
        if (trailerProto.hasMetaIndexCount()) {
            this.metaIndexCount = trailerProto.getMetaIndexCount();
        }
        if (trailerProto.hasEntryCount()) {
            this.entryCount = trailerProto.getEntryCount();
        }
        if (trailerProto.hasNumDataIndexLevels()) {
            this.numDataIndexLevels = trailerProto.getNumDataIndexLevels();
        }
        if (trailerProto.hasFirstDataBlockOffset()) {
            this.firstDataBlockOffset = trailerProto.getFirstDataBlockOffset();
        }
        if (trailerProto.hasLastDataBlockOffset()) {
            this.lastDataBlockOffset = trailerProto.getLastDataBlockOffset();
        }
        if (trailerProto.hasComparatorClassName()) {
            this.setComparatorClass(FixedFileTrailer.getComparatorClass(trailerProto.getComparatorClassName()));
        }
        this.compressionCodec = trailerProto.hasCompressionCodec() ? Compression.Algorithm.values()[trailerProto.getCompressionCodec()] : Compression.Algorithm.NONE;
        if (trailerProto.hasEncryptionKey()) {
            this.encryptionKey = trailerProto.getEncryptionKey().toByteArray();
        }
    }

    void deserializeFromWritable(DataInput input) throws IOException {
        this.fileInfoOffset = input.readLong();
        this.loadOnOpenDataOffset = input.readLong();
        this.dataIndexCount = input.readInt();
        this.uncompressedDataIndexSize = input.readLong();
        this.metaIndexCount = input.readInt();
        this.totalUncompressedBytes = input.readLong();
        this.entryCount = input.readLong();
        this.compressionCodec = Compression.Algorithm.values()[input.readInt()];
        this.numDataIndexLevels = input.readInt();
        this.firstDataBlockOffset = input.readLong();
        this.lastDataBlockOffset = input.readLong();
        this.setComparatorClass(FixedFileTrailer.getComparatorClass(Bytes.readStringFixedSize(input, 128)));
    }

    private void append(StringBuilder sb, String s) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(s);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.append(sb, "fileinfoOffset=" + this.fileInfoOffset);
        this.append(sb, "loadOnOpenDataOffset=" + this.loadOnOpenDataOffset);
        this.append(sb, "dataIndexCount=" + this.dataIndexCount);
        this.append(sb, "metaIndexCount=" + this.metaIndexCount);
        this.append(sb, "totalUncomressedBytes=" + this.totalUncompressedBytes);
        this.append(sb, "entryCount=" + this.entryCount);
        this.append(sb, "compressionCodec=" + (Object)((Object)this.compressionCodec));
        this.append(sb, "uncompressedDataIndexSize=" + this.uncompressedDataIndexSize);
        this.append(sb, "numDataIndexLevels=" + this.numDataIndexLevels);
        this.append(sb, "firstDataBlockOffset=" + this.firstDataBlockOffset);
        this.append(sb, "lastDataBlockOffset=" + this.lastDataBlockOffset);
        this.append(sb, "comparatorClassName=" + this.comparatorClassName);
        if (this.majorVersion >= 3) {
            this.append(sb, "encryptionKey=" + (this.encryptionKey != null ? "PRESENT" : "NONE"));
        }
        this.append(sb, "majorVersion=" + this.majorVersion);
        this.append(sb, "minorVersion=" + this.minorVersion);
        return sb.toString();
    }

    public static FixedFileTrailer readFromStream(FSDataInputStream istream, long fileSize) throws IOException {
        int bufferSize = MAX_TRAILER_SIZE;
        long seekPoint = fileSize - (long)bufferSize;
        if (seekPoint < 0L) {
            seekPoint = 0L;
            bufferSize = (int)fileSize;
        }
        HFileUtil.seekOnMultipleSources(istream, seekPoint);
        ByteBuffer buf = ByteBuffer.allocate(bufferSize);
        istream.readFully(buf.array(), buf.arrayOffset(), buf.arrayOffset() + buf.limit());
        buf.position(buf.limit() - 4);
        int version = buf.getInt();
        int majorVersion = FixedFileTrailer.extractMajorVersion(version);
        int minorVersion = FixedFileTrailer.extractMinorVersion(version);
        HFile.checkFormatVersion(majorVersion);
        int trailerSize = FixedFileTrailer.getTrailerSize(majorVersion);
        FixedFileTrailer fft = new FixedFileTrailer(majorVersion, minorVersion);
        fft.deserialize(new DataInputStream(new ByteArrayInputStream(buf.array(), buf.arrayOffset() + bufferSize - trailerSize, trailerSize)));
        return fft;
    }

    public void expectMajorVersion(int expected) {
        if (this.majorVersion != expected) {
            throw new IllegalArgumentException("Invalid HFile major version: " + this.majorVersion + " (expected: " + expected + ")");
        }
    }

    public void expectMinorVersion(int expected) {
        if (this.minorVersion != expected) {
            throw new IllegalArgumentException("Invalid HFile minor version: " + this.minorVersion + " (expected: " + expected + ")");
        }
    }

    public void expectAtLeastMajorVersion(int lowerBound) {
        if (this.majorVersion < lowerBound) {
            throw new IllegalArgumentException("Invalid HFile major version: " + this.majorVersion + " (expected: " + lowerBound + " or higher).");
        }
    }

    public long getFileInfoOffset() {
        return this.fileInfoOffset;
    }

    public void setFileInfoOffset(long fileInfoOffset) {
        this.fileInfoOffset = fileInfoOffset;
    }

    public long getLoadOnOpenDataOffset() {
        return this.loadOnOpenDataOffset;
    }

    public void setLoadOnOpenOffset(long loadOnOpenDataOffset) {
        this.loadOnOpenDataOffset = loadOnOpenDataOffset;
    }

    public int getDataIndexCount() {
        return this.dataIndexCount;
    }

    public void setDataIndexCount(int dataIndexCount) {
        this.dataIndexCount = dataIndexCount;
    }

    public int getMetaIndexCount() {
        return this.metaIndexCount;
    }

    public void setMetaIndexCount(int metaIndexCount) {
        this.metaIndexCount = metaIndexCount;
    }

    public long getTotalUncompressedBytes() {
        return this.totalUncompressedBytes;
    }

    public void setTotalUncompressedBytes(long totalUncompressedBytes) {
        this.totalUncompressedBytes = totalUncompressedBytes;
    }

    public long getEntryCount() {
        return this.entryCount;
    }

    public void setEntryCount(long newEntryCount) {
        this.entryCount = newEntryCount;
    }

    public Compression.Algorithm getCompressionCodec() {
        return this.compressionCodec;
    }

    public void setCompressionCodec(Compression.Algorithm compressionCodec) {
        this.compressionCodec = compressionCodec;
    }

    public int getNumDataIndexLevels() {
        this.expectAtLeastMajorVersion(2);
        return this.numDataIndexLevels;
    }

    public void setNumDataIndexLevels(int numDataIndexLevels) {
        this.expectAtLeastMajorVersion(2);
        this.numDataIndexLevels = numDataIndexLevels;
    }

    public long getLastDataBlockOffset() {
        this.expectAtLeastMajorVersion(2);
        return this.lastDataBlockOffset;
    }

    public void setLastDataBlockOffset(long lastDataBlockOffset) {
        this.expectAtLeastMajorVersion(2);
        this.lastDataBlockOffset = lastDataBlockOffset;
    }

    public long getFirstDataBlockOffset() {
        this.expectAtLeastMajorVersion(2);
        return this.firstDataBlockOffset;
    }

    public void setFirstDataBlockOffset(long firstDataBlockOffset) {
        this.expectAtLeastMajorVersion(2);
        this.firstDataBlockOffset = firstDataBlockOffset;
    }

    public String getComparatorClassName() {
        return this.comparatorClassName;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setComparatorClass(Class<? extends CellComparator> klass) {
        try {
            if (klass != null) {
                CellComparator comp = klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.comparatorClassName = klass.getName();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Comparator class " + klass.getName() + " is not instantiable", e);
        }
    }

    @Deprecated
    private String getHBase1CompatibleName(String comparator) {
        if (comparator.equals(CellComparatorImpl.class.getName())) {
            return KeyValue.COMPARATOR.getClass().getName();
        }
        if (comparator.equals(MetaCellComparator.class.getName())) {
            return KeyValue.META_COMPARATOR.getClass().getName();
        }
        return comparator;
    }

    private static Class<? extends CellComparator> getComparatorClass(String comparatorClassName) throws IOException {
        Class comparatorKlass;
        if (comparatorClassName.equals(KeyValue.COMPARATOR.getLegacyKeyComparatorName()) || comparatorClassName.equals(KeyValue.COMPARATOR.getClass().getName()) || comparatorClassName.equals("io.hops.hudi.org.apache.hadoop.hbase.CellComparator")) {
            comparatorKlass = CellComparatorImpl.class;
        } else if (comparatorClassName.equals(KeyValue.META_COMPARATOR.getLegacyKeyComparatorName()) || comparatorClassName.equals(KeyValue.META_COMPARATOR.getClass().getName()) || comparatorClassName.equals("io.hops.hudi.org.apache.hadoop.hbase.MetaCellComparator")) {
            comparatorKlass = MetaCellComparator.class;
        } else if (comparatorClassName.equals("io.hops.hudi.org.apache.hadoop.hbase.KeyValue$RawBytesComparator") || comparatorClassName.equals("io.hops.hudi.org.apache.hadoop.hbase.util.Bytes$ByteArrayComparator")) {
            comparatorKlass = null;
        } else {
            try {
                comparatorKlass = Class.forName(comparatorClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }
        return comparatorKlass;
    }

    static CellComparator createComparator(String comparatorClassName) throws IOException {
        if (comparatorClassName.equals(CellComparatorImpl.COMPARATOR.getClass().getName())) {
            return CellComparatorImpl.COMPARATOR;
        }
        if (comparatorClassName.equals(MetaCellComparator.META_COMPARATOR.getClass().getName())) {
            return MetaCellComparator.META_COMPARATOR;
        }
        try {
            Class<? extends CellComparator> comparatorClass = FixedFileTrailer.getComparatorClass(comparatorClassName);
            if (comparatorClass != null) {
                return comparatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            LOG.warn("No Comparator class for " + comparatorClassName + ". Returning Null.");
            return null;
        }
        catch (Exception e) {
            throw new IOException("Comparator class " + comparatorClassName + " is not instantiable", e);
        }
    }

    CellComparator createComparator() throws IOException {
        this.expectAtLeastMajorVersion(2);
        return FixedFileTrailer.createComparator(this.comparatorClassName);
    }

    public long getUncompressedDataIndexSize() {
        return this.uncompressedDataIndexSize;
    }

    public void setUncompressedDataIndexSize(long uncompressedDataIndexSize) {
        this.expectAtLeastMajorVersion(2);
        this.uncompressedDataIndexSize = uncompressedDataIndexSize;
    }

    public byte[] getEncryptionKey() {
        this.expectAtLeastMajorVersion(2);
        return this.encryptionKey;
    }

    public void setEncryptionKey(byte[] keyBytes) {
        this.encryptionKey = keyBytes;
    }

    private static int extractMajorVersion(int serializedVersion) {
        return serializedVersion & 0xFFFFFF;
    }

    private static int extractMinorVersion(int serializedVersion) {
        return serializedVersion >>> 24;
    }

    static int materializeVersion(int majorVersion, int minorVersion) {
        return majorVersion & 0xFFFFFF | minorVersion << 24;
    }
}

