/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master.procedure;

import io.hops.hudi.org.apache.hadoop.hbase.ServerName;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.SwitchRpcThrottleRemoteProcedure;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.Procedure;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.RpcThrottleStorage;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import io.hops.hudi.org.apache.hadoop.hbase.util.RetryCounter;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Message;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SwitchRpcThrottleProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.SwitchRpcThrottleState>
implements ServerProcedureInterface {
    private static Logger LOG = LoggerFactory.getLogger(SwitchRpcThrottleProcedure.class);
    private RpcThrottleStorage rpcThrottleStorage;
    private boolean rpcThrottleEnabled;
    private ProcedurePrepareLatch syncLatch;
    private ServerName serverName;
    private RetryCounter retryCounter;

    public SwitchRpcThrottleProcedure() {
    }

    public SwitchRpcThrottleProcedure(RpcThrottleStorage rpcThrottleStorage, boolean rpcThrottleEnabled, ServerName serverName, ProcedurePrepareLatch syncLatch) {
        this.rpcThrottleStorage = rpcThrottleStorage;
        this.syncLatch = syncLatch;
        this.rpcThrottleEnabled = rpcThrottleEnabled;
        this.serverName = serverName;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.SwitchRpcThrottleState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        switch (state) {
            case UPDATE_SWITCH_RPC_THROTTLE_STORAGE: {
                try {
                    this.switchThrottleState(env, this.rpcThrottleEnabled);
                }
                catch (IOException e) {
                    if (this.retryCounter == null) {
                        this.retryCounter = ProcedureUtil.createRetryCounter((Configuration)env.getMasterConfiguration());
                    }
                    long backoff = this.retryCounter.getBackoffTimeAndIncrementAttempts();
                    LOG.warn("Failed to store rpc throttle value {}, sleep {} secs and retry", new Object[]{this.rpcThrottleEnabled, backoff / 1000L, e});
                    this.setTimeout(Math.toIntExact(backoff));
                    this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
                    this.skipPersistence();
                    throw new ProcedureSuspendedException();
                }
                this.setNextState(MasterProcedureProtos.SwitchRpcThrottleState.SWITCH_RPC_THROTTLE_ON_RS);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case SWITCH_RPC_THROTTLE_ON_RS: {
                Procedure[] subProcedures = (SwitchRpcThrottleRemoteProcedure[])env.getMasterServices().getServerManager().getOnlineServersList().stream().map(sn -> new SwitchRpcThrottleRemoteProcedure((ServerName)sn, this.rpcThrottleEnabled)).toArray(SwitchRpcThrottleRemoteProcedure[]::new);
                this.addChildProcedure(subProcedures);
                this.setNextState(MasterProcedureProtos.SwitchRpcThrottleState.POST_SWITCH_RPC_THROTTLE);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case POST_SWITCH_RPC_THROTTLE: {
                ProcedurePrepareLatch.releaseLatch(this.syncLatch, (Procedure)this);
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.SwitchRpcThrottleState state) throws IOException, InterruptedException {
    }

    protected MasterProcedureProtos.SwitchRpcThrottleState getState(int stateId) {
        return MasterProcedureProtos.SwitchRpcThrottleState.forNumber(stateId);
    }

    protected int getStateId(MasterProcedureProtos.SwitchRpcThrottleState throttleState) {
        return throttleState.getNumber();
    }

    protected MasterProcedureProtos.SwitchRpcThrottleState getInitialState() {
        return MasterProcedureProtos.SwitchRpcThrottleState.UPDATE_SWITCH_RPC_THROTTLE_STORAGE;
    }

    protected MasterProcedureProtos.SwitchRpcThrottleState getCurrentState() {
        return (MasterProcedureProtos.SwitchRpcThrottleState)super.getCurrentState();
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        serializer.serialize((Message)MasterProcedureProtos.SwitchRpcThrottleStateData.newBuilder().setRpcThrottleEnabled(this.rpcThrottleEnabled).build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.SwitchRpcThrottleStateData data = (MasterProcedureProtos.SwitchRpcThrottleStateData)serializer.deserialize(MasterProcedureProtos.SwitchRpcThrottleStateData.class);
        this.rpcThrottleEnabled = data.getRpcThrottleEnabled();
    }

    @Override
    public ServerName getServerName() {
        return this.serverName;
    }

    @Override
    public boolean hasMetaTableRegion() {
        return false;
    }

    @Override
    public ServerProcedureInterface.ServerOperationType getServerOperationType() {
        return ServerProcedureInterface.ServerOperationType.SWITCH_RPC_THROTTLE;
    }

    public void switchThrottleState(MasterProcedureEnv env, boolean rpcThrottleEnabled) throws IOException {
        this.rpcThrottleStorage.switchRpcThrottle(rpcThrottleEnabled);
    }

    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" server=");
        sb.append(this.serverName);
        sb.append(", rpcThrottleEnabled=");
        sb.append(this.rpcThrottleEnabled);
    }
}

