/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master.region;

import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
final class MasterRegionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MasterRegionUtils.class);

    private MasterRegionUtils() {
    }

    static void moveFilesUnderDir(FileSystem fs, Path src, Path dst, String suffix) throws IOException {
        if (!fs.exists(dst) && !fs.mkdirs(dst)) {
            LOG.warn("Failed to create dir {}", (Object)dst);
            return;
        }
        FileStatus[] archivedWALFiles = fs.listStatus(src);
        if (archivedWALFiles == null) {
            return;
        }
        for (FileStatus status : archivedWALFiles) {
            Path newFile;
            Path file = status.getPath();
            if (fs.rename(file, newFile = new Path(dst, file.getName() + suffix))) {
                LOG.info("Moved {} to {}", (Object)file, (Object)newFile);
                continue;
            }
            LOG.warn("Failed to move from {} to {}", (Object)file, (Object)newFile);
        }
    }
}

