/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver.querymatcher;

import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.ScanInfo;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.ColumnTracker;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.CompactionScanQueryMatcher;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.DeleteTracker;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import java.io.IOException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MinorCompactionScanQueryMatcher
extends CompactionScanQueryMatcher {
    public MinorCompactionScanQueryMatcher(ScanInfo scanInfo, DeleteTracker deletes, ColumnTracker columns, long readPointToUse, long oldestUnexpiredTS, long now) {
        super(scanInfo, deletes, columns, readPointToUse, oldestUnexpiredTS, now);
    }

    @Override
    public ScanQueryMatcher.MatchCode match(Cell cell) throws IOException {
        ScanQueryMatcher.MatchCode returnCode = this.preCheck(cell);
        if (returnCode != null) {
            return returnCode;
        }
        long mvccVersion = cell.getSequenceId();
        byte typeByte = cell.getTypeByte();
        if (PrivateCellUtil.isDelete(typeByte)) {
            if (mvccVersion > this.maxReadPointToTrackVersions) {
                return ScanQueryMatcher.MatchCode.INCLUDE;
            }
            this.trackDelete(cell);
            return ScanQueryMatcher.MatchCode.INCLUDE;
        }
        returnCode = this.checkDeleted(this.deletes, cell);
        if (returnCode != null) {
            return returnCode;
        }
        return this.columns.checkVersions(cell, cell.getTimestamp(), typeByte, mvccVersion > this.maxReadPointToTrackVersions);
    }
}

