/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.replication.regionserver;

import io.hops.hudi.org.apache.hadoop.hbase.Abortable;
import io.hops.hudi.org.apache.hadoop.hbase.ChoreService;
import io.hops.hudi.org.apache.hadoop.hbase.CoordinatedStateManager;
import io.hops.hudi.org.apache.hadoop.hbase.HBaseConfiguration;
import io.hops.hudi.org.apache.hadoop.hbase.Server;
import io.hops.hudi.org.apache.hadoop.hbase.ServerName;
import io.hops.hudi.org.apache.hadoop.hbase.client.ClusterConnection;
import io.hops.hudi.org.apache.hadoop.hbase.client.Connection;
import io.hops.hudi.org.apache.hadoop.hbase.replication.regionserver.Replication;
import io.hops.hudi.org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import io.hops.hudi.org.apache.hadoop.hbase.util.CommonFSUtils;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WALFactory;
import io.hops.hudi.org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReplicationSyncUp
extends Configured
implements Tool {
    private static final long SLEEP_TIME = 10000L;

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new ReplicationSyncUp(), (String[])args);
        System.exit(ret);
    }

    public int run(String[] args) throws Exception {
        Abortable abortable = new Abortable(){

            @Override
            public void abort(String why, Throwable e) {
            }

            @Override
            public boolean isAborted() {
                return false;
            }
        };
        Configuration conf = this.getConf();
        try (ZKWatcher zkw = new ZKWatcher(conf, "syncupReplication" + System.currentTimeMillis(), abortable, true);){
            Path walRootDir = CommonFSUtils.getWALRootDir(conf);
            FileSystem fs = CommonFSUtils.getWALFileSystem(conf);
            Path oldLogDir = new Path(walRootDir, "oldWALs");
            Path logDir = new Path(walRootDir, "WALs");
            System.out.println("Start Replication Server start");
            Replication replication = new Replication();
            replication.initialize(new DummyServer(zkw), fs, logDir, oldLogDir, new WALFactory(conf, "test", null));
            ReplicationSourceManager manager = replication.getReplicationManager();
            manager.init().get();
            while (manager.activeFailoverTaskCount() > 0) {
                Thread.sleep(10000L);
            }
            while (manager.getOldSources().size() > 0) {
                Thread.sleep(10000L);
            }
            manager.join();
        }
        catch (InterruptedException e) {
            System.err.println("didn't wait long enough:" + e);
            return -1;
        }
        return 0;
    }

    class DummyServer
    implements Server {
        String hostname;
        ZKWatcher zkw;

        DummyServer(ZKWatcher zkw) {
            this.hostname = System.currentTimeMillis() + ".SyncUpTool.replication.org";
            this.zkw = zkw;
        }

        DummyServer(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public Configuration getConfiguration() {
            return ReplicationSyncUp.this.getConf();
        }

        @Override
        public ZKWatcher getZooKeeper() {
            return this.zkw;
        }

        @Override
        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        @Override
        public ServerName getServerName() {
            return ServerName.valueOf(this.hostname, 1234, 1L);
        }

        @Override
        public void abort(String why, Throwable e) {
        }

        @Override
        public boolean isAborted() {
            return false;
        }

        @Override
        public void stop(String why) {
        }

        @Override
        public boolean isStopped() {
            return false;
        }

        @Override
        public ClusterConnection getConnection() {
            return null;
        }

        @Override
        public ChoreService getChoreService() {
            return null;
        }

        @Override
        public ClusterConnection getClusterConnection() {
            return null;
        }

        @Override
        public FileSystem getFileSystem() {
            return null;
        }

        @Override
        public boolean isStopping() {
            return false;
        }

        @Override
        public Connection createConnection(Configuration conf) throws IOException {
            return null;
        }
    }
}

