/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.snapshot;

import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.Admin;
import io.hops.hudi.org.apache.hadoop.hbase.client.Connection;
import io.hops.hudi.org.apache.hadoop.hbase.client.ConnectionFactory;
import io.hops.hudi.org.apache.hadoop.hbase.client.SnapshotDescription;
import io.hops.hudi.org.apache.hadoop.hbase.client.SnapshotType;
import io.hops.hudi.org.apache.hadoop.hbase.util.AbstractHBaseTool;
import io.hops.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import java.util.Arrays;
import java.util.Locale;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CreateSnapshot
extends AbstractHBaseTool {
    private SnapshotType snapshotType = SnapshotType.FLUSH;
    private TableName tableName = null;
    private String snapshotName = null;

    public static void main(String[] args) {
        new CreateSnapshot().doStaticMain(args);
    }

    @Override
    protected void addOptions() {
        this.addRequiredOptWithArg("t", "table", "The name of the table");
        this.addRequiredOptWithArg("n", "name", "The name of the created snapshot");
        this.addOptWithArg("s", "snapshot_type", "Snapshot Type. FLUSH is default. Posible values are " + Arrays.toString((Object[])SnapshotType.values()));
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        this.tableName = TableName.valueOf(cmd.getOptionValue('t'));
        this.snapshotName = cmd.getOptionValue('n');
        String snapshotTypeName = cmd.getOptionValue('s');
        if (snapshotTypeName != null) {
            snapshotTypeName = snapshotTypeName.toUpperCase(Locale.ROOT);
            this.snapshotType = SnapshotType.valueOf(snapshotTypeName);
        }
    }

    @Override
    protected int doWork() throws Exception {
        try (Connection connection = ConnectionFactory.createConnection(this.getConf());
             Admin admin = connection.getAdmin();){
            admin.snapshot(new SnapshotDescription(this.snapshotName, this.tableName, this.snapshotType));
        }
        catch (Exception e) {
            System.err.println("failed to take the snapshot: " + e.getMessage());
            return -1;
        }
        return 0;
    }
}

