/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.types;

import io.hops.hudi.org.apache.hadoop.hbase.types.DataType;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import io.hops.hudi.org.apache.hadoop.hbase.util.Order;
import io.hops.hudi.org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class RawString
implements DataType<String> {
    public static final RawString ASCENDING = new RawString(Order.ASCENDING);
    public static final RawString DESCENDING = new RawString(Order.DESCENDING);
    protected final Order order;

    protected RawString() {
        this.order = Order.ASCENDING;
    }

    protected RawString(Order order) {
        this.order = order;
    }

    @Override
    public boolean isOrderPreserving() {
        return true;
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isSkippable() {
        return false;
    }

    @Override
    public int skip(PositionedByteRange src) {
        int skipped = src.getRemaining();
        src.setPosition(src.getLength());
        return skipped;
    }

    @Override
    public int encodedLength(String val) {
        return Bytes.toBytes(val).length;
    }

    @Override
    public Class<String> encodedClass() {
        return String.class;
    }

    @Override
    public String decode(PositionedByteRange src) {
        if (Order.ASCENDING == this.order) {
            String val = Bytes.toString(src.getBytes(), src.getOffset() + src.getPosition(), src.getRemaining());
            src.setPosition(src.getLength());
            return val;
        }
        byte[] b = new byte[src.getRemaining()];
        src.get(b);
        this.order.apply(b, 0, b.length);
        return Bytes.toString(b);
    }

    @Override
    public int encode(PositionedByteRange dst, String val) {
        byte[] s = Bytes.toBytes(val);
        this.order.apply(s);
        dst.put(s);
        return s.length;
    }
}

