/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.util;

import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.BloomType;
import io.hops.hudi.org.apache.hadoop.hbase.util.BloomFilterBase;
import io.hops.hudi.org.apache.hadoop.hbase.util.BloomFilterUtil;
import io.hops.hudi.org.apache.hadoop.hbase.util.ByteArrayHashKey;
import io.hops.hudi.org.apache.hadoop.hbase.util.Hash;
import io.hops.hudi.org.apache.hadoop.hbase.util.RowBloomHashKey;
import io.hops.hudi.org.apache.hadoop.hbase.util.RowColBloomHashKey;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class BloomFilterChunk
implements BloomFilterBase {
    protected long byteSize;
    protected int hashCount;
    protected final int hashType;
    protected final Hash hash;
    protected int keyCount;
    protected int maxKeys;
    protected ByteBuffer bloom;
    protected BloomType bloomType;

    public BloomFilterChunk(DataInput meta) throws IOException, IllegalArgumentException {
        this.byteSize = meta.readInt();
        this.hashCount = meta.readInt();
        this.hashType = meta.readInt();
        this.maxKeys = this.keyCount = meta.readInt();
        this.hash = Hash.getInstance(this.hashType);
        if (this.hash == null) {
            throw new IllegalArgumentException("Invalid hash type: " + this.hashType);
        }
        this.sanityCheck();
    }

    public double actualErrorRate() {
        return BloomFilterUtil.actualErrorRate(this.keyCount, this.byteSize * 8L, this.hashCount);
    }

    public BloomFilterChunk(int hashType, BloomType bloomType) {
        this.hashType = hashType;
        this.hash = Hash.getInstance(hashType);
        this.bloomType = bloomType;
    }

    public BloomFilterChunk(int maxKeys, double errorRate, int hashType, int foldFactor) throws IllegalArgumentException {
        this(hashType, BloomType.ROW);
        long bitSize = BloomFilterUtil.computeBitSize(maxKeys, errorRate);
        this.hashCount = BloomFilterUtil.optimalFunctionCount(maxKeys, bitSize);
        this.maxKeys = maxKeys;
        this.byteSize = BloomFilterUtil.computeFoldableByteSize(bitSize, foldFactor);
        this.sanityCheck();
    }

    public BloomFilterChunk createAnother() {
        BloomFilterChunk bbf = new BloomFilterChunk(this.hashType, this.bloomType);
        bbf.byteSize = this.byteSize;
        bbf.hashCount = this.hashCount;
        bbf.maxKeys = this.maxKeys;
        return bbf;
    }

    public void allocBloom() {
        if (this.bloom != null) {
            throw new IllegalArgumentException("can only create bloom once.");
        }
        this.bloom = ByteBuffer.allocate((int)this.byteSize);
        assert (this.bloom.hasArray());
    }

    void sanityCheck() throws IllegalArgumentException {
        if (0L >= this.byteSize || this.byteSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid byteSize: " + this.byteSize);
        }
        if (this.hashCount <= 0) {
            throw new IllegalArgumentException("Hash function count must be > 0");
        }
        if (this.hash == null) {
            throw new IllegalArgumentException("hashType must be known");
        }
        if (this.keyCount < 0) {
            throw new IllegalArgumentException("must have positive keyCount");
        }
    }

    void bloomCheck(ByteBuffer bloom) throws IllegalArgumentException {
        if (this.byteSize != (long)bloom.limit()) {
            throw new IllegalArgumentException("Configured bloom length should match actual length");
        }
    }

    void add(byte[] buf, int offset, int len) {
        ByteArrayHashKey hashKey = new ByteArrayHashKey(buf, offset, len);
        int hash1 = this.hash.hash(hashKey, 0);
        int hash2 = this.hash.hash(hashKey, hash1);
        this.setHashLoc(hash1, hash2);
    }

    public void add(Cell cell) {
        int hash2;
        int hash1;
        if (this.bloomType == BloomType.ROWCOL) {
            RowColBloomHashKey hashKey = new RowColBloomHashKey(cell);
            hash1 = this.hash.hash(hashKey, 0);
            hash2 = this.hash.hash(hashKey, hash1);
        } else {
            RowBloomHashKey hashKey = new RowBloomHashKey(cell);
            hash1 = this.hash.hash(hashKey, 0);
            hash2 = this.hash.hash(hashKey, hash1);
        }
        this.setHashLoc(hash1, hash2);
    }

    private void setHashLoc(int hash1, int hash2) {
        for (int i = 0; i < this.hashCount; ++i) {
            long hashLoc = Math.abs((long)(hash1 + i * hash2) % (this.byteSize * 8L));
            this.set(hashLoc);
        }
        ++this.keyCount;
    }

    void set(long pos) {
        int bytePos = (int)(pos / 8L);
        int bitPos = (int)(pos % 8L);
        byte curByte = this.bloom.get(bytePos);
        curByte = (byte)(curByte | BloomFilterUtil.bitvals[bitPos]);
        this.bloom.put(bytePos, curByte);
    }

    static boolean get(int pos, ByteBuffer bloomBuf, int bloomOffset) {
        int bytePos = pos >> 3;
        int bitPos = pos & 7;
        byte curByte = bloomBuf.get(bloomOffset + bytePos);
        return (curByte = (byte)(curByte & BloomFilterUtil.bitvals[bitPos])) != 0;
    }

    @Override
    public long getKeyCount() {
        return this.keyCount;
    }

    @Override
    public long getMaxKeys() {
        return this.maxKeys;
    }

    @Override
    public long getByteSize() {
        return this.byteSize;
    }

    public int getHashType() {
        return this.hashType;
    }

    public void compactBloom() {
        if (this.keyCount > 0 && this.bloom.hasArray()) {
            int newMaxKeys;
            int pieces = 1;
            int newByteSize = (int)this.byteSize;
            for (newMaxKeys = this.maxKeys; (newByteSize & 1) == 0 && newMaxKeys > this.keyCount << 1; newMaxKeys >>= 1) {
                pieces <<= 1;
                newByteSize >>= 1;
            }
            if (pieces > 1) {
                int end;
                byte[] array = this.bloom.array();
                int start = this.bloom.arrayOffset();
                int off = end = start + newByteSize;
                for (int p = 1; p < pieces; ++p) {
                    int pos = start;
                    while (pos < end) {
                        int n = pos++;
                        array[n] = (byte)(array[n] | array[off++]);
                    }
                }
                this.bloom.rewind();
                this.bloom.limit(newByteSize);
                this.bloom = this.bloom.slice();
                this.byteSize = newByteSize;
                this.maxKeys = newMaxKeys;
            }
        }
    }

    public void writeBloom(DataOutput out) throws IOException {
        if (!this.bloom.hasArray()) {
            throw new IOException("Only writes ByteBuffer with underlying array.");
        }
        out.write(this.bloom.array(), this.bloom.arrayOffset(), this.bloom.limit());
    }

    public int getHashCount() {
        return this.hashCount;
    }

    public String toString() {
        return BloomFilterUtil.toString(this);
    }
}

