/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.util;

import io.hops.hudi.org.apache.hadoop.hbase.util.ByteArrayHashKey;
import io.hops.hudi.org.apache.hadoop.hbase.util.Hash;
import io.hops.hudi.org.apache.hadoop.hbase.util.HashKey;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class JenkinsHash
extends Hash {
    private static final int BYTE_MASK = 255;
    private static JenkinsHash _instance = new JenkinsHash();

    public static Hash getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("Usage: JenkinsHash filename");
            System.exit(-1);
        }
        FileInputStream in = new FileInputStream(args[0]);
        byte[] bytes = new byte[512];
        int value = 0;
        JenkinsHash hash = new JenkinsHash();
        try {
            int length = in.read(bytes);
            while (length > 0) {
                value = hash.hash(new ByteArrayHashKey(bytes, 0, length), value);
                length = in.read(bytes);
            }
        }
        finally {
            in.close();
        }
        System.out.println(Math.abs(value));
    }

    @Override
    public <T> int hash(HashKey<T> hashKey, int initval) {
        int length;
        int c;
        int b = c = -559038737 + length + initval;
        int a = c;
        int offset = 0;
        for (length = hashKey.length(); length > 12; length -= 12) {
            a += hashKey.get(offset) & 0xFF;
            a += (hashKey.get(offset + 1) & 0xFF) << 8;
            a += (hashKey.get(offset + 2) & 0xFF) << 16;
            a += (hashKey.get(offset + 3) & 0xFF) << 24;
            b += hashKey.get(offset + 4) & 0xFF;
            b += (hashKey.get(offset + 5) & 0xFF) << 8;
            b += (hashKey.get(offset + 6) & 0xFF) << 16;
            b += (hashKey.get(offset + 7) & 0xFF) << 24;
            c += hashKey.get(offset + 8) & 0xFF;
            c += (hashKey.get(offset + 9) & 0xFF) << 8;
            c += (hashKey.get(offset + 10) & 0xFF) << 16;
            a -= (c += (hashKey.get(offset + 11) & 0xFF) << 24);
            a ^= Integer.rotateLeft(c, 4);
            c += b;
            b -= a;
            b ^= Integer.rotateLeft(a, 6);
            a += c;
            c -= b;
            c ^= Integer.rotateLeft(b, 8);
            b += a;
            a -= c;
            a ^= Integer.rotateLeft(c, 16);
            c += b;
            b -= a;
            b ^= Integer.rotateLeft(a, 19);
            a += c;
            c -= b;
            c ^= Integer.rotateLeft(b, 4);
            b += a;
            offset += 12;
        }
        switch (length) {
            case 12: {
                c += (hashKey.get(offset + 11) & 0xFF) << 24;
            }
            case 11: {
                c += (hashKey.get(offset + 10) & 0xFF) << 16;
            }
            case 10: {
                c += (hashKey.get(offset + 9) & 0xFF) << 8;
            }
            case 9: {
                c += hashKey.get(offset + 8) & 0xFF;
            }
            case 8: {
                b += (hashKey.get(offset + 7) & 0xFF) << 24;
            }
            case 7: {
                b += (hashKey.get(offset + 6) & 0xFF) << 16;
            }
            case 6: {
                b += (hashKey.get(offset + 5) & 0xFF) << 8;
            }
            case 5: {
                b += hashKey.get(offset + 4) & 0xFF;
            }
            case 4: {
                a += (hashKey.get(offset + 3) & 0xFF) << 24;
            }
            case 3: {
                a += (hashKey.get(offset + 2) & 0xFF) << 16;
            }
            case 2: {
                a += (hashKey.get(offset + 1) & 0xFF) << 8;
            }
            case 1: {
                a += hashKey.get(offset + 0) & 0xFF;
                break;
            }
            case 0: {
                return c;
            }
        }
        c ^= b;
        a ^= (c -= Integer.rotateLeft(b, 14));
        b ^= (a -= Integer.rotateLeft(c, 11));
        c ^= (b -= Integer.rotateLeft(a, 25));
        a ^= (c -= Integer.rotateLeft(b, 16));
        b ^= (a -= Integer.rotateLeft(c, 4));
        c ^= (b -= Integer.rotateLeft(a, 14));
        return c -= Integer.rotateLeft(b, 24);
    }
}

