/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.util;

import io.hops.hudi.org.apache.hadoop.hbase.HBaseConfiguration;
import io.hops.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import io.hops.hudi.org.apache.hadoop.hbase.util.Threads;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class ServerCommandLine
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(ServerCommandLine.class);
    private static final Set<String> DEFAULT_SKIP_WORDS = new HashSet<String>(){
        {
            this.add("secret");
            this.add("passwd");
            this.add("password");
            this.add("credential");
        }
    };

    protected abstract String getUsage();

    protected void usage(String message) {
        if (message != null) {
            System.err.println(message);
            System.err.println("");
        }
        System.err.println(this.getUsage());
    }

    public static void logJVMInfo() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        if (runtime != null) {
            LOG.info("vmName=" + runtime.getVmName() + ", vmVendor=" + runtime.getVmVendor() + ", vmVersion=" + runtime.getVmVersion());
            LOG.info("vmInputArguments=" + runtime.getInputArguments());
        }
    }

    private static void logHBaseConfigs(Configuration conf) {
        String[] keys;
        for (String key : keys = new String[]{"hbase.tmp.dir", "hbase.rootdir", "hbase.cluster.distributed", "hbase.zookeeper.quorum"}) {
            LOG.info(key + ": " + conf.get(key));
        }
    }

    public static void logProcessInfo(Configuration conf) {
        ServerCommandLine.logHBaseConfigs(conf);
        if (conf == null || !conf.getBoolean("hbase.envvars.logging.disabled", false)) {
            String[] confSkipWords;
            HashSet<String> skipWords = new HashSet<String>(DEFAULT_SKIP_WORDS);
            if (conf != null && (confSkipWords = conf.getStrings("hbase.envvars.logging.skipwords")) != null) {
                skipWords.addAll(Arrays.asList(confSkipWords));
            }
            block0: for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                String key = entry.getKey().toLowerCase(Locale.ROOT);
                String value = entry.getValue().toLowerCase(Locale.ROOT);
                for (String skipWord : skipWords) {
                    if (!key.contains(skipWord) && !value.contains(skipWord)) continue;
                    continue block0;
                }
                LOG.info("env:" + entry);
            }
        }
        ServerCommandLine.logJVMInfo();
    }

    public void doMain(String[] args) {
        try {
            int ret = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)this, (String[])args);
            if (ret != 0) {
                System.exit(ret);
            }
            boolean forceStop = false;
            long startTime = EnvironmentEdgeManager.currentTime();
            while (Threads.isNonDaemonThreadRunning()) {
                if (EnvironmentEdgeManager.currentTime() - startTime > 30000L) {
                    forceStop = true;
                    break;
                }
                Thread.sleep(1000L);
            }
            if (forceStop) {
                LOG.error("Failed to stop all non-daemon threads, so terminating JVM");
                System.exit(-1);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to run", (Throwable)e);
            System.exit(-1);
        }
    }
}

