/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.util;

import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionReplicaUtil;
import io.hops.hudi.org.apache.hadoop.hbase.io.HFileLink;
import io.hops.hudi.org.apache.hadoop.hbase.io.Reference;
import io.hops.hudi.org.apache.hadoop.hbase.master.MasterServices;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.HRegion;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import io.hops.hudi.org.apache.hadoop.hbase.replication.ReplicationException;
import io.hops.hudi.org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import io.hops.hudi.org.apache.hadoop.hbase.replication.regionserver.RegionReplicaReplicationEndpoint;
import io.hops.hudi.org.apache.hadoop.hbase.zookeeper.ZKConfig;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ServerRegionReplicaUtil
extends RegionReplicaUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ServerRegionReplicaUtil.class);
    public static final String REGION_REPLICA_REPLICATION_CONF_KEY = "hbase.region.replica.replication.enabled";
    private static final boolean DEFAULT_REGION_REPLICA_REPLICATION = false;
    public static final String REGION_REPLICA_REPLICATION_PEER = "region_replica_replication";
    public static final String REGION_REPLICA_REPLICATION_CATALOG_CONF_KEY = "hbase.region.replica.replication.catalog.enabled";
    private static final boolean DEFAULT_REGION_REPLICA_REPLICATION_CATALOG = false;
    public static final String REGION_REPLICA_STORE_FILE_REFRESH = "hbase.region.replica.storefile.refresh";
    private static final boolean DEFAULT_REGION_REPLICA_STORE_FILE_REFRESH = true;
    public static final String REGION_REPLICA_STORE_FILE_REFRESH_MEMSTORE_MULTIPLIER = "hbase.region.replica.storefile.refresh.memstore.multiplier";
    private static final double DEFAULT_REGION_REPLICA_STORE_FILE_REFRESH_MEMSTORE_MULTIPLIER = 4.0;

    public static RegionInfo getRegionInfoForFs(RegionInfo regionInfo) {
        if (regionInfo == null) {
            return null;
        }
        return RegionReplicaUtil.getRegionInfoForDefaultReplica(regionInfo);
    }

    public static boolean isReadOnly(HRegion region) {
        return region.getTableDescriptor().isReadOnly() || !ServerRegionReplicaUtil.isDefaultReplica(region.getRegionInfo());
    }

    public static boolean shouldReplayRecoveredEdits(HRegion region) {
        return ServerRegionReplicaUtil.isDefaultReplica(region.getRegionInfo());
    }

    public static StoreFileInfo getStoreFileInfo(Configuration conf, FileSystem fs, RegionInfo regionInfo, RegionInfo regionInfoForFs, String familyName, Path path) throws IOException {
        if (RegionInfo.COMPARATOR.compare(regionInfo, regionInfoForFs) == 0) {
            return new StoreFileInfo(conf, fs, path, true);
        }
        if (HFileLink.isHFileLink(path) || StoreFileInfo.isHFile(path)) {
            HFileLink link = HFileLink.build(conf, regionInfoForFs.getTable(), regionInfoForFs.getEncodedName(), familyName, path.getName());
            return new StoreFileInfo(conf, fs, link.getFileStatus(fs), link);
        }
        if (StoreFileInfo.isReference(path)) {
            Reference reference = Reference.read(fs, path);
            Path referencePath = StoreFileInfo.getReferredToFile(path);
            if (HFileLink.isHFileLink(referencePath)) {
                HFileLink link = HFileLink.buildFromHFileLinkPattern(conf, referencePath);
                return new StoreFileInfo(conf, fs, link.getFileStatus(fs), reference, link);
            }
            HFileLink link = HFileLink.build(conf, regionInfoForFs.getTable(), regionInfoForFs.getEncodedName(), familyName, path.getName());
            return new StoreFileInfo(conf, fs, link.getFileStatus(fs), reference);
        }
        throw new IOException("path=" + path + " doesn't look like a valid StoreFile");
    }

    public static void setupRegionReplicaReplication(MasterServices services) throws IOException, ReplicationException {
        if (!ServerRegionReplicaUtil.isRegionReplicaReplicationEnabled(services.getConfiguration())) {
            return;
        }
        if (services.getReplicationPeerManager().getPeerConfig(REGION_REPLICA_REPLICATION_PEER).isPresent()) {
            return;
        }
        LOG.info("Region replica replication peer id=region_replica_replication not exist. Creating...");
        ReplicationPeerConfig peerConfig = ReplicationPeerConfig.newBuilder().setClusterKey(ZKConfig.getZooKeeperClusterKey(services.getConfiguration())).setReplicationEndpointImpl(RegionReplicaReplicationEndpoint.class.getName()).build();
        services.addReplicationPeer(REGION_REPLICA_REPLICATION_PEER, peerConfig, true);
    }

    public static boolean isRegionReplicaReplicationEnabled(Configuration conf, TableName tn) {
        return ServerRegionReplicaUtil.isMetaRegionReplicaReplicationEnabled(conf, tn) || ServerRegionReplicaUtil.isRegionReplicaReplicationEnabled(conf);
    }

    private static boolean isRegionReplicaReplicationEnabled(Configuration conf) {
        return conf.getBoolean(REGION_REPLICA_REPLICATION_CONF_KEY, false);
    }

    public static boolean isMetaRegionReplicaReplicationEnabled(Configuration conf, TableName tn) {
        return TableName.isMetaTableName(tn) && conf.getBoolean(REGION_REPLICA_REPLICATION_CATALOG_CONF_KEY, false);
    }

    public static boolean isRegionReplicaWaitForPrimaryFlushEnabled(Configuration conf) {
        return conf.getBoolean("hbase.region.replica.wait.for.primary.flush", true);
    }

    public static boolean isRegionReplicaStoreFileRefreshEnabled(Configuration conf) {
        return conf.getBoolean(REGION_REPLICA_STORE_FILE_REFRESH, true);
    }

    public static double getRegionReplicaStoreFileRefreshMultiplier(Configuration conf) {
        return conf.getDouble(REGION_REPLICA_STORE_FILE_REFRESH_MEMSTORE_MULTIPLIER, 4.0);
    }
}

