/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.util;

import io.hops.hudi.org.apache.hadoop.hbase.util.MovingAverage;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class WindowMovingAverage
extends MovingAverage {
    protected static final int DEFAULT_SIZE = 5;
    protected long[] lastN;
    protected int mostRecent;
    protected boolean oneRound;

    public WindowMovingAverage(String label) {
        this(label, 5);
    }

    public WindowMovingAverage(String label, int size) {
        super(label);
        this.lastN = new long[size <= 0 ? 5 : size];
        this.mostRecent = -1;
        this.oneRound = false;
    }

    @Override
    protected void updateMostRecentTime(long elapsed) {
        int index = this.moveForwardMostRecentPosistion();
        this.lastN[index] = elapsed;
    }

    @Override
    public double getAverageTime() {
        return this.enoughStatistics() ? (double)this.sum(this.getNumberOfStatistics()) / (double)this.getNumberOfStatistics() : (double)this.sum(this.getMostRecentPosistion() + 1) / (double)(this.getMostRecentPosistion() + 1);
    }

    protected boolean enoughStatistics() {
        return this.oneRound;
    }

    protected int getNumberOfStatistics() {
        return this.lastN.length;
    }

    protected long getStatisticsAtIndex(int index) {
        if (index < 0 || index >= this.getNumberOfStatistics()) {
            throw new IndexOutOfBoundsException();
        }
        return this.lastN[index];
    }

    protected int getMostRecentPosistion() {
        return this.mostRecent;
    }

    protected int moveForwardMostRecentPosistion() {
        int index = ++this.mostRecent;
        if (!this.oneRound && index == this.getNumberOfStatistics()) {
            this.oneRound = true;
        }
        this.mostRecent = index % this.getNumberOfStatistics();
        return this.mostRecent;
    }

    private long sum(int bound) {
        long sum = 0L;
        for (int i = 0; i < bound; ++i) {
            sum += this.getStatisticsAtIndex(i);
        }
        return sum;
    }
}

