/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import io.hops.hudi.org.apache.avro.AvroRuntimeException;
import io.hops.hudi.org.apache.avro.Schema;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hudi.common.util.ValidationUtils;

public class AvroSchemaUtils {
    private AvroSchemaUtils() {
    }

    public static Schema appendFieldsToSchema(Schema schema, List<Schema.Field> newFields) {
        List<Schema.Field> fields = schema.getFields().stream().map(field -> new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal())).collect(Collectors.toList());
        fields.addAll(newFields);
        Schema newSchema = Schema.createRecord(schema.getName(), schema.getDoc(), schema.getNamespace(), schema.isError());
        newSchema.setFields(fields);
        return newSchema;
    }

    public static Schema resolveUnionSchema(Schema schema, String fieldSchemaFullName) {
        if (schema.getType() != Schema.Type.UNION) {
            return schema;
        }
        List<Schema> innerTypes = schema.getTypes();
        Schema nonNullType = innerTypes.stream().filter(it -> it.getType() != Schema.Type.NULL && Objects.equals(it.getFullName(), fieldSchemaFullName)).findFirst().orElse(null);
        if (nonNullType == null) {
            throw new AvroRuntimeException(String.format("Unsupported Avro UNION type %s: Only UNION of a null type and a non-null type is supported", schema));
        }
        return nonNullType;
    }

    public static boolean isNullable(Schema schema) {
        if (schema.getType() != Schema.Type.UNION) {
            return false;
        }
        List<Schema> innerTypes = schema.getTypes();
        return innerTypes.size() > 1 && innerTypes.stream().anyMatch(it -> it.getType() == Schema.Type.NULL);
    }

    public static Schema resolveNullableSchema(Schema schema) {
        if (schema.getType() != Schema.Type.UNION) {
            return schema;
        }
        List<Schema> innerTypes = schema.getTypes();
        Schema nonNullType = innerTypes.stream().filter(it -> it.getType() != Schema.Type.NULL).findFirst().orElse(null);
        if (innerTypes.size() != 2 || nonNullType == null) {
            throw new AvroRuntimeException(String.format("Unsupported Avro UNION type %s: Only UNION of a null type and a non-null type is supported", schema));
        }
        return nonNullType;
    }

    public static Schema createNullableSchema(Schema.Type avroType) {
        ValidationUtils.checkState(avroType != Schema.Type.NULL);
        return Schema.createUnion(Schema.create(Schema.Type.NULL), Schema.create(avroType));
    }

    public static boolean containsFieldInSchema(Schema schema, String fieldName) {
        try {
            Schema.Field field = schema.getField(fieldName);
            return field != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

