/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bootstrap.index;

import io.hops.hudi.org.apache.hadoop.hbase.CellComparatorImpl;
import io.hops.hudi.org.apache.hadoop.hbase.CellUtil;
import io.hops.hudi.org.apache.hadoop.hbase.KeyValue;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.HFileContext;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.HFileScanner;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieBootstrapFilePartitionInfo;
import org.apache.hudi.avro.model.HoodieBootstrapIndexInfo;
import org.apache.hudi.avro.model.HoodieBootstrapPartitionMetadata;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.common.bootstrap.index.BootstrapIndex;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.model.BootstrapFileMapping;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.HoodieHFileUtils;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HFileBootstrapIndex
extends BootstrapIndex {
    protected static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(HFileBootstrapIndex.class);
    public static final String BOOTSTRAP_INDEX_FILE_ID = "00000000-0000-0000-0000-000000000000-0";
    private static final String PARTITION_KEY_PREFIX = "part";
    private static final String FILE_ID_KEY_PREFIX = "fileid";
    private static final String KEY_VALUE_SEPARATOR = "=";
    private static final String KEY_PARTS_SEPARATOR = ";";
    private static final String HFILE_CELL_KEY_SUFFIX_PART = "//LATEST_TIMESTAMP/Put/vlen";
    public static final byte[] INDEX_INFO_KEY = Bytes.toBytes("INDEX_INFO");
    private final boolean isPresent;

    public HFileBootstrapIndex(HoodieTableMetaClient metaClient) {
        super(metaClient);
        Path indexByPartitionPath = HFileBootstrapIndex.partitionIndexPath(metaClient);
        Path indexByFilePath = HFileBootstrapIndex.fileIdIndexPath(metaClient);
        try {
            HoodieWrapperFileSystem fs = metaClient.getFs();
            this.isPresent = !HoodieTableMetadata.isMetadataTable(metaClient.getBasePathV2().toString()) && fs.exists(indexByPartitionPath) && fs.exists(indexByFilePath);
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    private static String getPartitionKey(String partition) {
        return HFileBootstrapIndex.getKeyValueString(PARTITION_KEY_PREFIX, partition);
    }

    private static String getFileGroupKey(HoodieFileGroupId fileGroupId) {
        return HFileBootstrapIndex.getPartitionKey(fileGroupId.getPartitionPath()) + KEY_PARTS_SEPARATOR + HFileBootstrapIndex.getKeyValueString(FILE_ID_KEY_PREFIX, fileGroupId.getFileId());
    }

    private static String getPartitionFromKey(String key) {
        String[] parts = key.split(KEY_VALUE_SEPARATOR, 2);
        ValidationUtils.checkArgument(parts[0].equals(PARTITION_KEY_PREFIX));
        return parts[1];
    }

    private static String getFileIdFromKey(String key) {
        String[] parts = key.split(KEY_VALUE_SEPARATOR, 2);
        ValidationUtils.checkArgument(parts[0].equals(FILE_ID_KEY_PREFIX));
        return parts[1];
    }

    private static HoodieFileGroupId getFileGroupFromKey(String key) {
        String[] parts = key.split(KEY_PARTS_SEPARATOR, 2);
        return new HoodieFileGroupId(HFileBootstrapIndex.getPartitionFromKey(parts[0]), HFileBootstrapIndex.getFileIdFromKey(parts[1]));
    }

    private static String getKeyValueString(String key, String value) {
        return key + KEY_VALUE_SEPARATOR + value;
    }

    private static Path partitionIndexPath(HoodieTableMetaClient metaClient) {
        return new Path(metaClient.getBootstrapIndexByPartitionFolderPath(), FSUtils.makeBootstrapIndexFileName("00000000000001", BOOTSTRAP_INDEX_FILE_ID, HoodieFileFormat.HFILE.getFileExtension()));
    }

    private static Path fileIdIndexPath(HoodieTableMetaClient metaClient) {
        return new Path(metaClient.getBootstrapIndexByFileIdFolderNameFolderPath(), FSUtils.makeBootstrapIndexFileName("00000000000001", BOOTSTRAP_INDEX_FILE_ID, HoodieFileFormat.HFILE.getFileExtension()));
    }

    private static String getUserKeyFromCellKey(String cellKey) {
        int hfileSuffixBeginIndex = cellKey.lastIndexOf(HFILE_CELL_KEY_SUFFIX_PART);
        return cellKey.substring(0, hfileSuffixBeginIndex);
    }

    private static HFile.Reader createReader(String hFilePath, Configuration conf, FileSystem fileSystem) {
        try {
            LOG.info((Object)("Opening HFile for reading :" + hFilePath));
            return HoodieHFileUtils.createHFileReader(fileSystem, new HFilePathForReader(hFilePath), new CacheConfig(conf), conf);
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    @Override
    public BootstrapIndex.IndexReader createReader() {
        return new HFileBootstrapIndexReader(this.metaClient);
    }

    @Override
    public BootstrapIndex.IndexWriter createWriter(String bootstrapBasePath) {
        return new HFileBootstrapIndexWriter(bootstrapBasePath, this.metaClient);
    }

    @Override
    public void dropIndex() {
        try {
            Path[] indexPaths;
            for (Path indexPath : indexPaths = new Path[]{HFileBootstrapIndex.partitionIndexPath(this.metaClient), HFileBootstrapIndex.fileIdIndexPath(this.metaClient)}) {
                if (!this.metaClient.getFs().exists(indexPath)) continue;
                LOG.info((Object)("Dropping bootstrap index. Deleting file : " + indexPath));
                this.metaClient.getFs().delete(indexPath);
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    @Override
    public boolean isPresent() {
        return this.isPresent;
    }

    public static class HoodieKVComparator
    extends CellComparatorImpl {
    }

    private static class HFilePathForReader
    extends Path {
        public HFilePathForReader(String pathString) throws IllegalArgumentException {
            super(pathString);
        }

        public String getName() {
            return this.toString();
        }
    }

    public static class HFileBootstrapIndexWriter
    extends BootstrapIndex.IndexWriter {
        private final String bootstrapBasePath;
        private final Path indexByPartitionPath;
        private final Path indexByFileIdPath;
        private HFile.Writer indexByPartitionWriter;
        private HFile.Writer indexByFileIdWriter;
        private boolean closed = false;
        private int numPartitionKeysAdded = 0;
        private int numFileIdKeysAdded = 0;
        private final Map<String, List<BootstrapFileMapping>> sourceFileMappings = new HashMap<String, List<BootstrapFileMapping>>();

        private HFileBootstrapIndexWriter(String bootstrapBasePath, HoodieTableMetaClient metaClient) {
            super(metaClient);
            try {
                metaClient.initializeBootstrapDirsIfNotExists();
                this.bootstrapBasePath = bootstrapBasePath;
                this.indexByPartitionPath = HFileBootstrapIndex.partitionIndexPath(metaClient);
                this.indexByFileIdPath = HFileBootstrapIndex.fileIdIndexPath(metaClient);
                if (metaClient.getFs().exists(this.indexByPartitionPath) || metaClient.getFs().exists(this.indexByFileIdPath)) {
                    String errMsg = "Previous version of bootstrap index exists. Partition Index Path :" + this.indexByPartitionPath + ", FileId index Path :" + this.indexByFileIdPath;
                    LOG.info((Object)errMsg);
                    throw new HoodieException(errMsg);
                }
            }
            catch (IOException ioe) {
                throw new HoodieIOException(ioe.getMessage(), ioe);
            }
        }

        private void writeNextPartition(String partitionPath, String bootstrapPartitionPath, List<BootstrapFileMapping> bootstrapFileMappings) {
            try {
                LOG.info((Object)("Adding bootstrap partition Index entry for partition :" + partitionPath + ", bootstrap Partition :" + bootstrapPartitionPath + ", Num Entries :" + bootstrapFileMappings.size()));
                LOG.info((Object)("ADDING entries :" + bootstrapFileMappings));
                HoodieBootstrapPartitionMetadata bootstrapPartitionMetadata = new HoodieBootstrapPartitionMetadata();
                bootstrapPartitionMetadata.setBootstrapPartitionPath(bootstrapPartitionPath);
                bootstrapPartitionMetadata.setPartitionPath(partitionPath);
                bootstrapPartitionMetadata.setFileIdToBootstrapFile(bootstrapFileMappings.stream().map(m -> Pair.of(m.getFileId(), m.getBootstrapFileStatus())).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
                Option<byte[]> bytes = TimelineMetadataUtils.serializeAvroMetadata(bootstrapPartitionMetadata, HoodieBootstrapPartitionMetadata.class);
                if (bytes.isPresent()) {
                    this.indexByPartitionWriter.append(new KeyValue(Bytes.toBytes(HFileBootstrapIndex.getPartitionKey(partitionPath)), new byte[0], new byte[0], Long.MAX_VALUE, KeyValue.Type.Put, bytes.get()));
                    ++this.numPartitionKeysAdded;
                }
            }
            catch (IOException e) {
                throw new HoodieIOException(e.getMessage(), e);
            }
        }

        private void writeNextSourceFileMapping(BootstrapFileMapping mapping) {
            try {
                HoodieBootstrapFilePartitionInfo srcFilePartitionInfo = new HoodieBootstrapFilePartitionInfo();
                srcFilePartitionInfo.setPartitionPath(mapping.getPartitionPath());
                srcFilePartitionInfo.setBootstrapPartitionPath(mapping.getBootstrapPartitionPath());
                srcFilePartitionInfo.setBootstrapFileStatus(mapping.getBootstrapFileStatus());
                KeyValue kv = new KeyValue(HFileBootstrapIndex.getFileGroupKey(mapping.getFileGroupId()).getBytes(), new byte[0], new byte[0], Long.MAX_VALUE, KeyValue.Type.Put, TimelineMetadataUtils.serializeAvroMetadata(srcFilePartitionInfo, HoodieBootstrapFilePartitionInfo.class).get());
                this.indexByFileIdWriter.append(kv);
                ++this.numFileIdKeysAdded;
            }
            catch (IOException e) {
                throw new HoodieIOException(e.getMessage(), e);
            }
        }

        private void commit() {
            try {
                if (!this.closed) {
                    HoodieBootstrapIndexInfo partitionIndexInfo = HoodieBootstrapIndexInfo.newBuilder().setCreatedTimestamp(new Date().getTime()).setNumKeys(this.numPartitionKeysAdded).setBootstrapBasePath(this.bootstrapBasePath).build();
                    LOG.info((Object)("Adding Partition FileInfo :" + partitionIndexInfo));
                    HoodieBootstrapIndexInfo fileIdIndexInfo = HoodieBootstrapIndexInfo.newBuilder().setCreatedTimestamp(new Date().getTime()).setNumKeys(this.numFileIdKeysAdded).setBootstrapBasePath(this.bootstrapBasePath).build();
                    LOG.info((Object)("Appending FileId FileInfo :" + fileIdIndexInfo));
                    this.indexByPartitionWriter.appendFileInfo(INDEX_INFO_KEY, TimelineMetadataUtils.serializeAvroMetadata(partitionIndexInfo, HoodieBootstrapIndexInfo.class).get());
                    this.indexByFileIdWriter.appendFileInfo(INDEX_INFO_KEY, TimelineMetadataUtils.serializeAvroMetadata(fileIdIndexInfo, HoodieBootstrapIndexInfo.class).get());
                    this.close();
                }
            }
            catch (IOException ioe) {
                throw new HoodieIOException(ioe.getMessage(), ioe);
            }
        }

        @Override
        public void close() {
            try {
                if (!this.closed) {
                    this.indexByPartitionWriter.close();
                    this.indexByFileIdWriter.close();
                    this.closed = true;
                }
            }
            catch (IOException ioe) {
                throw new HoodieIOException(ioe.getMessage(), ioe);
            }
        }

        @Override
        public void begin() {
            try {
                HFileContext meta = new HFileContextBuilder().withCellComparator(new HoodieKVComparator()).build();
                this.indexByPartitionWriter = HFile.getWriterFactory(this.metaClient.getHadoopConf(), new CacheConfig(this.metaClient.getHadoopConf())).withPath(this.metaClient.getFs(), this.indexByPartitionPath).withFileContext(meta).create();
                this.indexByFileIdWriter = HFile.getWriterFactory(this.metaClient.getHadoopConf(), new CacheConfig(this.metaClient.getHadoopConf())).withPath(this.metaClient.getFs(), this.indexByFileIdPath).withFileContext(meta).create();
            }
            catch (IOException ioe) {
                throw new HoodieIOException(ioe.getMessage(), ioe);
            }
        }

        @Override
        public void appendNextPartition(String partitionPath, List<BootstrapFileMapping> bootstrapFileMappings) {
            this.sourceFileMappings.put(partitionPath, bootstrapFileMappings);
        }

        @Override
        public void finish() {
            List<String> partitions = this.sourceFileMappings.keySet().stream().sorted().collect(Collectors.toList());
            partitions.forEach(p -> this.writeNextPartition((String)p, this.sourceFileMappings.get(p).get(0).getBootstrapPartitionPath(), this.sourceFileMappings.get(p)));
            this.sourceFileMappings.values().stream().flatMap(Collection::stream).sorted().forEach(this::writeNextSourceFileMapping);
            this.commit();
        }
    }

    public static class HFileBootstrapIndexReader
    extends BootstrapIndex.IndexReader {
        private final String bootstrapBasePath;
        private final String indexByPartitionPath;
        private final String indexByFileIdPath;
        private transient HFile.Reader indexByPartitionReader;
        private transient HFile.Reader indexByFileIdReader;
        private transient HoodieBootstrapIndexInfo bootstrapIndexInfo;

        public HFileBootstrapIndexReader(HoodieTableMetaClient metaClient) {
            super(metaClient);
            Path indexByPartitionPath = HFileBootstrapIndex.partitionIndexPath(metaClient);
            Path indexByFilePath = HFileBootstrapIndex.fileIdIndexPath(metaClient);
            this.indexByPartitionPath = indexByPartitionPath.toString();
            this.indexByFileIdPath = indexByFilePath.toString();
            this.initIndexInfo();
            this.bootstrapBasePath = this.bootstrapIndexInfo.getBootstrapBasePath();
            LOG.info((Object)("Loaded HFileBasedBootstrapIndex with source base path :" + this.bootstrapBasePath));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initIndexInfo() {
            HFileBootstrapIndexReader hFileBootstrapIndexReader = this;
            synchronized (hFileBootstrapIndexReader) {
                if (null == this.bootstrapIndexInfo) {
                    try {
                        this.bootstrapIndexInfo = this.fetchBootstrapIndexInfo();
                    }
                    catch (IOException ioe) {
                        throw new HoodieException(ioe.getMessage(), ioe);
                    }
                }
            }
        }

        private HoodieBootstrapIndexInfo fetchBootstrapIndexInfo() throws IOException {
            return TimelineMetadataUtils.deserializeAvroMetadata(this.partitionIndexReader().getHFileInfo().get(INDEX_INFO_KEY), HoodieBootstrapIndexInfo.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HFile.Reader partitionIndexReader() {
            if (null == this.indexByPartitionReader) {
                HFileBootstrapIndexReader hFileBootstrapIndexReader = this;
                synchronized (hFileBootstrapIndexReader) {
                    if (null == this.indexByPartitionReader) {
                        LOG.info((Object)("Opening partition index :" + this.indexByPartitionPath));
                        this.indexByPartitionReader = HFileBootstrapIndex.createReader(this.indexByPartitionPath, this.metaClient.getHadoopConf(), this.metaClient.getFs());
                    }
                }
            }
            return this.indexByPartitionReader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HFile.Reader fileIdIndexReader() {
            if (null == this.indexByFileIdReader) {
                HFileBootstrapIndexReader hFileBootstrapIndexReader = this;
                synchronized (hFileBootstrapIndexReader) {
                    if (null == this.indexByFileIdReader) {
                        LOG.info((Object)("Opening fileId index :" + this.indexByFileIdPath));
                        this.indexByFileIdReader = HFileBootstrapIndex.createReader(this.indexByFileIdPath, this.metaClient.getHadoopConf(), this.metaClient.getFs());
                    }
                }
            }
            return this.indexByFileIdReader;
        }

        @Override
        public List<String> getIndexedPartitionPaths() {
            try (HFileScanner scanner = this.partitionIndexReader().getScanner(true, false);){
                List<String> list = this.getAllKeys(scanner, x$0 -> HFileBootstrapIndex.getPartitionFromKey(x$0));
                return list;
            }
        }

        @Override
        public List<HoodieFileGroupId> getIndexedFileGroupIds() {
            try (HFileScanner scanner = this.fileIdIndexReader().getScanner(true, false);){
                List<HoodieFileGroupId> list = this.getAllKeys(scanner, x$0 -> HFileBootstrapIndex.getFileGroupFromKey(x$0));
                return list;
            }
        }

        private <T> List<T> getAllKeys(HFileScanner scanner, Function<String, T> converter) {
            ArrayList<T> keys = new ArrayList<T>();
            try {
                boolean available = scanner.seekTo();
                while (available) {
                    keys.add(converter.apply(HFileBootstrapIndex.getUserKeyFromCellKey(CellUtil.getCellKeyAsString(scanner.getCell()))));
                    available = scanner.next();
                }
            }
            catch (IOException ioe) {
                throw new HoodieIOException(ioe.getMessage(), ioe);
            }
            return keys;
        }

        @Override
        public List<BootstrapFileMapping> getSourceFileMappingForPartition(String partition) {
            try {
                HFileScanner scanner = this.partitionIndexReader().getScanner(true, false);
                KeyValue keyValue = new KeyValue(Bytes.toBytes(HFileBootstrapIndex.getPartitionKey(partition)), new byte[0], new byte[0], Long.MAX_VALUE, KeyValue.Type.Put, new byte[0]);
                if (scanner.seekTo(keyValue) == 0) {
                    ByteBuffer readValue = scanner.getValue();
                    byte[] valBytes = Bytes.toBytes(readValue);
                    HoodieBootstrapPartitionMetadata metadata = TimelineMetadataUtils.deserializeAvroMetadata(valBytes, HoodieBootstrapPartitionMetadata.class);
                    return metadata.getFileIdToBootstrapFile().entrySet().stream().map(e -> new BootstrapFileMapping(this.bootstrapBasePath, metadata.getBootstrapPartitionPath(), partition, (HoodieFileStatus)e.getValue(), (String)e.getKey())).collect(Collectors.toList());
                }
                LOG.warn((Object)("No value found for partition key (" + partition + ")"));
                return new ArrayList<BootstrapFileMapping>();
            }
            catch (IOException ioe) {
                throw new HoodieIOException(ioe.getMessage(), ioe);
            }
        }

        @Override
        public String getBootstrapBasePath() {
            return this.bootstrapBasePath;
        }

        @Override
        public Map<HoodieFileGroupId, BootstrapFileMapping> getSourceFileMappingForFileIds(List<HoodieFileGroupId> ids) {
            HashMap<HoodieFileGroupId, BootstrapFileMapping> result = new HashMap<HoodieFileGroupId, BootstrapFileMapping>();
            ArrayList<HoodieFileGroupId> fileGroupIds = new ArrayList<HoodieFileGroupId>(ids);
            Collections.sort(fileGroupIds);
            try {
                HFileScanner scanner = this.fileIdIndexReader().getScanner(true, false);
                for (HoodieFileGroupId fileGroupId : fileGroupIds) {
                    KeyValue keyValue = new KeyValue(Bytes.toBytes(HFileBootstrapIndex.getFileGroupKey(fileGroupId)), new byte[0], new byte[0], Long.MAX_VALUE, KeyValue.Type.Put, new byte[0]);
                    if (scanner.seekTo(keyValue) != 0) continue;
                    ByteBuffer readValue = scanner.getValue();
                    byte[] valBytes = Bytes.toBytes(readValue);
                    HoodieBootstrapFilePartitionInfo fileInfo = TimelineMetadataUtils.deserializeAvroMetadata(valBytes, HoodieBootstrapFilePartitionInfo.class);
                    BootstrapFileMapping mapping = new BootstrapFileMapping(this.bootstrapBasePath, fileInfo.getBootstrapPartitionPath(), fileInfo.getPartitionPath(), fileInfo.getBootstrapFileStatus(), fileGroupId.getFileId());
                    result.put(fileGroupId, mapping);
                }
            }
            catch (IOException ioe) {
                throw new HoodieIOException(ioe.getMessage(), ioe);
            }
            return result;
        }

        @Override
        public void close() {
            try {
                if (this.indexByPartitionReader != null) {
                    this.indexByPartitionReader.close(true);
                    this.indexByPartitionReader = null;
                }
                if (this.indexByFileIdReader != null) {
                    this.indexByFileIdReader.close(true);
                    this.indexByFileIdReader = null;
                }
            }
            catch (IOException ioe) {
                throw new HoodieIOException(ioe.getMessage(), ioe);
            }
        }
    }
}

