/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model.debezium;

import io.hops.hudi.org.apache.avro.Schema;
import io.hops.hudi.org.apache.avro.generic.GenericRecord;
import io.hops.hudi.org.apache.avro.generic.IndexedRecord;
import java.io.IOException;
import java.util.Objects;
import org.apache.hudi.common.model.debezium.AbstractDebeziumAvroPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieDebeziumAvroPayloadException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MySqlDebeziumAvroPayload
extends AbstractDebeziumAvroPayload {
    private static final Logger LOG = LogManager.getLogger(MySqlDebeziumAvroPayload.class);

    public MySqlDebeziumAvroPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public MySqlDebeziumAvroPayload(Option<GenericRecord> record) {
        super(record);
    }

    private Option<String> extractSeq(IndexedRecord record) {
        Object value = ((GenericRecord)record).get("_event_seq");
        return Option.ofNullable(Objects.toString(value, null));
    }

    @Override
    protected boolean shouldPickCurrentRecord(IndexedRecord currentRecord, IndexedRecord insertRecord, Schema schema) throws IOException {
        String insertSourceSeq = this.extractSeq(insertRecord).orElseThrow(() -> new HoodieDebeziumAvroPayloadException(String.format("%s cannot be null in insert record: %s", "_event_seq", insertRecord)));
        Option<String> currentSourceSeqOpt = this.extractSeq(currentRecord);
        return currentSourceSeqOpt.isPresent() && insertSourceSeq.compareTo(currentSourceSeqOpt.get()) < 0;
    }
}

