/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import io.hops.hudi.org.apache.avro.Schema;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.collection.Pair;

public class LogReaderUtils {
    private static Schema readSchemaFromLogFileInReverse(FileSystem fs, HoodieActiveTimeline activeTimeline, HoodieLogFile hoodieLogFile) throws IOException {
        HoodieLogFormat.Reader reader = HoodieLogFormat.newReader(fs, hoodieLogFile, null, true, true);
        Schema writerSchema = null;
        HoodieTimeline completedTimeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        while (reader.hasPrev()) {
            HoodieDataBlock lastBlock;
            HoodieLogBlock block = reader.prev();
            if (!(block instanceof HoodieDataBlock) || !completedTimeline.containsOrBeforeTimelineStarts((lastBlock = (HoodieDataBlock)block).getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME))) continue;
            writerSchema = new Schema.Parser().parse(lastBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
            break;
        }
        reader.close();
        return writerSchema;
    }

    public static Schema readLatestSchemaFromLogFiles(String basePath, List<HoodieLogFile> logFiles, Configuration config) throws IOException {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(config).setBasePath(basePath).build();
        List deltaPaths = logFiles.stream().sorted(HoodieLogFile.getReverseLogFileComparator()).map(s -> s.getPath().toString()).collect(Collectors.toList());
        if (deltaPaths.size() > 0) {
            Map<String, HoodieLogFile> deltaFilePathToFileStatus = logFiles.stream().map(entry -> Pair.of(entry.getPath().toString(), entry)).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            for (String logPath : deltaPaths) {
                FileSystem fs = FSUtils.getFs(logPath, config);
                Schema schemaFromLogFile = LogReaderUtils.readSchemaFromLogFileInReverse(fs, metaClient.getActiveTimeline(), deltaFilePathToFileStatus.get(logPath));
                if (schemaFromLogFile == null) continue;
                return schemaFromLogFile;
            }
        }
        return null;
    }
}

