/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.hudi.internal.schema.Types;

public interface Type
extends Serializable {
    public static TypeID fromValue(String value) {
        try {
            return TypeID.valueOf(value.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid value of Type: %s", value));
        }
    }

    public TypeID typeId();

    default public boolean isNestedType() {
        return false;
    }

    public static abstract class NestedType
    implements Type {
        @Override
        public boolean isNestedType() {
            return true;
        }

        public abstract List<Types.Field> fields();

        public abstract Type fieldType(String var1);

        public abstract Types.Field field(int var1);
    }

    public static abstract class PrimitiveType
    implements Type {
        @Override
        public boolean isNestedType() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PrimitiveType)) {
                return false;
            }
            PrimitiveType that = (PrimitiveType)o;
            return this.typeId().equals((Object)that.typeId());
        }

        public int hashCode() {
            return Objects.hashCode((Object)this.typeId());
        }
    }

    public static enum TypeID {
        RECORD,
        ARRAY,
        MAP,
        FIXED,
        STRING,
        BINARY,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        DATE,
        BOOLEAN,
        TIME,
        TIMESTAMP,
        DECIMAL,
        UUID;

        private String name = this.name().toLowerCase(Locale.ROOT);

        public String getName() {
            return this.name;
        }
    }
}

