/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.avro;

import io.hops.hudi.org.apache.avro.AvroRuntimeException;
import io.hops.hudi.org.apache.avro.SchemaValidationStrategy;
import io.hops.hudi.org.apache.avro.SchemaValidator;
import io.hops.hudi.org.apache.avro.ValidateAll;
import io.hops.hudi.org.apache.avro.ValidateCanBeRead;
import io.hops.hudi.org.apache.avro.ValidateCanRead;
import io.hops.hudi.org.apache.avro.ValidateLatest;
import io.hops.hudi.org.apache.avro.ValidateMutualRead;

public final class SchemaValidatorBuilder {
    private SchemaValidationStrategy strategy;

    public SchemaValidatorBuilder strategy(SchemaValidationStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public SchemaValidatorBuilder canReadStrategy() {
        this.strategy = new ValidateCanRead();
        return this;
    }

    public SchemaValidatorBuilder canBeReadStrategy() {
        this.strategy = new ValidateCanBeRead();
        return this;
    }

    public SchemaValidatorBuilder mutualReadStrategy() {
        this.strategy = new ValidateMutualRead();
        return this;
    }

    public SchemaValidator validateLatest() {
        this.valid();
        return new ValidateLatest(this.strategy);
    }

    public SchemaValidator validateAll() {
        this.valid();
        return new ValidateAll(this.strategy);
    }

    private void valid() {
        if (null == this.strategy) {
            throw new AvroRuntimeException("SchemaValidationStrategy not specified in builder");
        }
    }
}

