/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.http.client.fluent;

import io.hops.hudi.org.apache.http.Consts;
import io.hops.hudi.org.apache.http.entity.ContentType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;

public class Content {
    public static final Content NO_CONTENT = new Content(new byte[0], ContentType.DEFAULT_BINARY);
    private final byte[] raw;
    private final ContentType type;

    public Content(byte[] raw, ContentType type) {
        this.raw = raw;
        this.type = type;
    }

    public ContentType getType() {
        return this.type;
    }

    public byte[] asBytes() {
        return (byte[])this.raw.clone();
    }

    public String asString() {
        Charset charset = this.type.getCharset();
        if (charset == null) {
            charset = Consts.ISO_8859_1;
        }
        return this.asString(charset);
    }

    public String asString(Charset charset) {
        return new String(this.raw, charset);
    }

    public InputStream asStream() {
        return new ByteArrayInputStream(this.raw);
    }

    public String toString() {
        return this.asString();
    }
}

