/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.unsafe.HBasePlatformDependent;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class FuzzyRowFilter
extends FilterBase {
    private static final boolean UNSAFE_UNALIGNED = HBasePlatformDependent.unaligned();
    static final byte V1_PROCESSED_WILDCARD_MASK = 0;
    static final byte V2_PROCESSED_WILDCARD_MASK = 2;
    private final byte processedWildcardMask;
    private List<Pair<byte[], byte[]>> fuzzyKeysData;
    private boolean done = false;
    private int lastFoundIndex = -1;
    private RowTracker tracker;

    public FuzzyRowFilter(List<Pair<byte[], byte[]>> fuzzyKeysData) {
        this(fuzzyKeysData, 2);
    }

    FuzzyRowFilter(List<Pair<byte[], byte[]>> fuzzyKeysData, byte processedWildcardMask) {
        this.processedWildcardMask = processedWildcardMask;
        ArrayList<Pair<byte[], byte[]>> fuzzyKeyDataCopy = new ArrayList<Pair<byte[], byte[]>>(fuzzyKeysData.size());
        for (Pair<byte[], byte[]> aFuzzyKeysData : fuzzyKeysData) {
            if (aFuzzyKeysData.getFirst().length != aFuzzyKeysData.getSecond().length) {
                Pair<String, String> readable = new Pair<String, String>(Bytes.toStringBinary(aFuzzyKeysData.getFirst()), Bytes.toStringBinary(aFuzzyKeysData.getSecond()));
                throw new IllegalArgumentException("Fuzzy pair lengths do not match: " + readable);
            }
            Pair<byte[], byte[]> p = new Pair<byte[], byte[]>();
            p.setFirst(Arrays.copyOf(aFuzzyKeysData.getFirst(), aFuzzyKeysData.getFirst().length));
            p.setSecond(Arrays.copyOf(aFuzzyKeysData.getSecond(), aFuzzyKeysData.getSecond().length));
            p.setSecond(this.preprocessMask((byte[])p.getSecond()));
            this.preprocessSearchKey(p);
            fuzzyKeyDataCopy.add(p);
        }
        this.fuzzyKeysData = fuzzyKeyDataCopy;
        this.tracker = new RowTracker();
    }

    private void preprocessSearchKey(Pair<byte[], byte[]> p) {
        if (!UNSAFE_UNALIGNED) {
            return;
        }
        byte[] key = p.getFirst();
        byte[] mask = p.getSecond();
        for (int i = 0; i < mask.length; ++i) {
            if (mask[i] != this.processedWildcardMask) continue;
            key[i] = 0;
        }
    }

    private byte[] preprocessMask(byte[] mask) {
        if (!UNSAFE_UNALIGNED) {
            return mask;
        }
        if (this.isPreprocessedMask(mask)) {
            return mask;
        }
        for (int i = 0; i < mask.length; ++i) {
            if (mask[i] == 0) {
                mask[i] = -1;
                continue;
            }
            if (mask[i] != 1) continue;
            mask[i] = this.processedWildcardMask;
        }
        return mask;
    }

    private boolean isPreprocessedMask(byte[] mask) {
        for (int i = 0; i < mask.length; ++i) {
            if (mask[i] == -1 || mask[i] == this.processedWildcardMask) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public Filter.ReturnCode filterKeyValue(Cell c) {
        return this.filterCell(c);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell c) {
        int startIndex = this.lastFoundIndex >= 0 ? this.lastFoundIndex : 0;
        int size = this.fuzzyKeysData.size();
        for (int i = startIndex; i < size + startIndex; ++i) {
            int index = i % size;
            Pair<byte[], byte[]> fuzzyData = this.fuzzyKeysData.get(index);
            FuzzyRowFilter.idempotentMaskShift(fuzzyData.getSecond());
            SatisfiesCode satisfiesCode = FuzzyRowFilter.satisfies(this.isReversed(), c.getRowArray(), c.getRowOffset(), c.getRowLength(), fuzzyData.getFirst(), fuzzyData.getSecond());
            if (satisfiesCode != SatisfiesCode.YES) continue;
            this.lastFoundIndex = index;
            return Filter.ReturnCode.INCLUDE;
        }
        this.lastFoundIndex = -1;
        return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
    }

    static void idempotentMaskShift(byte[] mask) {
        int j = 0;
        while (j < mask.length) {
            int n = j++;
            mask[n] = (byte)(mask[n] >> 2);
        }
    }

    @Override
    public Cell getNextCellHint(Cell currentCell) {
        boolean result = this.tracker.updateTracker(currentCell);
        if (!result) {
            this.done = true;
            return null;
        }
        byte[] nextRowKey = this.tracker.nextRow();
        return PrivateCellUtil.createFirstOnRow(nextRowKey, 0, (short)nextRowKey.length);
    }

    @Override
    public boolean filterAllRemaining() {
        return this.done;
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.FuzzyRowFilter.Builder builder = FilterProtos.FuzzyRowFilter.newBuilder().setIsMaskV2(this.processedWildcardMask == 2);
        for (Pair<byte[], byte[]> fuzzyData : this.fuzzyKeysData) {
            HBaseProtos.BytesBytesPair.Builder bbpBuilder = HBaseProtos.BytesBytesPair.newBuilder();
            bbpBuilder.setFirst(UnsafeByteOperations.unsafeWrap(fuzzyData.getFirst()));
            bbpBuilder.setSecond(UnsafeByteOperations.unsafeWrap(fuzzyData.getSecond()));
            builder.addFuzzyKeysData(bbpBuilder);
        }
        return builder.build().toByteArray();
    }

    public static FuzzyRowFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.FuzzyRowFilter proto;
        try {
            proto = FilterProtos.FuzzyRowFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        int count = proto.getFuzzyKeysDataCount();
        ArrayList<Pair<byte[], byte[]>> fuzzyKeysData = new ArrayList<Pair<byte[], byte[]>>(count);
        for (int i = 0; i < count; ++i) {
            HBaseProtos.BytesBytesPair current = proto.getFuzzyKeysData(i);
            byte[] keyBytes = current.getFirst().toByteArray();
            byte[] keyMeta = current.getSecond().toByteArray();
            fuzzyKeysData.add(new Pair<byte[], byte[]>(keyBytes, keyMeta));
        }
        byte processedWildcardMask = proto.hasIsMaskV2() && proto.getIsMaskV2() ? (byte)2 : 0;
        return new FuzzyRowFilter(fuzzyKeysData, processedWildcardMask);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FuzzyRowFilter");
        sb.append("{fuzzyKeysData=");
        for (Pair<byte[], byte[]> fuzzyData : this.fuzzyKeysData) {
            sb.append('{').append(Bytes.toStringBinary(fuzzyData.getFirst())).append(":");
            sb.append(Bytes.toStringBinary(fuzzyData.getSecond())).append('}');
        }
        sb.append("}, ");
        return sb.toString();
    }

    @InterfaceAudience.Private
    static SatisfiesCode satisfies(byte[] row, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        return FuzzyRowFilter.satisfies(false, row, 0, row.length, fuzzyKeyBytes, fuzzyKeyMeta);
    }

    @InterfaceAudience.Private
    static SatisfiesCode satisfies(boolean reverse, byte[] row, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        return FuzzyRowFilter.satisfies(reverse, row, 0, row.length, fuzzyKeyBytes, fuzzyKeyMeta);
    }

    static SatisfiesCode satisfies(boolean reverse, byte[] row, int offset, int length, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        int fuzzyBytes;
        int rowValue;
        int fuzzyMeta;
        if (!UNSAFE_UNALIGNED) {
            return FuzzyRowFilter.satisfiesNoUnsafe(reverse, row, offset, length, fuzzyKeyBytes, fuzzyKeyMeta);
        }
        if (row == null) {
            return SatisfiesCode.YES;
        }
        length = Math.min(length, fuzzyKeyBytes.length);
        int numWords = length / 8;
        int j = numWords << 3;
        for (int i = 0; i < j; i += 8) {
            long fuzzyBytes2 = Bytes.toLong(fuzzyKeyBytes, i);
            long fuzzyMeta2 = Bytes.toLong(fuzzyKeyMeta, i);
            long rowValue2 = Bytes.toLong(row, offset + i);
            if ((rowValue2 & fuzzyMeta2) == fuzzyBytes2) continue;
            return SatisfiesCode.NEXT_EXISTS;
        }
        int off = j;
        if (length - off >= 4) {
            int fuzzyBytes3 = Bytes.toInt(fuzzyKeyBytes, off);
            fuzzyMeta = Bytes.toInt(fuzzyKeyMeta, off);
            int rowValue3 = Bytes.toInt(row, offset + off);
            if ((rowValue3 & fuzzyMeta) != fuzzyBytes3) {
                return SatisfiesCode.NEXT_EXISTS;
            }
            off += 4;
        }
        if (length - off >= 2) {
            short fuzzyBytes4 = Bytes.toShort(fuzzyKeyBytes, off);
            fuzzyMeta = Bytes.toShort(fuzzyKeyMeta, off);
            short rowValue4 = Bytes.toShort(row, offset + off);
            if ((rowValue4 & fuzzyMeta) != fuzzyBytes4) {
                return SatisfiesCode.NEXT_EXISTS;
            }
            off += 2;
        }
        if (length - off >= 1 && ((rowValue = row[offset + off] & 0xFF) & (fuzzyMeta = fuzzyKeyMeta[off] & 0xFF)) != (fuzzyBytes = fuzzyKeyBytes[off] & 0xFF)) {
            return SatisfiesCode.NEXT_EXISTS;
        }
        return SatisfiesCode.YES;
    }

    static SatisfiesCode satisfiesNoUnsafe(boolean reverse, byte[] row, int offset, int length, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        if (row == null) {
            return SatisfiesCode.YES;
        }
        Order order = Order.orderFor(reverse);
        boolean nextRowKeyCandidateExists = false;
        for (int i = 0; i < fuzzyKeyMeta.length && i < length; ++i) {
            boolean fixedByteIncorrect;
            boolean byteAtPositionFixed = fuzzyKeyMeta[i] == 0;
            boolean bl = fixedByteIncorrect = byteAtPositionFixed && fuzzyKeyBytes[i] != row[i + offset];
            if (fixedByteIncorrect) {
                boolean rowByteLessThanFixed;
                if (nextRowKeyCandidateExists) {
                    return SatisfiesCode.NEXT_EXISTS;
                }
                boolean bl2 = rowByteLessThanFixed = (row[i + offset] & 0xFF) < (fuzzyKeyBytes[i] & 0xFF);
                if (rowByteLessThanFixed && !reverse) {
                    return SatisfiesCode.NEXT_EXISTS;
                }
                if (!rowByteLessThanFixed && reverse) {
                    return SatisfiesCode.NEXT_EXISTS;
                }
                return SatisfiesCode.NO_NEXT;
            }
            if (fuzzyKeyMeta[i] != 1 || order.isMax(fuzzyKeyBytes[i])) continue;
            nextRowKeyCandidateExists = true;
        }
        return SatisfiesCode.YES;
    }

    @InterfaceAudience.Private
    static byte[] getNextForFuzzyRule(byte[] row, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        return FuzzyRowFilter.getNextForFuzzyRule(false, row, 0, row.length, fuzzyKeyBytes, fuzzyKeyMeta);
    }

    @InterfaceAudience.Private
    static byte[] getNextForFuzzyRule(boolean reverse, byte[] row, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        return FuzzyRowFilter.getNextForFuzzyRule(reverse, row, 0, row.length, fuzzyKeyBytes, fuzzyKeyMeta);
    }

    @InterfaceAudience.Private
    static byte[] getNextForFuzzyRule(boolean reverse, byte[] row, int offset, int length, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        int i;
        byte[] result = Arrays.copyOf(fuzzyKeyBytes, length > fuzzyKeyBytes.length ? length : fuzzyKeyBytes.length);
        if (reverse && length > fuzzyKeyBytes.length) {
            for (int i2 = fuzzyKeyBytes.length; i2 < result.length; ++i2) {
                result[i2] = -1;
            }
        }
        int toInc = -1;
        Order order = Order.orderFor(reverse);
        boolean increased = false;
        for (i = 0; i < result.length; ++i) {
            if (i >= fuzzyKeyMeta.length || fuzzyKeyMeta[i] == 0) {
                result[i] = row[offset + i];
                if (order.isMax(row[offset + i])) continue;
                toInc = i;
                continue;
            }
            if (i >= fuzzyKeyMeta.length || fuzzyKeyMeta[i] != -1) continue;
            if (order.lt(row[i + offset] & 0xFF, fuzzyKeyBytes[i] & 0xFF)) {
                increased = true;
                break;
            }
            if (order.gt(row[i + offset] & 0xFF, fuzzyKeyBytes[i] & 0xFF)) break;
        }
        if (!increased) {
            if (toInc < 0) {
                return null;
            }
            result[toInc] = order.inc(result[toInc]);
            for (i = toInc + 1; i < result.length; ++i) {
                if (i < fuzzyKeyMeta.length && fuzzyKeyMeta[i] != 0) continue;
                result[i] = order.min();
            }
        }
        return reverse ? result : FuzzyRowFilter.trimTrailingZeroes(result, fuzzyKeyMeta, toInc);
    }

    private static byte[] trimTrailingZeroes(byte[] result, byte[] fuzzyKeyMeta, int toInc) {
        int off;
        int n = off = fuzzyKeyMeta.length >= result.length ? result.length - 1 : fuzzyKeyMeta.length - 1;
        while (off >= 0 && fuzzyKeyMeta[off] == 0) {
            --off;
        }
        if (off < toInc) {
            off = toInc;
        }
        byte[] retValue = new byte[off + 1];
        System.arraycopy(result, 0, retValue, 0, retValue.length);
        return retValue;
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FuzzyRowFilter)) {
            return false;
        }
        FuzzyRowFilter other = (FuzzyRowFilter)o;
        if (this.fuzzyKeysData.size() != other.fuzzyKeysData.size()) {
            return false;
        }
        for (int i = 0; i < this.fuzzyKeysData.size(); ++i) {
            Pair<byte[], byte[]> thisData = this.fuzzyKeysData.get(i);
            Pair<byte[], byte[]> otherData = other.fuzzyKeysData.get(i);
            if (Bytes.equals(thisData.getFirst(), otherData.getFirst()) && Bytes.equals(thisData.getSecond(), otherData.getSecond())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    public int hashCode() {
        return Objects.hash(this.fuzzyKeysData);
    }

    private static enum Order {
        ASC{

            @Override
            public boolean lt(int lhs, int rhs) {
                return lhs < rhs;
            }

            @Override
            public boolean gt(int lhs, int rhs) {
                return lhs > rhs;
            }

            @Override
            public byte inc(byte val) {
                return (byte)(val + 1);
            }

            @Override
            public boolean isMax(byte val) {
                return val == -1;
            }

            @Override
            public byte min() {
                return 0;
            }
        }
        ,
        DESC{

            @Override
            public boolean lt(int lhs, int rhs) {
                return lhs > rhs;
            }

            @Override
            public boolean gt(int lhs, int rhs) {
                return lhs < rhs;
            }

            @Override
            public byte inc(byte val) {
                return (byte)(val - 1);
            }

            @Override
            public boolean isMax(byte val) {
                return val == 0;
            }

            @Override
            public byte min() {
                return -1;
            }
        };


        public static Order orderFor(boolean reverse) {
            return reverse ? DESC : ASC;
        }

        public abstract boolean lt(int var1, int var2);

        public abstract boolean gt(int var1, int var2);

        public abstract byte inc(byte var1);

        public abstract boolean isMax(byte var1);

        public abstract byte min();
    }

    static enum SatisfiesCode {
        YES,
        NEXT_EXISTS,
        NO_NEXT;

    }

    private class RowTracker {
        private final PriorityQueue<Pair<byte[], Pair<byte[], byte[]>>> nextRows;
        private boolean initialized = false;

        RowTracker() {
            this.nextRows = new PriorityQueue<Pair<byte[], Pair<byte[], byte[]>>>(FuzzyRowFilter.this.fuzzyKeysData.size(), new Comparator<Pair<byte[], Pair<byte[], byte[]>>>(){

                @Override
                public int compare(Pair<byte[], Pair<byte[], byte[]>> o1, Pair<byte[], Pair<byte[], byte[]>> o2) {
                    return FuzzyRowFilter.this.isReversed() ? Bytes.compareTo(o2.getFirst(), o1.getFirst()) : Bytes.compareTo(o1.getFirst(), o2.getFirst());
                }
            });
        }

        byte[] nextRow() {
            if (this.nextRows.isEmpty()) {
                throw new IllegalStateException("NextRows should not be empty, make sure to call nextRow() after updateTracker() return true");
            }
            return this.nextRows.peek().getFirst();
        }

        boolean updateTracker(Cell currentCell) {
            if (!this.initialized) {
                for (Pair fuzzyData : FuzzyRowFilter.this.fuzzyKeysData) {
                    this.updateWith(currentCell, fuzzyData);
                }
                this.initialized = true;
            } else {
                while (!this.nextRows.isEmpty() && !this.lessThan(currentCell, this.nextRows.peek().getFirst())) {
                    Pair<byte[], Pair<byte[], byte[]>> head = this.nextRows.poll();
                    Pair<byte[], byte[]> fuzzyData = head.getSecond();
                    this.updateWith(currentCell, fuzzyData);
                }
            }
            return !this.nextRows.isEmpty();
        }

        boolean lessThan(Cell currentCell, byte[] nextRowKey) {
            int compareResult = CellComparator.getInstance().compareRows(currentCell, nextRowKey, 0, nextRowKey.length);
            return !FuzzyRowFilter.this.isReversed() && compareResult < 0 || FuzzyRowFilter.this.isReversed() && compareResult > 0;
        }

        void updateWith(Cell currentCell, Pair<byte[], byte[]> fuzzyData) {
            byte[] nextRowKeyCandidate = FuzzyRowFilter.getNextForFuzzyRule(FuzzyRowFilter.this.isReversed(), currentCell.getRowArray(), currentCell.getRowOffset(), currentCell.getRowLength(), fuzzyData.getFirst(), fuzzyData.getSecond());
            if (nextRowKeyCandidate != null) {
                this.nextRows.add(new Pair<byte[], Pair<byte[], byte[]>>(nextRowKeyCandidate, fuzzyData));
            }
        }
    }
}

