/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class RegionNormalizerWorkQueue<E> {
    private LinkedHashSet<E> delegate = new LinkedHashSet();
    private final ReentrantLock takeLock = new ReentrantLock();
    private final Condition notEmpty = this.takeLock.newCondition();
    private final ReentrantLock putLock = new ReentrantLock();

    RegionNormalizerWorkQueue() {
    }

    private void signalNotEmpty() {
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            takeLock.unlock();
        }
    }

    private void fullyLock() {
        this.putLock.lock();
        this.takeLock.lock();
    }

    private void fullyUnlock() {
        this.takeLock.unlock();
        this.putLock.unlock();
    }

    public void put(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.putLock.lock();
        try {
            this.delegate.add(e);
        }
        finally {
            this.putLock.unlock();
        }
        if (!this.delegate.isEmpty()) {
            this.signalNotEmpty();
        }
    }

    public void putFirst(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.putAllFirst(Collections.singleton(e));
    }

    public void putAll(Collection<? extends E> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.putLock.lock();
        try {
            this.delegate.addAll(c);
        }
        finally {
            this.putLock.unlock();
        }
        if (!this.delegate.isEmpty()) {
            this.signalNotEmpty();
        }
    }

    public void putAllFirst(Collection<? extends E> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.fullyLock();
        try {
            LinkedHashSet<E> copy = new LinkedHashSet<E>(c.size() + this.delegate.size());
            copy.addAll(c);
            copy.addAll(this.delegate);
            this.delegate = copy;
        }
        finally {
            this.fullyUnlock();
        }
        if (!this.delegate.isEmpty()) {
            this.signalNotEmpty();
        }
    }

    public E take() throws InterruptedException {
        Object x;
        this.takeLock.lockInterruptibly();
        try {
            while (this.delegate.isEmpty()) {
                this.notEmpty.await();
            }
            Iterator iter = this.delegate.iterator();
            x = iter.next();
            iter.remove();
            if (!this.delegate.isEmpty()) {
                this.notEmpty.signal();
            }
        }
        finally {
            this.takeLock.unlock();
        }
        return x;
    }

    public void clear() {
        this.putLock.lock();
        try {
            this.delegate.clear();
        }
        finally {
            this.putLock.unlock();
        }
    }

    public int size() {
        this.takeLock.lock();
        try {
            int n = this.delegate.size();
            return n;
        }
        finally {
            this.takeLock.unlock();
        }
    }

    public String toString() {
        this.takeLock.lock();
        try {
            String string = this.delegate.toString();
            return string;
        }
        finally {
            this.takeLock.unlock();
        }
    }
}

