/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.nio;

import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.nio.HBaseReferenceCounted;
import org.apache.hadoop.hbase.nio.MultiByteBuff;
import org.apache.hadoop.hbase.nio.RefCnt;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ObjectIntPair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class ByteBuff
implements HBaseReferenceCounted {
    private static final String REFERENCE_COUNT_NAME = "ReferenceCount";
    private static final int NIO_BUFFER_LIMIT = 65536;
    protected RefCnt refCnt;
    static final ChannelReader CHANNEL_READER = (channel, buf, offset) -> channel.read(buf);
    static final ChannelReader FILE_READER = (channel, buf, offset) -> ((FileChannel)channel).read(buf, offset);

    protected void checkRefCount() {
        ObjectUtil.checkPositive(this.refCnt(), REFERENCE_COUNT_NAME);
    }

    @Override
    public int refCnt() {
        return this.refCnt.refCnt();
    }

    @Override
    public boolean release() {
        return this.refCnt.release();
    }

    public abstract int position();

    public abstract ByteBuff position(int var1);

    public abstract ByteBuff skip(int var1);

    public abstract ByteBuff moveBack(int var1);

    public abstract int capacity();

    public abstract int limit();

    public abstract ByteBuff limit(int var1);

    public abstract ByteBuff rewind();

    public abstract ByteBuff mark();

    public abstract ByteBuffer asSubByteBuffer(int var1);

    public abstract void asSubByteBuffer(int var1, int var2, ObjectIntPair<ByteBuffer> var3);

    public abstract int remaining();

    public abstract boolean hasRemaining();

    public abstract ByteBuff reset();

    public abstract ByteBuff slice();

    public abstract ByteBuff duplicate();

    public abstract byte get();

    public abstract byte get(int var1);

    public abstract byte getByteAfterPosition(int var1);

    public abstract ByteBuff put(byte var1);

    public abstract ByteBuff put(int var1, byte var2);

    public abstract void get(byte[] var1, int var2, int var3);

    public abstract void get(int var1, byte[] var2, int var3, int var4);

    public abstract void get(byte[] var1);

    public abstract ByteBuff put(byte[] var1, int var2, int var3);

    public abstract ByteBuff put(byte[] var1);

    public abstract boolean hasArray();

    public abstract byte[] array();

    public abstract int arrayOffset();

    public abstract short getShort();

    public abstract short getShort(int var1);

    public abstract short getShortAfterPosition(int var1);

    public abstract int getInt();

    public abstract ByteBuff putInt(int var1);

    public abstract int getInt(int var1);

    public abstract int getIntAfterPosition(int var1);

    public abstract long getLong();

    public abstract ByteBuff putLong(long var1);

    public abstract long getLong(int var1);

    public abstract long getLongAfterPosition(int var1);

    public byte[] toBytes() {
        return this.toBytes(0, this.limit());
    }

    public abstract byte[] toBytes(int var1, int var2);

    public abstract void get(ByteBuffer var1, int var2, int var3);

    public abstract ByteBuff put(int var1, ByteBuff var2, int var3, int var4);

    public abstract int read(ReadableByteChannel var1) throws IOException;

    public abstract int read(FileChannel var1, long var2) throws IOException;

    public abstract int write(FileChannel var1, long var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int read(ReadableByteChannel channel, ByteBuffer buf, long offset, ChannelReader reader) throws IOException {
        int nBytes;
        if (buf.remaining() <= 65536) {
            return reader.read(channel, buf, offset);
        }
        int originalLimit = buf.limit();
        int initialRemaining = buf.remaining();
        int ret = 0;
        while (buf.remaining() > 0) {
            try {
                int ioSize = Math.min(buf.remaining(), 65536);
                buf.limit(buf.position() + ioSize);
                if ((ret = reader.read(channel, buf, offset += (long)ret)) >= ioSize) continue;
                break;
            }
            finally {
                buf.limit(originalLimit);
            }
        }
        return (nBytes = initialRemaining - buf.remaining()) > 0 ? nBytes : ret;
    }

    public static int readCompressedInt(ByteBuff buf) {
        byte b = buf.get();
        if ((b & 0x80) != 0) {
            return (b & 0x7F) + (ByteBuff.readCompressedInt(buf) << 7);
        }
        return b & 0x7F;
    }

    public static int compareTo(ByteBuff buf1, int o1, int len1, ByteBuff buf2, int o2, int len2) {
        if (buf1.hasArray() && buf2.hasArray()) {
            return Bytes.compareTo(buf1.array(), buf1.arrayOffset() + o1, len1, buf2.array(), buf2.arrayOffset() + o2, len2);
        }
        int end1 = o1 + len1;
        int end2 = o2 + len2;
        int i = o1;
        for (int j = o2; i < end1 && j < end2; ++i, ++j) {
            int b;
            int a = buf1.get(i) & 0xFF;
            if (a == (b = buf2.get(j) & 0xFF)) continue;
            return a - b;
        }
        return len1 - len2;
    }

    public static long readLong(ByteBuff in, int fitInBytes) {
        long tmpLength = 0L;
        for (int i = 0; i < fitInBytes; ++i) {
            tmpLength |= ((long)in.get() & 0xFFL) << (int)(8L * (long)i);
        }
        return tmpLength;
    }

    public abstract ByteBuffer[] nioByteBuffers();

    public String toString() {
        return this.getClass().getSimpleName() + "[pos=" + this.position() + ", lim=" + this.limit() + ", cap= " + this.capacity() + "]";
    }

    public static ByteBuff wrap(ByteBuffer[] buffers, RefCnt refCnt) {
        if (buffers == null || buffers.length == 0) {
            throw new IllegalArgumentException("buffers shouldn't be null or empty");
        }
        return buffers.length == 1 ? new SingleByteBuff(refCnt, buffers[0]) : new MultiByteBuff(refCnt, buffers);
    }

    public static ByteBuff wrap(ByteBuffer[] buffers, ByteBuffAllocator.Recycler recycler) {
        return ByteBuff.wrap(buffers, RefCnt.create(recycler));
    }

    public static ByteBuff wrap(ByteBuffer[] buffers) {
        return ByteBuff.wrap(buffers, RefCnt.create());
    }

    public static ByteBuff wrap(List<ByteBuffer> buffers, ByteBuffAllocator.Recycler recycler) {
        return ByteBuff.wrap(buffers, RefCnt.create(recycler));
    }

    public static ByteBuff wrap(List<ByteBuffer> buffers) {
        return ByteBuff.wrap(buffers, RefCnt.create());
    }

    public static ByteBuff wrap(ByteBuffer buffer) {
        return ByteBuff.wrap(buffer, RefCnt.create());
    }

    private static ByteBuff wrap(List<ByteBuffer> buffers, RefCnt refCnt) {
        if (buffers == null || buffers.size() == 0) {
            throw new IllegalArgumentException("buffers shouldn't be null or empty");
        }
        return buffers.size() == 1 ? new SingleByteBuff(refCnt, buffers.get(0)) : new MultiByteBuff(refCnt, buffers.toArray(new ByteBuffer[0]));
    }

    private static ByteBuff wrap(ByteBuffer buffer, RefCnt refCnt) {
        return new SingleByteBuff(refCnt, buffer);
    }

    @FunctionalInterface
    static interface ChannelReader {
        public int read(ReadableByteChannel var1, ByteBuffer var2, long var3) throws IOException;
    }
}

